/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerExImplKt;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.GuiUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class StartupManagerImpl
extends StartupManagerEx {
    private static final Logger LOG = Logger.getInstance(StartupManagerImpl.class);
    private static final long EDT_WARN_THRESHOLD_IN_NANO = TimeUnit.MILLISECONDS.toNanos(100L);
    private final Object myLock;
    private final Deque<Runnable> startupActivities;
    private final Deque<Runnable> postStartupActivities;
    private volatile int postStartupActivitiesPassed;
    private final CompletableFuture<Object> allActivitiesPassed;
    private static final int DUMB_AWARE_PASSED = 1;
    private static final int ALL_PASSED = 2;
    private volatile boolean myStartupActivitiesPassed;
    private final Project myProject;

    public StartupManagerImpl(@NotNull Project project) {
        if (project == null) {
            StartupManagerImpl.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.startupActivities = new ArrayDeque<Runnable>();
        this.postStartupActivities = new ArrayDeque<Runnable>();
        this.allActivitiesPassed = new CompletableFuture();
        this.myProject = project;
    }

    private void checkNonDefaultProject() {
        LOG.assertTrue(!this.myProject.isDefault(), (Object)"Please don't register startup activities for the default project: they won't ever be run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(1);
        }
        this.checkNonDefaultProject();
        LOG.assertTrue(!this.myStartupActivitiesPassed, (Object)"Registering startup activity that will never be run");
        Object object = this.myLock;
        synchronized (object) {
            this.startupActivities.add(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPostStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(2);
        }
        if (DumbService.isDumbAware((Object)runnable2)) {
            this.runAfterOpened(runnable2);
            return;
        }
        this.checkNonDefaultProject();
        this.checkThatPostActivitiesNotPassed();
        LOG.warn("Activities registered via registerPostStartupActivity must be dumb-aware: " + runnable2);
        Object object = this.myLock;
        synchronized (object) {
            this.checkThatPostActivitiesNotPassed();
            this.postStartupActivities.add((Runnable)((DumbAwareRunnable)() -> DumbService.getInstance((Project)this.myProject).unsafeRunWhenSmart(runnable2)));
        }
    }

    private void checkThatPostActivitiesNotPassed() {
        if (this.postStartupActivityPassed()) {
            LOG.error("Registering post-startup activity that will never be run: disposed=" + this.myProject.isDisposed() + "; open=" + this.myProject.isOpen() + "; passed=" + this.myStartupActivitiesPassed);
        }
    }

    @Override
    public boolean startupActivityPassed() {
        return this.myStartupActivitiesPassed;
    }

    public boolean postStartupActivityPassed() {
        return this.postStartupActivitiesPassed == 2;
    }

    @Override
    @NotNull
    public Future<Object> getAllActivitiesPassedFuture() {
        CompletableFuture<Object> completableFuture = this.allActivitiesPassed;
        if (completableFuture == null) {
            StartupManagerImpl.$$$reportNull$$$0(3);
        }
        return completableFuture;
    }

    public final void projectOpened(@Nullable ProgressIndicator indicator) {
        Application app = ApplicationManager.getApplication();
        if (indicator != null && app.isInternal()) {
            indicator.setText(IdeBundle.message((String)"startup.indicator.text.running.startup.activities", (Object[])new Object[0]));
        }
        this.runStartUpActivities(indicator);
        if (indicator != null) {
            indicator.checkCanceled();
        }
        LoadingState phase = DumbService.isDumb((Project)this.myProject) ? LoadingState.PROJECT_OPENED : LoadingState.INDEXING_FINISHED;
        StartUpMeasurer.compareAndSetCurrentState((LoadingState)LoadingState.COMPONENTS_LOADED, (LoadingState)phase);
        if (app.isUnitTestMode() && !app.isDispatchThread()) {
            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, this::runPostStartupActivities);
        } else {
            AppExecutorUtil.getAppExecutorService().execute(() -> {
                if (!this.myProject.isDisposed()) {
                    BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, this::runPostStartupActivities);
                }
            });
            if (app.isUnitTestMode()) {
                LOG.assertTrue(app.isDispatchThread());
                ProjectManagerExImplKt.waitAndProcessInvocationEventsInIdeEventQueue(this);
            }
        }
    }

    private void runStartUpActivities(@Nullable ProgressIndicator indicator) {
        LOG.assertTrue(!this.myStartupActivitiesPassed);
        Activity activity = StartUpMeasurer.startMainActivity((String)"project startup");
        this.runActivities(this.startupActivities, indicator, null);
        ExtensionsAreaImpl area = (ExtensionsAreaImpl)ApplicationManager.getApplication().getExtensionArea();
        this.executeActivitiesFromExtensionPoint(indicator, (ExtensionPointImpl<StartupActivity>)area.getExtensionPoint("com.intellij.startupActivity"));
        this.myStartupActivitiesPassed = true;
        activity.end();
    }

    private void executeActivitiesFromExtensionPoint(@Nullable ProgressIndicator indicator, @NotNull ExtensionPointImpl<StartupActivity> extensionPoint) {
        if (extensionPoint == null) {
            StartupManagerImpl.$$$reportNull$$$0(4);
        }
        extensionPoint.processImplementations(true, (supplier2, pluginDescriptor) -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PluginId id2 = pluginDescriptor.getPluginId();
            if (id2 != PluginManagerCore.CORE_ID && id2 != PluginManagerCore.JAVA_PLUGIN_ID && !id2.getIdString().equals("com.jetbrains.performancePlugin") && !id2.getIdString().equals("com.intellij.kotlinNative.platformDeps")) {
                LOG.error("Only bundled plugin can define " + extensionPoint.getName() + ": " + pluginDescriptor);
                return;
            }
            if (indicator != null) {
                indicator.checkCanceled();
            }
            try {
                this.runActivity(null, (StartupActivity)supplier2.get(), (PluginDescriptor)pluginDescriptor, indicator);
            }
            catch (ExtensionNotApplicableException extensionNotApplicableException) {
                // empty catch block
            }
        });
    }

    private void runPostStartupActivities() {
        LOG.assertTrue(this.myStartupActivitiesPassed);
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        Activity dumbAwareActivity = StartUpMeasurer.startMainActivity((String)"project post-startup dumb-aware activities");
        AtomicReference<Activity> edtActivity = new AtomicReference<Activity>();
        AtomicBoolean uiFreezeWarned = new AtomicBoolean();
        AtomicInteger counter = new AtomicInteger();
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        StartupActivity.POST_STARTUP_ACTIVITY.processWithPluginDescriptor((extension, pluginDescriptor) -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (DumbService.isDumbAware((Object)extension)) {
                this.runActivity(null, (StartupActivity)extension, (PluginDescriptor)pluginDescriptor, ProgressIndicatorProvider.getGlobalProgressIndicator());
                return;
            }
            if (edtActivity.get() == null) {
                edtActivity.set(StartUpMeasurer.startMainActivity((String)"project post-startup edt activities"));
            }
            counter.incrementAndGet();
            dumbService.unsafeRunWhenSmart(() -> {
                this.runActivity(uiFreezeWarned, (StartupActivity)extension, (PluginDescriptor)pluginDescriptor, ProgressIndicatorProvider.getGlobalProgressIndicator());
                StartupManagerImpl.dumbUnawarePostActivitiesPassed(edtActivity, counter.decrementAndGet());
            });
        });
        StartupManagerImpl.dumbUnawarePostActivitiesPassed(edtActivity, counter.get());
        if (this.myProject.isDisposed()) {
            return;
        }
        this.runPostStartupActivitiesRegisteredDynamically();
        dumbAwareActivity.end();
        snapshot.logResponsivenessSinceCreation("Post-startup activities under progress");
        if (!this.myProject.isDisposed() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleBackgroundPostStartupActivities();
            StartupManagerImpl.addActivityEpListener(this.myProject);
        }
    }

    @TestOnly
    public static void addActivityEpListener(final @NotNull Project project) {
        if (project == null) {
            StartupManagerImpl.$$$reportNull$$$0(5);
        }
        StartupActivity.POST_STARTUP_ACTIVITY.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<StartupActivity>(){

            public void extensionAdded(@NotNull StartupActivity extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)project);
                if (DumbService.isDumbAware((Object)extension)) {
                    AppExecutorUtil.getAppExecutorService().execute(() -> {
                        if (!project.isDisposed()) {
                            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)project, () -> startupManager.runActivity(null, extension, pluginDescriptor, ProgressManager.getInstance().getProgressIndicator()));
                        }
                    });
                } else {
                    DumbService.getInstance((Project)project).unsafeRunWhenSmart(() -> startupManager.runActivity(null, extension, pluginDescriptor, ProgressIndicatorProvider.getGlobalProgressIndicator()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/startup/impl/StartupManagerImpl$1";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    private static void dumbUnawarePostActivitiesPassed(@NotNull AtomicReference<Activity> edtActivity, int count) {
        if (edtActivity == null) {
            StartupManagerImpl.$$$reportNull$$$0(6);
        }
        if (count != 0) {
            return;
        }
        Activity activity = edtActivity.getAndSet(null);
        if (activity != null) {
            activity.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runActivity(@Nullable AtomicBoolean uiFreezeWarned, @NotNull StartupActivity extension, @NotNull PluginDescriptor pluginDescriptor, @Nullable ProgressIndicator indicator) {
        if (extension == null) {
            StartupManagerImpl.$$$reportNull$$$0(7);
        }
        if (pluginDescriptor == null) {
            StartupManagerImpl.$$$reportNull$$$0(8);
        }
        if (indicator != null) {
            indicator.pushState();
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        try {
            this.runStartupActivity(extension);
        }
        catch (ServiceNotReadyException e) {
            LOG.error((Throwable)new Exception((Throwable)((Object)e)));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        finally {
            if (indicator != null) {
                indicator.popState();
            }
        }
        String pluginId = pluginDescriptor.getPluginId().getIdString();
        long duration = StartUpMeasurer.addCompletedActivity((long)startTime, extension.getClass(), (ActivityCategory)ActivityCategory.POST_STARTUP_ACTIVITY, (String)pluginId, (long)StartUpMeasurer.MEASURE_THRESHOLD);
        if (uiFreezeWarned != null && duration > EDT_WARN_THRESHOLD_IN_NANO) {
            StartupManagerImpl.reportUiFreeze(uiFreezeWarned);
        }
    }

    private void runStartupActivity(@NotNull StartupActivity activity) {
        if (activity == null) {
            StartupManagerImpl.$$$reportNull$$$0(9);
        }
        if (!LightEdit.owns((Project)this.myProject) || activity instanceof LightEditCompatible) {
            activity.runActivity(this.myProject);
        }
    }

    private static void reportUiFreeze(@NotNull AtomicBoolean uiFreezeWarned) {
        Application app;
        if (uiFreezeWarned == null) {
            StartupManagerImpl.$$$reportNull$$$0(10);
        }
        if (!(app = ApplicationManager.getApplication()).isUnitTestMode() && app.isDispatchThread() && uiFreezeWarned.compareAndSet(false, true)) {
            LOG.info("Some post-startup activities freeze UI for noticeable time. Please consider making them DumbAware to run them in background under modal progress, or just making them faster to speed up project opening.");
        }
    }

    private void runPostStartupActivitiesRegisteredDynamically() {
        this.runActivities(this.postStartupActivities, null, "project post-startup");
        this.postStartupActivitiesPassed = 1;
        DumbService.getInstance((Project)this.myProject).unsafeRunWhenSmart(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = StartupManagerImpl.this.myLock;
                synchronized (object) {
                    if (StartupManagerImpl.this.postStartupActivities.isEmpty()) {
                        StartupManagerImpl.this.postStartupActivitiesPassed = 2;
                        StartupManagerImpl.this.allActivitiesPassed.complete(null);
                        return;
                    }
                }
                StartupManagerImpl.this.runActivities(StartupManagerImpl.this.postStartupActivities, null, null);
                DumbService dumbService = DumbService.getInstance((Project)StartupManagerImpl.this.myProject);
                if (dumbService.isDumb()) {
                    dumbService.unsafeRunWhenSmart((Runnable)this);
                } else {
                    StartupManagerImpl.this.postStartupActivitiesPassed = 2;
                    StartupManagerImpl.this.allActivitiesPassed.complete(null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runActivities(@NotNull Deque<? extends Runnable> activities, @Nullable ProgressIndicator indicator, @Nullable String activityName) {
        if (activities == null) {
            StartupManagerImpl.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (activities.isEmpty()) {
                return;
            }
        }
        Activity activity = activityName == null ? null : StartUpMeasurer.startMainActivity((String)activityName);
        while (true) {
            Runnable runnable2;
            Object object2 = this.myLock;
            synchronized (object2) {
                runnable2 = activities.pollFirst();
            }
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (runnable2 == null) break;
            long startTime = StartUpMeasurer.getCurrentTime();
            ClassLoader loader2 = runnable2.getClass().getClassLoader();
            String pluginId = loader2 instanceof PluginClassLoader ? ((PluginClassLoader)((Object)loader2)).getPluginId().getIdString() : PluginManagerCore.CORE_ID.getIdString();
            StartupManagerImpl.runActivity(runnable2);
            StartUpMeasurer.addCompletedActivity((long)startTime, runnable2.getClass(), (ActivityCategory)ActivityCategory.POST_STARTUP_ACTIVITY, (String)pluginId, (long)StartUpMeasurer.MEASURE_THRESHOLD);
        }
        if (activity != null) {
            activity.end();
        }
    }

    private void scheduleBackgroundPostStartupActivities() {
        ScheduledFuture<?> scheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            long startTimeNano = System.nanoTime();
            StartupActivity.BACKGROUND_POST_STARTUP_ACTIVITY.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<StartupActivity.Background>(){

                public void extensionAdded(@NotNull StartupActivity.Background extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (pluginDescriptor == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    StartupManagerImpl.this.runStartupActivity((StartupActivity)extension);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "extension";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "pluginDescriptor";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ide/startup/impl/StartupManagerImpl$3";
                    objectArray[2] = "extensionAdded";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)this.myProject);
            List activities = StartupActivity.BACKGROUND_POST_STARTUP_ACTIVITY.getExtensionList();
            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> {
                for (StartupActivity activity : activities) {
                    ProgressManager.checkCanceled();
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    this.runStartupActivity(activity);
                }
            });
            if (LOG.isDebugEnabled()) {
                LOG.debug("Background post-startup activities done in " + TimeoutUtil.getDurationMillis((long)startTimeNano) + "ms");
            }
        }, (long)Registry.intValue((String)"ide.background.post.startup.activity.delay"), TimeUnit.MILLISECONDS);
        Disposer.register((Disposable)this.myProject, () -> scheduledFuture.cancel(false));
    }

    public static void runActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(12);
        }
        ProgressManager.checkCanceled();
        try {
            runnable2.run();
        }
        catch (ServiceNotReadyException e) {
            LOG.error((Throwable)new Exception((Throwable)((Object)e)));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    public void runWhenProjectIsInitialized(@NotNull Runnable action2) {
        if (action2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(13);
        }
        if (DumbService.isDumbAware((Object)action2)) {
            this.runAfterOpened(() -> GuiUtils.invokeLaterIfNeeded((Runnable)action2, (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed()));
        } else {
            this.runAfterOpened(() -> DumbService.getInstance((Project)this.myProject).unsafeRunWhenSmart(action2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAfterOpened(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(14);
        }
        this.checkNonDefaultProject();
        if (this.postStartupActivitiesPassed < 1) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.postStartupActivitiesPassed < 1) {
                    this.postStartupActivities.add(runnable2);
                    return;
                }
            }
        }
        runnable2.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public synchronized void prepareForNextTest() {
        Object object = this.myLock;
        synchronized (object) {
            this.startupActivities.clear();
            this.postStartupActivities.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public synchronized void checkCleared() {
        try {
            Object object = this.myLock;
            synchronized (object) {
                assert (this.startupActivities.isEmpty()) : "Activities: " + this.startupActivities;
                assert (this.postStartupActivities.isEmpty()) : "DumbAware Post Activities: " + this.postStartupActivities;
            }
        }
        finally {
            this.prepareForNextTest();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/startup/impl/StartupManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtActivity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiFreezeWarned";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activities";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/startup/impl/StartupManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllActivitiesPassedFuture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerStartupActivity";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerPostStartupActivity";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeActivitiesFromExtensionPoint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addActivityEpListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dumbUnawarePostActivitiesPassed";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runStartupActivity";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportUiFreeze";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runActivities";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runWhenProjectIsInitialized";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runAfterOpened";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

