/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.util.RecommendationDescription;
import com.intellij.ide.util.ServerRecommendation;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipsOrderUtil;
import com.intellij.ide.util.TipsOrderUtilKt;
import com.intellij.ide.util.TipsRequest;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.local.ActionsLocalSummary;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.HttpRequests;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/util/TipsOrderUtil;", "", "()V", "serverRecommendation", "Lcom/intellij/ide/util/ServerRecommendation;", "sort", "Lcom/intellij/ide/util/RecommendationDescription;", "tips", "", "Lcom/intellij/ide/util/TipAndTrickBean;", "Companion", "RecommendationsStartupActivity", "intellij.platform.ide.impl"})
public final class TipsOrderUtil {
    private volatile ServerRecommendation serverRecommendation;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final RecommendationDescription sort(@NotNull List<? extends TipAndTrickBean> tips) {
        Intrinsics.checkNotNullParameter(tips, (String)"tips");
        Object object = this.serverRecommendation;
        if (object == null || (object = ((ServerRecommendation)object).reorder(tips)) == null) {
            object = new RecommendationDescription("default_shuffle", CollectionsKt.shuffled((Iterable)tips), null);
        }
        return object;
    }

    public static final /* synthetic */ ServerRecommendation access$getServerRecommendation$p(TipsOrderUtil $this) {
        return $this.serverRecommendation;
    }

    public static final /* synthetic */ void access$setServerRecommendation$p(TipsOrderUtil $this, ServerRecommendation serverRecommendation) {
        $this.serverRecommendation = serverRecommendation;
    }

    @JvmStatic
    private static final void sync() {
        TipsOrderUtil.Companion.sync();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/util/TipsOrderUtil$RecommendationsStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "alarm", "Lcom/intellij/util/Alarm;", "getAlarm$annotations", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "scheduleSyncRequest", "intellij.platform.ide.impl"})
    private static final class RecommendationsStartupActivity
    implements StartupActivity.DumbAware {
        private final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());

        private static /* synthetic */ void getAlarm$annotations() {
        }

        public void runActivity(@NotNull Project project) {
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    if (!application.isEAP() || !StatisticsUploadAssistant.isSendAllowed()) break block2;
                    Application application2 = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
                    if (!application2.isHeadlessEnvironment()) break block3;
                }
                return;
            }
            this.scheduleSyncRequest();
        }

        private final void scheduleSyncRequest() {
            this.alarm.addRequest(new Runnable(this){
                final /* synthetic */ RecommendationsStartupActivity this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    try {
                        com.intellij.ide.util.TipsOrderUtil$Companion.access$sync(TipsOrderUtil.Companion);
                    }
                    finally {
                        RecommendationsStartupActivity.access$getAlarm$p(this.this$0).addRequest((Runnable)scheduleSyncRequest.1.INSTANCE, TimeUnit.HOURS.toMillis(3L));
                    }
                }
                {
                    this.this$0 = recommendationsStartupActivity;
                }
            }, 0);
        }

        public static final /* synthetic */ Alarm access$getAlarm$p(RecommendationsStartupActivity $this) {
            return $this.alarm;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/util/TipsOrderUtil$Companion;", "", "()V", "sync", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        private final void sync() {
            void $this$mapTo$iv$iv;
            String string;
            Object object;
            Logger logger = TipsOrderUtilKt.access$getLOG$p();
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            logger.assertTrue(!application.isDispatchThread());
            Logger $this$debug$iv = TipsOrderUtilKt.access$getLOG$p();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                object = $this$debug$iv;
                boolean bl = false;
                string = "Fetching tips order from the server: https://feature-recommendation.analytics.aws.intellij.net/tips/v1";
                object.debug(string, (Throwable)e$iv);
            }
            ExtensionPointName<TipAndTrickBean> extensionPointName = TipAndTrickBean.EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"TipAndTrickBean.EP_NAME");
            List list2 = extensionPointName.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"TipAndTrickBean.EP_NAME.extensionList");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TipAndTrickBean tipAndTrickBean = (TipAndTrickBean)((Object)item$iv$iv);
                object = destination$iv$iv;
                boolean bl2 = false;
                string = it.fileName;
                object.add(string);
            }
            List allTips = (List)destination$iv$iv;
            boolean $i$f$service = false;
            Object object2 = ApplicationManager.getApplication().getService(ActionsLocalSummary.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            Map actionsSummary = ((ActionsLocalSummary)object2).getActionsStats();
            long startTimestamp = System.currentTimeMillis();
            HttpRequests.post((String)"https://feature-recommendation.analytics.aws.intellij.net/tips/v1", (String)"application/json; charset=utf-8").connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Unit>(allTips, actionsSummary, startTimestamp){
                final /* synthetic */ List $allTips;
                final /* synthetic */ Map $actionsSummary;
                final /* synthetic */ long $startTimestamp;

                public final void process(@NotNull HttpRequests.Request request) {
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    int bucket = EventLogConfiguration.INSTANCE.getBucket();
                    String string = PlatformUtils.getPlatformPrefix();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PlatformUtils.getPlatformPrefix()");
                    TipsRequest tipsRequest = new TipsRequest(this.$allTips, this.$actionsSummary, string, bucket);
                    ObjectMapper objectMapper2 = new ObjectMapper();
                    request.write(objectMapper2.writeValueAsBytes((Object)tipsRequest));
                    ServerRecommendation recommendation = (ServerRecommendation)objectMapper2.readValue(request.readString(), ServerRecommendation.class);
                    Logger $this$debug$iv = TipsOrderUtilKt.access$getLOG$p();
                    Exception e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        Logger logger = $this$debug$iv;
                        boolean bl = false;
                        long duration = System.currentTimeMillis() - this.$startTimestamp;
                        String algorithmInfo = recommendation.usedAlgorithm + ':' + recommendation.version;
                        String string2 = "Server recommendation made. Algorithm: " + algorithmInfo + ". Duration: " + duration;
                        logger.debug(string2, (Throwable)e$iv);
                    }
                    boolean $i$f$service = false;
                    Object object = ApplicationManager.getApplication().getService(TipsOrderUtil.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
                    TipsOrderUtil.access$setServerRecommendation$p((TipsOrderUtil)object, recommendation);
                }
                {
                    this.$allTips = list2;
                    this.$actionsSummary = map2;
                    this.$startTimestamp = l;
                }
            }, null, TipsOrderUtilKt.access$getLOG$p());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

