/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DefaultColorSchemesManager", defaultStateAsResource=true, storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
@Service
@ApiStatus.Internal
public final class DefaultColorSchemesManager {
    private static final String SCHEME_ELEMENT = "scheme";
    private volatile List<DefaultColorsScheme> mySchemes = Collections.emptyList();

    public static DefaultColorSchemesManager getInstance() {
        return (DefaultColorSchemesManager)ApplicationManager.getApplication().getService(DefaultColorSchemesManager.class);
    }

    public DefaultColorSchemesManager() {
        this.reload();
    }

    public void reload() {
        try {
            this.loadState(JDOMUtil.load(DefaultColorSchemesManager.class, (String)"/DefaultColorSchemesManager.xml"));
        }
        catch (IOException | JDOMException e) {
            ExceptionUtil.rethrow((Throwable)e);
            this.mySchemes = Collections.emptyList();
        }
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DefaultColorSchemesManager.$$$reportNull$$$0(0);
        }
        ArrayList<DefaultColorsScheme> schemes = new ArrayList<DefaultColorsScheme>();
        for (Element schemeElement : state.getChildren(SCHEME_ELEMENT)) {
            boolean isUpdated = false;
            Attribute nameAttr = schemeElement.getAttribute("name");
            if (nameAttr != null) {
                for (DefaultColorsScheme oldScheme : this.mySchemes) {
                    if (!StringUtil.equals((CharSequence)nameAttr.getValue(), (CharSequence)oldScheme.getName())) continue;
                    oldScheme.readExternal(schemeElement);
                    schemes.add(oldScheme);
                    isUpdated = true;
                }
            }
            if (isUpdated) continue;
            DefaultColorsScheme newScheme = new DefaultColorsScheme();
            newScheme.readExternal(schemeElement);
            schemes.add(newScheme);
        }
        schemes.add(EmptyColorScheme.INSTANCE);
        this.mySchemes = Collections.unmodifiableList(schemes);
    }

    @NotNull
    public List<DefaultColorsScheme> getAllSchemes() {
        List<DefaultColorsScheme> list2 = this.mySchemes;
        if (list2 == null) {
            DefaultColorSchemesManager.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public @NotNull List<@NonNls String> listNames() {
        String[] names2 = new String[this.mySchemes.size()];
        for (int i2 = 0; i2 < names2.length; ++i2) {
            names2[i2] = this.mySchemes.get(i2).getName();
        }
        List<String> list2 = Arrays.asList(names2);
        if (list2 == null) {
            DefaultColorSchemesManager.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public DefaultColorsScheme getFirstScheme() {
        DefaultColorsScheme defaultColorsScheme = this.mySchemes.get(0);
        if (defaultColorsScheme == null) {
            DefaultColorSchemesManager.$$$reportNull$$$0(3);
        }
        return defaultColorsScheme;
    }

    @Nullable
    public EditorColorsScheme getScheme(String name) {
        for (DefaultColorsScheme scheme : this.mySchemes) {
            if (!name.equals(scheme.getName())) continue;
            return scheme;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/ex/DefaultColorSchemesManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/ex/DefaultColorSchemesManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSchemes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "listNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

