/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectRefreshListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectAware;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "project", "Lcom/intellij/openapi/project/Project;", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "autoImportAware", "Lcom/intellij/openapi/externalSystem/ExternalSystemAutoImportAware;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;Lcom/intellij/openapi/externalSystem/ExternalSystemAutoImportAware;)V", "externalProjectFiles", "", "Ljava/io/File;", "getExternalProjectFiles", "()Ljava/util/List;", "getProjectId", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "projectPath", "", "settingsFiles", "", "getSettingsFiles", "()Ljava/util/Set;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "reloadProject", "", "context", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectReloadContext;", "subscribe", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectRefreshListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "TaskNotificationListener", "intellij.platform.externalSystem.impl"})
public final class ProjectAware
implements ExternalSystemProjectAware {
    private final ProjectSystemId systemId;
    private final String projectPath;
    private final Project project;
    @NotNull
    private final ExternalSystemProjectId projectId;
    private final ExternalSystemAutoImportAware autoImportAware;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getSettingsFiles() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getExternalProjectFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = FileUtil.toCanonicalPath((String)it.getPath());
            collection.add(string);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final List<File> getExternalProjectFiles() {
        List list2 = this.autoImportAware.getAffectedExternalProjectFiles(this.projectPath, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"autoImportAware.getAffec\u2026les(projectPath, project)");
        return list2;
    }

    public void subscribe(@NotNull ExternalSystemProjectRefreshListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)new TaskNotificationListener(listener2), parentDisposable);
    }

    public void reloadProject(@NotNull ExternalSystemProjectReloadContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ImportSpecBuilder importSpec = new ImportSpecBuilder(this.project, this.systemId);
        if (!context.isExplicitReload()) {
            importSpec.dontReportRefreshErrors();
        }
        ExternalSystemUtil.refreshProject(this.projectPath, importSpec);
    }

    @NotNull
    public ExternalSystemProjectId getProjectId() {
        return this.projectId;
    }

    public ProjectAware(@NotNull Project project, @NotNull ExternalSystemProjectId projectId, @NotNull ExternalSystemAutoImportAware autoImportAware) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)autoImportAware, (String)"autoImportAware");
        this.project = project;
        this.projectId = projectId;
        this.autoImportAware = autoImportAware;
        this.systemId = this.getProjectId().getSystemId();
        this.projectPath = this.getProjectId().getExternalProjectPath();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u001c\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectAware$TaskNotificationListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListenerAdapter;", "delegate", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectRefreshListener;", "(Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectAware;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectRefreshListener;)V", "getDelegate", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectRefreshListener;", "externalSystemTaskId", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "getExternalSystemTaskId", "()Ljava/util/concurrent/atomic/AtomicReference;", "setExternalSystemTaskId", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "afterProjectRefresh", "", "id", "status", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemRefreshStatus;", "onCancel", "onFailure", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onStart", "workingDir", "", "onSuccess", "intellij.platform.externalSystem.impl"})
    private final class TaskNotificationListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        @NotNull
        private AtomicReference<ExternalSystemTaskId> externalSystemTaskId;
        @NotNull
        private final ExternalSystemProjectRefreshListener delegate;

        @NotNull
        public final AtomicReference<ExternalSystemTaskId> getExternalSystemTaskId() {
            return this.externalSystemTaskId;
        }

        public final void setExternalSystemTaskId(@NotNull AtomicReference<ExternalSystemTaskId> atomicReference) {
            Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
            this.externalSystemTaskId = atomicReference;
        }

        public void onStart(@NotNull ExternalSystemTaskId id2, @Nullable String workingDir) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            if (id2.getType() != ExternalSystemTaskType.RESOLVE_PROJECT) {
                return;
            }
            if (!FileUtil.pathsEqual((String)workingDir, (String)ProjectAware.this.projectPath)) {
                return;
            }
            ExternalSystemTask task2 = ((ExternalSystemProcessingManager)ApplicationManager.getApplication().getService(ExternalSystemProcessingManager.class)).findTask(id2);
            if (task2 instanceof ExternalSystemResolveProjectTask && !ProjectAware.this.autoImportAware.isApplicable(((ExternalSystemResolveProjectTask)task2).getResolverPolicy())) {
                return;
            }
            this.externalSystemTaskId.set(id2);
            this.delegate.beforeProjectRefresh();
        }

        private final void afterProjectRefresh(ExternalSystemTaskId id2, ExternalSystemRefreshStatus status) {
            if (id2.getType() != ExternalSystemTaskType.RESOLVE_PROJECT) {
                return;
            }
            if (!this.externalSystemTaskId.compareAndSet(id2, null)) {
                return;
            }
            this.delegate.afterProjectRefresh(status);
        }

        public void onSuccess(@NotNull ExternalSystemTaskId id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            this.afterProjectRefresh(id2, ExternalSystemRefreshStatus.SUCCESS);
        }

        public void onFailure(@NotNull ExternalSystemTaskId id2, @NotNull Exception e) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.afterProjectRefresh(id2, ExternalSystemRefreshStatus.FAILURE);
        }

        public void onCancel(@NotNull ExternalSystemTaskId id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            this.afterProjectRefresh(id2, ExternalSystemRefreshStatus.CANCEL);
        }

        @NotNull
        public final ExternalSystemProjectRefreshListener getDelegate() {
            return this.delegate;
        }

        public TaskNotificationListener(ExternalSystemProjectRefreshListener delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            this.externalSystemTaskId = new AtomicReference<Object>(null);
        }
    }
}

