/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class MoveEditorToOppositeTabGroupAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent event) {
        EditorWindow[] siblings;
        if (event == null) {
            MoveEditorToOppositeTabGroupAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = event.getDataContext();
        VirtualFile vFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (vFile == null || project == null) {
            return;
        }
        EditorWindow window = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
        if (window != null && (siblings = window.findSiblings()).length == 1) {
            EditorWithProviderComposite editorComposite = window.getSelectedEditor();
            HistoryEntry entry = editorComposite.currentStateAsHistoryEntry();
            vFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, (Object)Boolean.TRUE);
            this.closeOldFile(vFile, window);
            ((FileEditorManagerImpl)FileEditorManagerEx.getInstanceEx(project)).openFileImpl3(siblings[0], vFile, true, entry);
            vFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
        }
    }

    protected void closeOldFile(VirtualFile vFile, EditorWindow window) {
        window.closeFile(vFile, true, false);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MoveEditorToOppositeTabGroupAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        VirtualFile vFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        EditorWindow window = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation2.setVisible(MoveEditorToOppositeTabGroupAction.isEnabled(vFile, window));
        } else {
            presentation2.setEnabled(MoveEditorToOppositeTabGroupAction.isEnabled(vFile, window));
        }
    }

    private static boolean isEnabled(VirtualFile vFile, EditorWindow window) {
        EditorWindow[] siblings;
        return vFile != null && window != null && (siblings = window.findSiblings()).length == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/MoveEditorToOppositeTabGroupAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

