/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.ex;

import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.fileTypes.ex.DetectedByContentFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileTypeChooser
extends DialogWrapper {
    private JList<FileType> myList;
    private JLabel myTitleLabel;
    private ComboBox<String> myPattern;
    private JPanel myPanel;
    private JRadioButton myOpenInIdea;
    private JRadioButton myOpenAsNative;
    private JRadioButton myDetectFileType;
    private JBLabel myContextHelpLabel;
    private final String myFileName;

    private FileTypeChooser(@NotNull List<String> patterns, @NotNull String fileName) {
        if (patterns == null) {
            FileTypeChooser.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            FileTypeChooser.$$$reportNull$$$0(1);
        }
        super(true);
        this.myFileName = fileName;
        this.$$$setupUI$$$();
        this.myOpenInIdea.setText(FileTypesBundle.message("filetype.chooser.association", ApplicationNamesInfo.getInstance().getFullProductName()));
        this.myDetectFileType.setText(FileTypesBundle.message("filetype.chooser.autodetect", new Object[0]));
        ActionListener actionListener = e -> {
            this.myList.setEnabled(this.myOpenInIdea.isSelected());
            this.updateContextHelp();
        };
        this.myDetectFileType.addActionListener(actionListener);
        this.myOpenInIdea.addActionListener(actionListener);
        this.myOpenAsNative.addActionListener(actionListener);
        if (fileName.indexOf(46) < 0) {
            this.myDetectFileType.setSelected(true);
            this.myList.setEnabled(false);
        }
        FileType[] fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        Arrays.sort(fileTypes, (ft1, ft2) -> ft1 == null ? 1 : (ft2 == null ? -1 : ft1.getDescription().compareToIgnoreCase(ft2.getDescription())));
        DefaultListModel<FileType> model2 = new DefaultListModel<FileType>();
        for (FileType type : fileTypes) {
            if (type.isReadOnly() || type == FileTypes.UNKNOWN || type instanceof NativeFileType || type == DetectedByContentFileType.INSTANCE) continue;
            model2.addElement(type);
        }
        this.myList.setModel(model2);
        this.myList.addListSelectionListener(e -> this.updateContextHelp());
        this.myPattern.setModel((ComboBoxModel)new CollectionComboBoxModel(ContainerUtil.map(patterns, (Function)FunctionUtil.id()), (Object)patterns.get(0)));
        new ListSpeedSearch<FileType>(this.myList, o -> ((FileType)o).getDescription());
        this.myContextHelpLabel.setForeground(UIUtil.getContextHelpForeground());
        this.updateContextHelp();
        this.setTitle(FileTypesBundle.message("filetype.chooser.title", new Object[0]));
        this.init();
    }

    private void updateContextHelp() {
        FileType selectedType = this.getSelectedType();
        String fileTypeString = selectedType == null ? "" : " | " + selectedType.getDescription();
        this.myContextHelpLabel.setText(FileTypesBundle.message("label.help.change.association", ShowSettingsUtil.getSettingsMenuName(), fileTypeString));
    }

    protected JComponent createCenterPanel() {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(this.myFileName);
        this.myTitleLabel.setText(fileType == FileTypes.UNKNOWN ? FileTypesBundle.message("filetype.chooser.prompt", this.myFileName) : FileTypesBundle.message("filetype.chooser.change.prompt", this.myFileName, fileType.getName()));
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer((ListCellRenderer<FileType>)((Object)new FileTypeRenderer(){

            @Override
            public void customize(@NotNull JList<? extends FileType> list2, FileType value2, int index, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.customize(list2, value2, index, selected2, hasFocus);
                if (!FileTypeChooser.this.myOpenInIdea.isSelected()) {
                    this.setForeground(selected2 ? UIUtil.getListSelectionForeground((boolean)hasFocus) : UIUtil.getComboBoxDisabledForeground());
                    this.setBackground(selected2 ? UIUtil.getListSelectionBackground((boolean)hasFocus) : UIUtil.getComboBoxDisabledBackground());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/fileTypes/ex/FileTypeChooser$1", "customize"));
            }
        }));
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileTypeChooser.this.doOKAction();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileTypes/ex/FileTypeChooser$2", "onDoubleClick"));
            }
        }.installOn(this.myList);
        this.myList.getSelectionModel().addListSelectionListener(__ -> this.updateButtonsState());
        ScrollingUtil.selectItem(this.myList, (Object)FileTypes.PLAIN_TEXT);
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    private void updateButtonsState() {
        this.setOKActionEnabled(this.myList.getSelectedIndex() != -1 || this.myOpenAsNative.isSelected() || this.myDetectFileType.isSelected());
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.fileTypes.FileTypeChooser";
    }

    public FileType getSelectedType() {
        if (this.myDetectFileType.isSelected()) {
            return DetectedByContentFileType.INSTANCE;
        }
        return this.myOpenAsNative.isSelected() ? NativeFileType.INSTANCE : this.myList.getSelectedValue();
    }

    @Nullable
    public static FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @Nullable Project project) {
        FileType type;
        if (file2 == null) {
            FileTypeChooser.$$$reportNull$$$0(2);
        }
        if (project != null && !(file2 instanceof FakeVirtualFile)) {
            PsiManagerEx.getInstanceEx(project).getFileManager().findFile(file2);
        }
        if ((type = file2.getFileType()) == FileTypes.UNKNOWN) {
            type = FileTypeChooser.getKnownFileTypeOrAssociate(file2.getName());
        }
        return type;
    }

    @Nullable
    public static FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile parent, @NotNull String newName2, @Nullable Project project) {
        if (parent == null) {
            FileTypeChooser.$$$reportNull$$$0(3);
        }
        if (newName2 == null) {
            FileTypeChooser.$$$reportNull$$$0(4);
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)new FakeVirtualFile(parent, newName2), project);
    }

    @Nullable
    public static FileType getKnownFileTypeOrAssociate(@NotNull String fileName) {
        FileTypeManager fileTypeManager;
        FileType type;
        if (fileName == null) {
            FileTypeChooser.$$$reportNull$$$0(5);
        }
        if ((type = (fileTypeManager = FileTypeManager.getInstance()).getFileTypeByFileName(fileName)) == FileTypes.UNKNOWN) {
            type = FileTypeChooser.associateFileType(fileName);
        }
        return type;
    }

    @Nullable
    public static FileType associateFileType(@NotNull String fileName) {
        FileTypeChooser chooser;
        if (fileName == null) {
            FileTypeChooser.$$$reportNull$$$0(6);
        }
        if (!(chooser = new FileTypeChooser(FileTypeChooser.suggestPatterns(fileName), fileName)).showAndGet()) {
            return null;
        }
        FileType type = chooser.getSelectedType();
        if (type == FileTypes.UNKNOWN || type == null) {
            return null;
        }
        ApplicationManager.getApplication().runWriteAction(() -> FileTypeManagerEx.getInstanceEx().associatePattern(type, chooser.getSelectedPattern()));
        return type;
    }

    private String getSelectedPattern() {
        return (String)this.myPattern.getSelectedItem();
    }

    @NotNull
    static List<String> suggestPatterns(@NotNull String fileName) {
        if (fileName == null) {
            FileTypeChooser.$$$reportNull$$$0(7);
        }
        LinkedList<String> patterns = new LinkedList<String>();
        int i2 = -1;
        while ((i2 = fileName.indexOf(46, i2 + 1)) > 0) {
            String extension = fileName.substring(i2);
            if (StringUtil.isEmpty((String)extension)) continue;
            patterns.add(0, "*" + extension);
        }
        if (FileTypeManager.getInstance().getFileTypeByFileName(fileName) == FileTypes.UNKNOWN) {
            patterns.add(fileName);
        } else {
            patterns.add(0, fileName);
        }
        LinkedList<String> linkedList = patterns;
        if (linkedList == null) {
            FileTypeChooser.$$$reportNull$$$0(8);
        }
        return linkedList;
    }

    protected String getHelpId() {
        return "reference.dialogs.register.association";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/ex/FileTypeChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/ex/FileTypeChooser";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getKnownFileTypeOrAssociate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "associateFileType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestPatterns";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JBList jBList;
        ComboBox comboBox2;
        JLabel jLabel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTitleLabel = jLabel = new JLabel();
        jLabel.setText("Cannot associate _template_");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/FileTypesBundle", FileTypeChooser.class).getString("filetype.chooser.file.pattern"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPattern = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        jPanel2.add((Component)comboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(5, 0, 1, 2, 0, 3, 7, 7, null, new Dimension(150, 200), null, 2));
        this.myList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        this.myOpenInIdea = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(true);
        jRadioButton3.setText("Open matching files in PRODUCTNAME as type:");
        jPanel2.add((Component)jRadioButton3, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myOpenAsNative = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/IdeBundle", FileTypeChooser.class).getString("radio.button.open.matching.files.in.associated.application"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myDetectFileType = jRadioButton = new JRadioButton();
        jRadioButton.setText("Open matching files in PRODUCTNAME and auto-detect file type");
        jPanel2.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myContextHelpLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor((Component)comboBox2);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton3);
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

