/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate.macos;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.impl.associate.OSFileAssociationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class AppInfoPListReader {
    private static final String BUNDLE_IDENTIFIER = "CFBundleIdentifier";
    private static final String DEBUG_HOME_PATH = System.getProperty("file.association.debug.home.path");
    private static final Logger LOG = Logger.getInstance(AppInfoPListReader.class);
    private Document myDocument;

    AppInfoPListReader() {
    }

    @Nullable
    public String getBundleIdentifier() {
        NodeList dictList = this.getDocument().getElementsByTagName("dict");
        for (int i2 = 0; i2 < dictList.getLength(); ++i2) {
            Node dictNode = dictList.item(i2);
            NodeList dataList = dictNode.getChildNodes();
            for (int j = 0; j < dataList.getLength(); ++j) {
                String value2;
                Node nextNode;
                Node dataNode = dataList.item(j);
                if (!BUNDLE_IDENTIFIER.equals(dataNode.getTextContent())) continue;
                for (nextNode = dataNode.getNextSibling(); nextNode != null && nextNode.getNodeType() != 1; nextNode = nextNode.getNextSibling()) {
                }
                String string = value2 = nextNode != null ? StringUtil.trim((String)nextNode.getTextContent()) : null;
                if (StringUtil.isEmpty((String)value2)) continue;
                return value2;
            }
        }
        return null;
    }

    @NotNull
    private Document getDocument() {
        if (this.myDocument == null) {
            LOG.error("Info.plist not loaded");
        }
        Document document = this.myDocument;
        if (document == null) {
            AppInfoPListReader.$$$reportNull$$$0(0);
        }
        return document;
    }

    @NotNull
    private static File getInfoPListFile() throws OSFileAssociationException {
        String homePath = (String)ObjectUtils.notNull((Object)DEBUG_HOME_PATH, (Object)PathManager.getHomePath());
        File infoFile = new File(homePath + File.separator + "Info.plist");
        if (!infoFile.exists()) {
            throw new OSFileAssociationException("Info.plist was not found at " + homePath + ", please try to reinstall the application");
        }
        File file2 = infoFile;
        if (file2 == null) {
            AppInfoPListReader.$$$reportNull$$$0(1);
        }
        return file2;
    }

    void loadPList() throws OSFileAssociationException {
        DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder2 = factory2.newDocumentBuilder();
            this.myDocument = builder2.parse(AppInfoPListReader.getInfoPListFile());
        }
        catch (ParserConfigurationException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException | SAXException e) {
            throw new OSFileAssociationException("Error reading Info.plist: " + e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/fileTypes/impl/associate/macos/AppInfoPListReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoPListFile";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

