/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate.macos;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.associate.OSAssociateFileTypesUtil;
import com.intellij.openapi.fileTypes.impl.associate.OSFileAssociationException;
import com.intellij.openapi.fileTypes.impl.associate.macos.PListBuddyWrapper;
import com.intellij.openapi.fileTypes.impl.associate.macos.UniformIdentifierUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class LaunchServiceUpdater {
    public static final String UPDATE_FAILURE_MSG = "Launch services PList updated failed, the error is logged.";
    private static final Logger LOG = Logger.getInstance(LaunchServiceUpdater.class);
    private final String myBundleId;
    private final Set<String> myUriSet = new HashSet<String>();
    private final Set<String> myExtensionSet = new HashSet<String>();

    LaunchServiceUpdater(String id2) {
        this.myBundleId = id2;
    }

    void addFileTypes(@NotNull List<FileType> fileTypes) throws OSFileAssociationException {
        if (fileTypes == null) {
            LaunchServiceUpdater.$$$reportNull$$$0(0);
        }
        for (FileType fileType : fileTypes) {
            String[] uri = UniformIdentifierUtil.getURIs(fileType);
            if (uri.length > 0) {
                Collections.addAll(this.myUriSet, UniformIdentifierUtil.getURIs(fileType));
                continue;
            }
            this.myExtensionSet.addAll(OSAssociateFileTypesUtil.getExtensions(fileType));
        }
    }

    void update() throws OSFileAssociationException {
        this.removeExistingEntries();
        for (String uri : this.myUriSet) {
            this.createContentTypeEntry(uri);
        }
        for (String ext : this.myExtensionSet) {
            this.createExtensionEntry(ext);
        }
    }

    private void removeExistingEntries() throws OSFileAssociationException {
        PListBuddyWrapper buddy = new PListBuddyWrapper();
        Document handlers = buddy.readData("LSHandlers");
        Node arrayNode = LaunchServiceUpdater.getTopArrayNode(handlers);
        ArrayList<Integer> entriesToRemove = new ArrayList<Integer>();
        if (arrayNode != null) {
            Node[] entries = LaunchServiceUpdater.getEntries(arrayNode);
            for (int i2 = 0; i2 < entries.length; ++i2) {
                String uri = LaunchServiceUpdater.extractUri(entries[i2]);
                if (!this.myUriSet.contains(uri)) continue;
                entriesToRemove.add(i2);
            }
        }
        if (!entriesToRemove.isEmpty()) {
            Collections.reverse(entriesToRemove);
            for (Integer index : entriesToRemove) {
                PListBuddyWrapper.CommandResult result2 = buddy.runCommand("Delete LSHandlers:" + index);
                if (result2.retCode == 0) continue;
                LOG.warn("PListBuddy returned: " + result2.retCode + " for index " + index);
                throw new OSFileAssociationException(UPDATE_FAILURE_MSG);
            }
        }
    }

    private static Node[] getEntries(@NotNull Node arrayNode) {
        if (arrayNode == null) {
            LaunchServiceUpdater.$$$reportNull$$$0(1);
        }
        ArrayList<Node> entryList = new ArrayList<Node>();
        NodeList children2 = arrayNode.getChildNodes();
        for (int i2 = 0; i2 < children2.getLength(); ++i2) {
            Node child2 = children2.item(i2);
            if (child2.getNodeType() != 1) continue;
            entryList.add(child2);
        }
        return entryList.toArray(new Node[0]);
    }

    @Nullable
    private static Node getTopArrayNode(@NotNull Document document) {
        if (document == null) {
            LaunchServiceUpdater.$$$reportNull$$$0(2);
        }
        NodeList arrayNodes = document.getElementsByTagName("array");
        for (int i2 = 0; i2 < arrayNodes.getLength(); ++i2) {
            Node child2 = arrayNodes.item(i2);
            Node parent = child2.getParentNode();
            if (parent == null || parent.getNodeType() != 1 || !"plist".equals(parent.getNodeName())) continue;
            return child2;
        }
        return null;
    }

    @Nullable
    private static String extractUri(@NotNull Node dictNode) {
        if (dictNode == null) {
            LaunchServiceUpdater.$$$reportNull$$$0(3);
        }
        NodeList children2 = dictNode.getChildNodes();
        for (int i2 = 0; i2 < children2.getLength(); ++i2) {
            Node child2 = children2.item(i2);
            if (child2.getNodeType() != 1 || !"key".equals(child2.getNodeName()) || !"LSHandlerContentType".equals(child2.getTextContent())) continue;
            Node valueNode = child2.getNextSibling();
            if (valueNode != null && valueNode.getNodeType() == 3) {
                valueNode = valueNode.getNextSibling();
            }
            if (valueNode == null) continue;
            assert (valueNode.getNodeType() == 1);
            return valueNode.getTextContent();
        }
        return null;
    }

    private void createContentTypeEntry(@NotNull String uri) throws OSFileAssociationException {
        if (uri == null) {
            LaunchServiceUpdater.$$$reportNull$$$0(4);
        }
        PListBuddyWrapper buddy = new PListBuddyWrapper();
        buddy.runCommand(PListBuddyWrapper.OutputType.DEFAULT, "Add LSHandlers:0 dict", "Add LSHandlers:0:LSHandlerContentType string " + uri, "Add LSHandlers:0:LSHandlerRoleAll string " + this.myBundleId);
    }

    private void createExtensionEntry(@NotNull String extension) throws OSFileAssociationException {
        if (extension == null) {
            LaunchServiceUpdater.$$$reportNull$$$0(5);
        }
        PListBuddyWrapper buddy = new PListBuddyWrapper();
        buddy.runCommand(PListBuddyWrapper.OutputType.DEFAULT, "Add LSHandlers:0 dict", "Add LSHandlers:0:LSHandlerContentTag string " + extension, "Add LSHandlers:0:LSHandlerContentTagClass string public.filename-extension", "Add LSHandlers:0:LSHandlerRoleAll string " + this.myBundleId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/associate/macos/LaunchServiceUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getEntries";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTopArrayNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "extractUri";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createContentTypeEntry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createExtensionEntry";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

