/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate.ui;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.fileTypes.OSFileIdeAssociation;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.impl.associate.OSAssociateFileTypesUtil;
import com.intellij.openapi.fileTypes.impl.associate.OSFileAssociationPreferences;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeAssociationForm {
    private static final int DEFAULT_EXTENSION_SPLIT_THRESHOLD = 5;
    private JPanel myTopPanel;
    private JBScrollPane myScrollPane;
    private JBLabel myDescLabel;
    private JBList myFileTypesList;
    private JBLabel myBottomInfoLabel;
    private List<MyFileTypeItem> myItems;

    public FileTypeAssociationForm() {
        this.$$$setupUI$$$();
        this.myTopPanel.setPreferredSize((Dimension)JBDimension.create((Dimension)new Dimension(800, 600)));
        this.myTopPanel.setBorder((Border)JBUI.Borders.empty());
        this.myScrollPane.setBorder(JBUI.Borders.customLine((Color)JBColor.border()));
        this.myDescLabel.setText(FileTypesBundle.message("filetype.associate.dialog.label", ApplicationInfo.getInstance().getFullApplicationName()));
        this.myBottomInfoLabel.setText(FileTypesBundle.message("filetype.associate.info.label", new Object[0]));
        this.myBottomInfoLabel.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, (Font)this.myBottomInfoLabel.getFont()));
        this.myBottomInfoLabel.setForeground((Color)JBColor.GRAY);
    }

    private void createUIComponents() {
        this.myItems = this.createItems();
        this.presetItems();
        DefaultListModel<MyFileTypeItem> model2 = new DefaultListModel<MyFileTypeItem>();
        CheckBoxList<MyFileTypeItem> checkBoxList = new CheckBoxList<MyFileTypeItem>(model2){

            protected JComponent adjustRendering(JComponent rootComponent, JCheckBox checkBox2, int index, boolean selected2, boolean hasFocus) {
                MyFileTypeItem item = FileTypeAssociationForm.this.myItems.get(index);
                Color textColor = this.getForeground(selected2);
                Color backgroundColor = this.getBackground(selected2);
                JPanel panel2 = new JPanel(new FlowLayout(3, 0, 2));
                if (item.isSubType()) {
                    panel2.add(Box.createRigidArea(new Dimension(JBUIScale.scale((int)20), 1)));
                }
                panel2.add(checkBox2);
                if (!item.isSubType() && !item.isGroupItem()) {
                    JLabel infoLabel = new JLabel(item.getExtensionList(), 2);
                    infoLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)JBUIScale.scale((int)8)));
                    panel2.add(infoLabel);
                    panel2.setBackground(backgroundColor);
                    infoLabel.setForeground(selected2 ? textColor : JBColor.GRAY);
                    infoLabel.setBackground(backgroundColor);
                }
                panel2.setBackground(backgroundColor);
                return panel2;
            }

            @Nullable
            protected Point findPointRelativeToCheckBox(int x, int y, @NotNull JCheckBox checkBox2, int index) {
                if (checkBox2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.findPointRelativeToCheckBoxWithAdjustedRendering(x, y, checkBox2, index);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkBox", "com/intellij/openapi/fileTypes/impl/associate/ui/FileTypeAssociationForm$1", "findPointRelativeToCheckBox"));
            }
        };
        model2.addAll(this.myItems);
        checkBoxList.setCheckBoxListListener(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value2) {
                FileTypeAssociationForm.this.onItemStateChange(FileTypeAssociationForm.this.myItems.get(index), value2);
            }
        });
        this.myFileTypesList = checkBoxList;
        if (!this.myFileTypesList.isEmpty()) {
            this.myFileTypesList.setSelectedIndex(0);
        }
        new ListSpeedSearch(this.myFileTypesList, o -> ((MyFileTypeItem)o).getText());
    }

    public JPanel getTopPanel() {
        return this.myTopPanel;
    }

    @Nullable
    JComponent getPreferredFocusedComponent() {
        return this.myFileTypesList;
    }

    public List<MyFileTypeItem> createItems() {
        ArrayList<MyFileTypeItem> items = new ArrayList<MyFileTypeItem>();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (FileType fileType : fileTypeManager.getRegisteredFileTypes()) {
            int extCount;
            if (!FileTypeAssociationForm.isSupported(fileType) || (extCount = OSAssociateFileTypesUtil.getExtensionMatchers(fileType).size()) <= 0) continue;
            if (FileTypeAssociationForm.splitExtensions(fileType, extCount)) {
                items.add(new MyFileTypeItem(fileType, null, true));
                OSAssociateFileTypesUtil.createSubtypes(fileType).forEach(subtype -> items.add(new MyFileTypeItem((FileType)subtype, fileType, false)));
                continue;
            }
            items.add(new MyFileTypeItem(fileType, null, false));
        }
        Collections.sort(items);
        return new ArrayList<MyFileTypeItem>(items);
    }

    private void presetItems() {
        OSFileAssociationPreferences preferences = OSFileAssociationPreferences.getInstance();
        this.myItems.forEach(item -> {
            boolean selected2 = preferences.contains(item.myFileType);
            item.setSelected(selected2);
            this.onItemStateChange((MyFileTypeItem)item, selected2);
        });
    }

    private static boolean splitExtensions(@NotNull FileType fileType, int extCount) {
        if (fileType == null) {
            FileTypeAssociationForm.$$$reportNull$$$0(0);
        }
        if (fileType instanceof OSFileIdeAssociation) {
            OSFileIdeAssociation.ExtensionMode explicitMode = ((OSFileIdeAssociation)fileType).getExtensionsMode();
            switch (explicitMode) {
                case Selected: {
                    return true;
                }
                case All: {
                    return false;
                }
            }
        }
        return extCount > 5;
    }

    private static boolean isSupported(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeAssociationForm.$$$reportNull$$$0(1);
        }
        return !(fileType instanceof NativeFileType) && !(fileType instanceof UserBinaryFileType) && !(fileType instanceof ArchiveFileType) && (!(fileType instanceof OSFileIdeAssociation) || ((OSFileIdeAssociation)fileType).isFileAssociationAllowed());
    }

    private void onItemStateChange(@NotNull MyFileTypeItem currItem, boolean isSelected) {
        if (currItem == null) {
            FileTypeAssociationForm.$$$reportNull$$$0(2);
        }
        if (currItem.isGroupItem()) {
            this.myItems.stream().filter(subItem -> subItem.mySuperType == currItem.myFileType).forEach(subItem -> subItem.setSelected(isSelected));
        } else if (currItem.mySuperType != null) {
            for (MyFileTypeItem item : this.myItems) {
                if (item.myFileType != currItem.mySuperType) continue;
                item.setState(this.getSuperItemState(currItem));
                break;
            }
        }
    }

    private ThreeStateCheckBox.State getSuperItemState(@NotNull MyFileTypeItem subItem) {
        List withSameSupertype;
        long selected2;
        if (subItem == null) {
            FileTypeAssociationForm.$$$reportNull$$$0(3);
        }
        if ((selected2 = (withSameSupertype = ContainerUtil.filter(this.myItems, item -> item.mySuperType == subItem.mySuperType)).stream().filter(item -> item.isSelected()).count()) == 0L) {
            return ThreeStateCheckBox.State.NOT_SELECTED;
        }
        if (selected2 == (long)withSameSupertype.size()) {
            return ThreeStateCheckBox.State.SELECTED;
        }
        return ThreeStateCheckBox.State.DONT_CARE;
    }

    List<FileType> getSelectedFileTypes() {
        return this.myItems.stream().filter(item -> item.isSelected() && !item.isGroupItem()).map(item -> item.myFileType).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subItem";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/associate/ui/FileTypeAssociationForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "splitExtensions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onItemStateChange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperItemState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBScrollPane jBScrollPane;
        JBLabel jBLabel2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myTopPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDescLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBList jBList = this.myFileTypesList;
        jBScrollPane.setViewportView((Component)jBList);
        this.myBottomInfoLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private static final class MyFileTypeItem
    extends ThreeStateCheckBox
    implements Comparable<MyFileTypeItem> {
        private final FileType myFileType;
        @Nullable
        private final FileType mySuperType;
        private final boolean myIsGroupItem;

        private MyFileTypeItem(@NotNull FileType fileType, @Nullable FileType superType, boolean isGroupItem) {
            if (fileType == null) {
                MyFileTypeItem.$$$reportNull$$$0(0);
            }
            this.myFileType = fileType;
            this.mySuperType = superType;
            this.myIsGroupItem = isGroupItem;
            this.setSelected(false);
            this.setText(this.myFileType.getDescription());
        }

        @NlsSafe
        private String getExtensionList() {
            List<ExtensionFileNameMatcher> matchers = OSAssociateFileTypesUtil.getExtensionMatchers(this.myFileType);
            return String.join((CharSequence)", ", ContainerUtil.map(matchers, FileNameMatcher::getPresentableString));
        }

        @Override
        public int compareTo(@NotNull MyFileTypeItem item) {
            if (item == null) {
                MyFileTypeItem.$$$reportNull$$$0(1);
            }
            if (this.mySuperType != item.mySuperType) {
                String d1 = this.mySuperType != null ? this.mySuperType.getDescription() : this.myFileType.getDescription();
                String d2 = item.mySuperType != null ? item.mySuperType.getDescription() : item.myFileType.getDescription();
                return d1.compareTo(d2);
            }
            int subtypePriority = Boolean.compare(this.isMainSubtype(), item.isMainSubtype());
            if (subtypePriority != 0) {
                return -subtypePriority;
            }
            return this.myFileType.getDescription().compareTo(item.myFileType.getDescription());
        }

        private boolean isSubType() {
            return this.mySuperType != null;
        }

        private boolean isMainSubtype() {
            FileNameMatcher subtypeMatcher = OSAssociateFileTypesUtil.getSubtypeMatcher(this.myFileType);
            return this.mySuperType != null && subtypeMatcher instanceof ExtensionFileNameMatcher && this.mySuperType.getDefaultExtension().equals(((ExtensionFileNameMatcher)subtypeMatcher).getExtension());
        }

        private boolean isGroupItem() {
            return this.myIsGroupItem;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/associate/ui/FileTypeAssociationForm$MyFileTypeItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

