/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class ToggleExcludedStateAction
extends ContentEntryEditingAction {
    private final ContentEntryTreeEditor myEntryTreeEditor;

    public ToggleExcludedStateAction(JTree tree, ContentEntryTreeEditor entryEditor) {
        super(tree);
        this.myEntryTreeEditor = entryEditor;
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(ProjectBundle.messagePointer((String)"module.toggle.excluded.action", (Object[])new Object[0]));
        templatePresentation.setDescription(ProjectBundle.messagePointer((String)"module.toggle.excluded.action.description", (Object[])new Object[0]));
        templatePresentation.setIcon(AllIcons.Modules.ExcludeRoot);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        VirtualFile[] selectedFiles;
        if (e == null) {
            ToggleExcludedStateAction.$$$reportNull$$$0(0);
        }
        if ((selectedFiles = this.getSelectedFiles()).length == 0) {
            return false;
        }
        return this.myEntryTreeEditor.getContentEntryEditor().isExcludedOrUnderExcludedDirectory(selectedFiles[0]);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean isSelected) {
        if (e == null) {
            ToggleExcludedStateAction.$$$reportNull$$$0(1);
        }
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        assert (selectedFiles.length != 0);
        ContentEntryEditor contentEntryEditor = this.myEntryTreeEditor.getContentEntryEditor();
        for (VirtualFile selectedFile : selectedFiles) {
            if (isSelected) {
                if (contentEntryEditor.isExcludedOrUnderExcludedDirectory(selectedFile)) continue;
                contentEntryEditor.addExcludeFolder(selectedFile);
                continue;
            }
            contentEntryEditor.removeExcludeFolder(selectedFile.getUrl());
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleExcludedStateAction.$$$reportNull$$$0(2);
        }
        super.update(e);
        Presentation presentation2 = e.getPresentation();
        presentation2.setText(ProjectBundle.messagePointer((String)"module.toggle.excluded.action", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/actions/ToggleExcludedStateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

