/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.WindowState;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WindowStateBean
implements ModificationTracker,
WindowState {
    private final AtomicLong myModificationCount = new AtomicLong();
    private volatile Point myLocation;
    private volatile Dimension mySize;
    private volatile int myExtendedState;
    private volatile boolean myFullScreen;

    WindowStateBean() {
    }

    public long getModificationCount() {
        return this.myModificationCount.get();
    }

    @Nullable
    public Point getLocation() {
        return WindowStateBean.apply(Point::new, this.myLocation);
    }

    void setLocation(@Nullable Point location) {
        if (Objects.equals(this.myLocation, location)) {
            return;
        }
        this.myLocation = WindowStateBean.apply(Point::new, location);
        this.myModificationCount.getAndIncrement();
    }

    @Nullable
    public Dimension getSize() {
        return WindowStateBean.apply(Dimension::new, this.mySize);
    }

    void setSize(@Nullable Dimension size) {
        if (Objects.equals(this.mySize, size)) {
            return;
        }
        this.mySize = WindowStateBean.apply(Dimension::new, size);
        this.myModificationCount.getAndIncrement();
    }

    public int getExtendedState() {
        return this.myExtendedState;
    }

    void setExtendedState(int extendedState) {
        if (this.myExtendedState == extendedState) {
            return;
        }
        this.myExtendedState = extendedState;
        this.myModificationCount.getAndIncrement();
    }

    public boolean isFullScreen() {
        return this.myFullScreen;
    }

    void setFullScreen(boolean fullScreen) {
        if (this.myFullScreen == fullScreen) {
            return;
        }
        this.myFullScreen = fullScreen;
        this.myModificationCount.getAndIncrement();
    }

    public void applyTo(@NotNull Window window) {
        Frame frame;
        if (window == null) {
            WindowStateBean.$$$reportNull$$$0(0);
        }
        Point location = this.getLocation();
        Dimension size = this.getSize();
        int extendedState = this.getExtendedState();
        Frame frame2 = frame = window instanceof Frame ? (Frame)window : null;
        if (frame != null && 0 != frame.getExtendedState()) {
            frame.setExtendedState(0);
        }
        Rectangle bounds2 = window.getBounds();
        if (location != null) {
            bounds2.setLocation(location);
        }
        if (size != null) {
            bounds2.setSize(size);
        }
        if (bounds2.isEmpty()) {
            bounds2.setSize(window.getPreferredSize());
        }
        window.setBounds(bounds2);
        if (frame != null && 0 != extendedState) {
            frame.setExtendedState(extendedState);
        }
    }

    void applyFrom(@NotNull Window window) {
        if (window == null) {
            WindowStateBean.$$$reportNull$$$0(1);
        }
        if (window.isVisible()) {
            boolean windowFullScreen = WindowStateBean.isFullScreen(window);
            this.setFullScreen(windowFullScreen);
            Frame frame = window instanceof Frame ? (Frame)window : null;
            int windowExtendedState = frame == null ? 0 : frame.getExtendedState();
            this.setExtendedState(windowExtendedState);
            if (!windowFullScreen && windowExtendedState == 0) {
                this.setLocation(window.getLocation());
                this.setSize(window.getSize());
            }
        }
    }

    private static boolean isFullScreen(@NotNull Window window) {
        if (window == null) {
            WindowStateBean.$$$reportNull$$$0(2);
        }
        return window instanceof IdeFrame && FrameInfoHelper.isFullScreenSupportedInCurrentOs() && ((IdeFrame)window).isInFullScreen();
    }

    @Nullable
    private static <T, R> R apply(@NotNull Function<? super T, ? extends R> function, @Nullable T value2) {
        if (function == null) {
            WindowStateBean.$$$reportNull$$$0(3);
        }
        return value2 == null ? null : (R)function.apply((T)value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/WindowStateBean";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFrom";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFullScreen";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

