/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.migrate;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.vcs.changes.actions.migrate.MigrateToNewDiffUtil;
import java.awt.Window;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MigrateDiffTool
implements DiffTool {
    public static final MigrateDiffTool INSTANCE = new MigrateDiffTool();

    private MigrateDiffTool() {
    }

    public void show(com.intellij.openapi.diff.DiffRequest request) {
        if (MigrateDiffTool.isMergeRequest(request)) {
            try {
                MergeRequest newRequest = MigrateToNewDiffUtil.convertMergeRequest((MergeRequestImpl)request);
                DiffManager.getInstance().showMerge(request.getProject(), newRequest);
            }
            catch (InvalidDiffRequestException e) {
                MessagesEx.error(request.getProject(), e.getMessage()).showNow();
            }
        } else {
            DiffRequest newRequest = MigrateToNewDiffUtil.convertRequest(request);
            Runnable onOkRunnable = request.getOnOkRunnable();
            if (onOkRunnable == null) {
                DiffManager.getInstance().showDiff(request.getProject(), newRequest, new DiffDialogHints(MigrateDiffTool.getWindowMode(request.getHints())));
            } else {
                DialogBuilder builder2 = new DialogBuilder(request.getProject());
                DiffRequestPanel diffPanel = DiffManager.getInstance().createRequestPanel(request.getProject(), (Disposable)builder2, builder2.getWindow());
                diffPanel.setRequest(newRequest);
                builder2.setCenterPanel(diffPanel.getComponent());
                builder2.setPreferredFocusComponent(diffPanel.getPreferredFocusedComponent());
                builder2.setTitle(request.getWindowTitle());
                builder2.setDimensionServiceKey(request.getGroupKey());
                builder2.setOkOperation(() -> {
                    builder2.getDialogWrapper().close(0);
                    onOkRunnable.run();
                });
                boolean useNonModal = request.getHints().contains(DiffTool.HINT_SHOW_NOT_MODAL_DIALOG);
                builder2.showModal(!useNonModal);
            }
        }
    }

    public boolean canShow(com.intellij.openapi.diff.DiffRequest request) {
        return request.getContents().length == 2 || request.getContents().length == 3;
    }

    private static boolean isMergeRequest(com.intellij.openapi.diff.DiffRequest request) {
        return request instanceof MergeRequestImpl && ((MergeRequestImpl)request).getMergeContent() != null;
    }

    public DiffViewer createComponent(String title, com.intellij.openapi.diff.DiffRequest request, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MigrateDiffTool.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Nullable
    private static WindowWrapper.Mode getWindowMode(Collection hints2) {
        if (hints2.contains(DiffTool.HINT_SHOW_MODAL_DIALOG)) {
            return WindowWrapper.Mode.MODAL;
        }
        if (hints2.contains(DiffTool.HINT_SHOW_NOT_MODAL_DIALOG)) {
            return WindowWrapper.Mode.NON_MODAL;
        }
        if (hints2.contains(DiffTool.HINT_SHOW_FRAME)) {
            return WindowWrapper.Mode.FRAME;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateDiffTool", "createComponent"));
    }
}

