/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vcs.readOnlyHandler.FileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@com.intellij.openapi.components.State(name="ReadonlyStatusHandler", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ReadonlyStatusHandlerImpl
extends ReadonlyStatusHandler
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(ReadonlyStatusHandlerImpl.class);
    private final Project myProject;
    private boolean myClearReadOnlyInTests;
    private State myState;

    public ReadonlyStatusHandlerImpl(@NotNull Project project) {
        if (project == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myProject = project;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(1);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(2);
        }
        this.myState = state;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ReadonlyStatusHandler.OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> originalFiles) {
        OperationStatusImpl operationStatusImpl;
        if (originalFiles == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(3);
        }
        if (originalFiles.isEmpty()) {
            return new OperationStatusImpl(VirtualFile.EMPTY_ARRAY);
        }
        ReadonlyStatusHandlerImpl.checkThreading();
        HashSet<void> realFiles = new HashSet<void>(originalFiles.size());
        for (VirtualFile virtualFile : originalFiles) {
            void var4_4;
            void var4_7;
            VirtualFile originalFile;
            if (virtualFile instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)virtualFile).getOriginalFile()) != null) {
                VirtualFile virtualFile2 = originalFile;
            }
            if (var4_7 instanceof VirtualFileWindow) {
                VirtualFile virtualFile3 = ((VirtualFileWindow)var4_7).getDelegate();
            }
            if (var4_4 == null) continue;
            realFiles.add(var4_4);
        }
        ArrayList files2 = new ArrayList(realFiles);
        if (!this.myProject.isDefault() && (operationStatusImpl = (OperationStatusImpl)((Object)WritingAccessProvider.EP.computeSafeIfAny((AreaInstance)this.myProject, provider2 -> {
            Collection denied = ContainerUtil.filter((Collection)files2, virtualFile -> !provider2.isPotentiallyWritable(virtualFile));
            if (denied.isEmpty()) {
                denied = provider2.requestWriting(files2);
            }
            if (!denied.isEmpty()) {
                return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray((Collection)denied), provider2.getReadOnlyMessage());
            }
            return null;
        }))) != null) {
            OperationStatusImpl operationStatusImpl2 = operationStatusImpl;
            if (operationStatusImpl2 == null) {
                ReadonlyStatusHandlerImpl.$$$reportNull$$$0(4);
            }
            return operationStatusImpl2;
        }
        List<FileInfo> list2 = this.createFileInfos(files2);
        if (list2.isEmpty()) {
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
            if (operationStatus == null) {
                ReadonlyStatusHandlerImpl.$$$reportNull$$$0(5);
            }
            return operationStatus;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myClearReadOnlyInTests) {
                ReadonlyStatusHandlerImpl.processFiles(new ArrayList<FileInfo>(list2), null);
            }
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
            if (operationStatus == null) {
                ReadonlyStatusHandlerImpl.$$$reportNull$$$0(6);
            }
            return operationStatus;
        }
        int savedEventCount = IdeEventQueue.getInstance().getEventCount();
        if (this.myState.SHOW_DIALOG) {
            new ReadOnlyStatusDialog(this.myProject, list2).show();
        } else {
            ReadonlyStatusHandlerImpl.processFiles(new ArrayList<FileInfo>(list2), null);
        }
        IdeEventQueue.getInstance().setEventCount(savedEventCount);
        ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
        if (operationStatus == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(7);
        }
        return operationStatus;
    }

    private static void checkThreading() {
        Application app = ApplicationManager.getApplication();
        app.assertIsWriteThread();
        if (!app.isWriteAccessAllowed()) {
            return;
        }
        if (app.isUnitTestMode() && Registry.is((String)"tests.assert.clear.read.only.status.outside.write.action")) {
            LOG.error("ensureFilesWritable should be called outside write action");
        }
    }

    private static ReadonlyStatusHandler.OperationStatus createResultStatus(@NotNull Collection<? extends VirtualFile> originalFiles, @NotNull Collection<? extends VirtualFile> files2) {
        if (originalFiles == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(8);
        }
        if (files2 == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(9);
        }
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files2) {
            if (!virtualFile.exists() || virtualFile.isWritable()) continue;
            readOnlyFiles.add(virtualFile);
        }
        assert (!readOnlyFiles.isEmpty() || originalFiles.stream().allMatch(file2 -> file2 == null || file2.isWritable())) : "Original files: " + originalFiles + ", files: " + files2;
        return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray(readOnlyFiles));
    }

    @NotNull
    private List<FileInfo> createFileInfos(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(10);
        }
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        for (VirtualFile virtualFile : files2) {
            if (virtualFile == null || virtualFile.isWritable() || !virtualFile.isInLocalFileSystem()) continue;
            fileInfos.add(new FileInfo(virtualFile, this.myProject));
        }
        ArrayList<FileInfo> arrayList = fileInfos;
        if (arrayList == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public static void processFiles(@NotNull List<FileInfo> fileInfos, @Nullable String changelist) {
        if (fileInfos == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(12);
        }
        FileInfo[] copy2 = fileInfos.toArray(new FileInfo[0]);
        MultiMap handleTypeToFile = new MultiMap();
        for (FileInfo fileInfo : copy2) {
            handleTypeToFile.putValue((Object)fileInfo.getSelectedHandleType(), (Object)fileInfo.getFile());
        }
        for (HandleType handleType : handleTypeToFile.keySet()) {
            handleType.processFiles(handleTypeToFile.get((Object)handleType), changelist);
        }
        for (FileInfo fileInfo : copy2) {
            if (fileInfo.getFile().exists() && !fileInfo.getFile().isWritable()) continue;
            fileInfos.remove(fileInfo);
        }
    }

    @TestOnly
    public void setClearReadOnlyInTests(boolean clearReadOnlyInTests) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myClearReadOnlyInTests = clearReadOnlyInTests;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFilesWritable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createResultStatus";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFileInfos";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OperationStatusImpl
    extends ReadonlyStatusHandler.OperationStatus {
        private final VirtualFile[] myReadonlyFiles;
        @NotNull
        private final @NlsContexts.DialogMessage String myReadOnlyReason;

        OperationStatusImpl(VirtualFile @NotNull [] readonlyFiles) {
            if (readonlyFiles == null) {
                OperationStatusImpl.$$$reportNull$$$0(0);
            }
            this(readonlyFiles, "");
        }

        private OperationStatusImpl(VirtualFile[] readonlyFiles, @NotNull @NlsContexts.DialogMessage String readOnlyReason) {
            if (readOnlyReason == null) {
                OperationStatusImpl.$$$reportNull$$$0(1);
            }
            this.myReadonlyFiles = readonlyFiles;
            this.myReadOnlyReason = readOnlyReason;
        }

        public VirtualFile @NotNull [] getReadonlyFiles() {
            if (this.myReadonlyFiles == null) {
                OperationStatusImpl.$$$reportNull$$$0(2);
            }
            return this.myReadonlyFiles;
        }

        public boolean hasReadonlyFiles() {
            return this.myReadonlyFiles.length > 0;
        }

        @NotNull
        public String getReadonlyFilesMessage() {
            if (this.hasReadonlyFiles()) {
                if (!Strings.isEmpty((String)this.myReadOnlyReason)) {
                    String string = this.myReadOnlyReason;
                    if (string == null) {
                        OperationStatusImpl.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                if (this.myReadonlyFiles.length > 1) {
                    StringBuilder buf = new StringBuilder();
                    for (VirtualFile file2 : this.myReadonlyFiles) {
                        buf.append('\n');
                        buf.append(file2.getPresentableUrl());
                    }
                    String string = IdeBundle.message((String)"failed.to.make.the.following.files.writable.error.message", (Object[])new Object[]{buf.toString()});
                    if (string == null) {
                        OperationStatusImpl.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                String string = IdeBundle.message((String)"failed.to.make.file.writable.error.message", (Object[])new Object[]{this.myReadonlyFiles[0].getPresentableUrl()});
                if (string == null) {
                    OperationStatusImpl.$$$reportNull$$$0(5);
                }
                return string;
            }
            throw new RuntimeException("No readonly files");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readonlyFiles";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readOnlyReason";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl$OperationStatusImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl$OperationStatusImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadonlyFiles";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadonlyFilesMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class State {
        public boolean SHOW_DIALOG = true;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.SHOW_DIALOG == state.SHOW_DIALOG;
        }

        public int hashCode() {
            return this.SHOW_DIALOG ? 1 : 0;
        }
    }
}

