/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates.github;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.util.Producer;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DownloadUtil {
    @NonNls
    public static final String CONTENT_LENGTH_TEMPLATE = "${content-length}";
    private static final Logger LOG = Logger.getInstance(DownloadUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadAtomically(@Nullable ProgressIndicator indicator, @NotNull String url, @NotNull File outputFile, @NotNull File tempFile, @Nullable Predicate<? super String> contentChecker) throws IOException {
        if (url == null) {
            DownloadUtil.$$$reportNull$$$0(0);
        }
        if (outputFile == null) {
            DownloadUtil.$$$reportNull$$$0(1);
        }
        if (tempFile == null) {
            DownloadUtil.$$$reportNull$$$0(2);
        }
        try {
            String content2;
            DownloadUtil.downloadContentToFile(indicator, url, tempFile);
            if (contentChecker != null && !contentChecker.test(content2 = FileUtil.loadFile((File)tempFile))) {
                boolean bl = false;
                return bl;
            }
            FileUtil.rename((File)tempFile, (File)outputFile);
            boolean bl = true;
            return bl;
        }
        finally {
            FileUtil.delete((File)tempFile);
        }
    }

    public static void downloadAtomically(@Nullable ProgressIndicator indicator, @NotNull String url, @NotNull File outputFile) throws IOException {
        if (url == null) {
            DownloadUtil.$$$reportNull$$$0(3);
        }
        if (outputFile == null) {
            DownloadUtil.$$$reportNull$$$0(4);
        }
        File tempFile = FileUtil.createTempFile((String)"for-actual-downloading-", null);
        DownloadUtil.downloadAtomically(indicator, url, outputFile, tempFile, null);
    }

    public static void downloadAtomically(@Nullable ProgressIndicator indicator, @NotNull String url, @NotNull File outputFile, @NotNull File tempFile) throws IOException {
        if (url == null) {
            DownloadUtil.$$$reportNull$$$0(5);
        }
        if (outputFile == null) {
            DownloadUtil.$$$reportNull$$$0(6);
        }
        if (tempFile == null) {
            DownloadUtil.$$$reportNull$$$0(7);
        }
        DownloadUtil.downloadAtomically(indicator, url, outputFile, tempFile, null);
    }

    @NotNull
    public static <V> Outcome<V> provideDataWithProgressSynchronously(@Nullable Project project, @NotNull @NlsContexts.ProgressTitle String progressTitle2, @NotNull @NlsContexts.ProgressText String actionShortDescription, @NotNull Callable<? extends V> supplier2, @Nullable Producer<Boolean> tryAgainProvider) {
        if (progressTitle2 == null) {
            DownloadUtil.$$$reportNull$$$0(8);
        }
        if (actionShortDescription == null) {
            DownloadUtil.$$$reportNull$$$0(9);
        }
        if (supplier2 == null) {
            DownloadUtil.$$$reportNull$$$0(10);
        }
        int attemptNumber = 1;
        while (true) {
            Ref dataRef = Ref.create(null);
            Ref innerExceptionRef = Ref.create(null);
            boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.setText(actionShortDescription);
                try {
                    Object data2 = supplier2.call();
                    dataRef.set(data2);
                }
                catch (Exception ex) {
                    innerExceptionRef.set((Object)ex);
                }
            }, progressTitle2, true, project);
            if (!completed) {
                Outcome outcome = Outcome.createAsCancelled();
                if (outcome == null) {
                    DownloadUtil.$$$reportNull$$$0(11);
                }
                return outcome;
            }
            Exception latestInnerException = (Exception)innerExceptionRef.get();
            if (latestInnerException == null) {
                Outcome<Object> outcome = Outcome.createNormal(dataRef.get());
                if (outcome == null) {
                    DownloadUtil.$$$reportNull$$$0(12);
                }
                return outcome;
            }
            LOG.info("[attempt#" + attemptNumber + "] Cannot '" + actionShortDescription + "'");
            boolean onceMore = false;
            if (tryAgainProvider != null) {
                onceMore = Boolean.TRUE.equals(tryAgainProvider.produce());
            }
            if (!onceMore) {
                Outcome outcome = Outcome.createAsException(latestInnerException);
                if (outcome == null) {
                    DownloadUtil.$$$reportNull$$$0(13);
                }
                return outcome;
            }
            ++attemptNumber;
        }
    }

    public static void downloadContentToFile(@Nullable ProgressIndicator progress2, @NotNull String url, @NotNull File outputFile) throws IOException {
        boolean parentDirExists;
        if (url == null) {
            DownloadUtil.$$$reportNull$$$0(14);
        }
        if (outputFile == null) {
            DownloadUtil.$$$reportNull$$$0(15);
        }
        if (!(parentDirExists = FileUtil.createParentDirs((File)outputFile))) {
            throw new IOException("Parent dir of '" + outputFile.getAbsolutePath() + "' can not be created!");
        }
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            DownloadUtil.download(progress2, url, out);
        }
    }

    private static void download(final @Nullable ProgressIndicator progress2, @NotNull String location, final @NotNull OutputStream output) throws IOException {
        if (location == null) {
            DownloadUtil.$$$reportNull$$$0(16);
        }
        if (output == null) {
            DownloadUtil.$$$reportNull$$$0(17);
        }
        final String originalText = progress2 != null ? progress2.getText() : null;
        DownloadUtil.substituteContentLength(progress2, originalText, -1);
        if (progress2 != null) {
            progress2.setText2(IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{location}));
        }
        HttpRequests.request((String)location).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Object>(){

            public Object process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    int contentLength = request.getConnection().getContentLength();
                    DownloadUtil.substituteContentLength(progress2, originalText, contentLength);
                    NetUtils.copyStreamContent((ProgressIndicator)progress2, (InputStream)request.getInputStream(), (OutputStream)output, (int)contentLength);
                }
                catch (IOException e) {
                    throw new IOException(HttpRequests.createErrorMessage((IOException)e, (HttpRequests.Request)request, (boolean)true), e);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/platform/templates/github/DownloadUtil$1", "process"));
            }
        });
    }

    private static void substituteContentLength(@Nullable ProgressIndicator progress2, @Nullable @NlsContexts.ProgressText String text2, int contentLengthInBytes) {
        int ind;
        if (progress2 != null && text2 != null && (ind = text2.indexOf(CONTENT_LENGTH_TEMPLATE)) != -1) {
            String mes = DownloadUtil.formatContentLength(contentLengthInBytes);
            String newText = text2.substring(0, ind) + mes + text2.substring(ind + CONTENT_LENGTH_TEMPLATE.length());
            progress2.setText(newText);
        }
    }

    private static String formatContentLength(int contentLengthInBytes) {
        if (contentLengthInBytes < 0) {
            return "";
        }
        int kilo = 1024;
        if (contentLengthInBytes < 1024) {
            return ", " + contentLengthInBytes + " bytes";
        }
        if (contentLengthInBytes < 0x100000) {
            return String.format(Locale.US, ", %.1f kB", (double)contentLengthInBytes / 1024.0);
        }
        return String.format(Locale.US, ", %.1f MB", (double)contentLengthInBytes / 1048576.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionShortDescription";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/github/DownloadUtil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/github/DownloadUtil";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "provideDataWithProgressSynchronously";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "downloadAtomically";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "provideDataWithProgressSynchronously";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "downloadContentToFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

