/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.filters.ElementFilter;
import java.util.Arrays;

public class PlainTextFilter
implements ElementFilter {
    protected final String[] myValue;

    public PlainTextFilter(String ... values) {
        this.myValue = values;
    }

    public PlainTextFilter(String value1, String value2) {
        this.myValue = new String[]{value1, value2};
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    public boolean isAcceptable(Object element2, PsiElement context) {
        return element2 != null && Arrays.stream(this.myValue).anyMatch(v -> v == null || v.equals(this.getTextByElement(element2)));
    }

    protected String getTextByElement(Object element2) {
        String elementValue = null;
        if (element2 instanceof PsiNamedElement) {
            elementValue = ((PsiNamedElement)element2).getName();
        } else if (element2 instanceof PsiElement) {
            elementValue = ((PsiElement)element2).getText();
        }
        return elementValue;
    }

    public String toString() {
        return "(" + StringUtil.join((String[])this.myValue, (String)" | ") + ")";
    }
}

