/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PersistentStringEnumerator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class CompositeBinaryBuilderMap {
    private static final Logger LOG = Logger.getInstance(CompositeBinaryBuilderMap.class);
    private static final FileAttribute VERSION_STAMP = new FileAttribute("stubIndex.cumulativeBinaryBuilder", 1, true);
    private final Object2IntMap<FileType> myCumulativeVersionMap;

    CompositeBinaryBuilderMap() throws IOException {
        try (PersistentStringEnumerator cumulativeVersionEnumerator = new PersistentStringEnumerator(CompositeBinaryBuilderMap.registeredCompositeBinaryBuilderFiles());){
            this.myCumulativeVersionMap = new Object2IntOpenHashMap();
            for (Map.Entry entry : BinaryFileStubBuilders.INSTANCE.getAllRegisteredExtensions().entrySet()) {
                FileType fileType = (FileType)entry.getKey();
                BinaryFileStubBuilder builder2 = (BinaryFileStubBuilder)entry.getValue();
                if (!(builder2 instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)) continue;
                StringBuilder cumulativeVersion = new StringBuilder();
                cumulativeVersion.append(fileType.getName()).append("->").append(builder2.getClass().getName()).append(':').append(builder2.getStubVersion());
                BinaryFileStubBuilder.CompositeBinaryFileStubBuilder compositeBuilder = (BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder2;
                cumulativeVersion.append(";");
                cumulativeVersion.append(compositeBuilder.getAllSubBuilders().map(b -> compositeBuilder.getSubBuilderVersion(b)).sorted().collect(Collectors.joining(";")));
                int enumeratedId = cumulativeVersionEnumerator.enumerate(cumulativeVersion.toString());
                LOG.debug("composite binary stub builder for " + fileType + " registered:  id = " + enumeratedId + ", value" + cumulativeVersion.toString());
                this.myCumulativeVersionMap.put((Object)fileType, enumeratedId);
            }
        }
    }

    void persistState(int fileId, @NotNull VirtualFile file2) throws IOException {
        int version2;
        if (file2 == null) {
            CompositeBinaryBuilderMap.$$$reportNull$$$0(0);
        }
        if ((version2 = this.getBuilderCumulativeVersion(file2)) == 0) {
            return;
        }
        try (DataOutputStream stream = FSRecords.writeAttribute(fileId, VERSION_STAMP);){
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)version2);
        }
    }

    void resetPersistedState(int fileId) throws IOException {
        boolean hasWrittenAttribute;
        try (DataInputStream stream = FSRecords.readAttributeWithLock(fileId, VERSION_STAMP);){
            hasWrittenAttribute = stream != null;
        }
        if (hasWrittenAttribute) {
            stream = FSRecords.writeAttribute(fileId, VERSION_STAMP);
            try {
                DataInputOutputUtil.writeINT((DataOutput)((Object)stream), (int)0);
            }
            finally {
                if (stream != null) {
                    ((FilterOutputStream)((Object)stream)).close();
                }
            }
        }
    }

    FileIndexingState isUpToDateState(int fileId, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            CompositeBinaryBuilderMap.$$$reportNull$$$0(1);
        }
        int indexedVersion = 0;
        try (DataInputStream stream = FSRecords.readAttributeWithLock(fileId, VERSION_STAMP);){
            if (stream != null) {
                indexedVersion = DataInputOutputUtil.readINT((DataInput)stream);
            }
        }
        if (indexedVersion == 0) {
            return FileIndexingState.NOT_INDEXED;
        }
        int actualVersion = this.getBuilderCumulativeVersion(file2);
        return actualVersion == indexedVersion ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
    }

    private int getBuilderCumulativeVersion(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CompositeBinaryBuilderMap.$$$reportNull$$$0(2);
        }
        FileType type = (FileType)ProgressManager.getInstance().computeInNonCancelableSection(() -> file2.getFileType());
        return this.myCumulativeVersionMap.getInt((Object)type);
    }

    @NotNull
    private static Path registeredCompositeBinaryBuilderFiles() {
        Path path = new File(IndexInfrastructure.getIndexRootDir(StubUpdatingIndex.INDEX_ID), ".binary_builders").toPath();
        if (path == null) {
            CompositeBinaryBuilderMap.$$$reportNull$$$0(3);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/CompositeBinaryBuilderMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/CompositeBinaryBuilderMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "registeredCompositeBinaryBuilderFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "persistState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDateState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderCumulativeVersion";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

