/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl.util;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UrlCollector {
    private static final Logger LOG = Logger.getInstance(UrlCollector.class);
    private List<File> myFiles;

    public URL[] collect(@NotNull Collection<File> libraries2) {
        if (libraries2 == null) {
            UrlCollector.$$$reportNull$$$0(0);
        }
        List<File> files2 = this.collectFiles(libraries2);
        URL[] result2 = new URL[files2.size()];
        for (int i2 = 0; i2 < files2.size(); ++i2) {
            try {
                result2[i2] = files2.get(i2).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return result2;
    }

    public List<File> collectFiles(Collection<File> libraries2) {
        this.myFiles = new ArrayList<File>();
        for (File library2 : libraries2) {
            if (!library2.exists()) continue;
            this.addFile(library2);
            if (!library2.isDirectory()) continue;
            this.addLibraries(library2);
        }
        return this.myFiles;
    }

    private void addLibraries(@NotNull File dir) {
        if (dir == null) {
            UrlCollector.$$$reportNull$$$0(1);
        }
        LOG.debug("addLibraries: " + dir.getAbsolutePath() + ", exists: " + dir.exists());
        File[] subFiles = dir.listFiles();
        if (subFiles == null) {
            LOG.warn("Can't list files in " + dir);
            return;
        }
        for (File file2 : subFiles) {
            if (file2.isDirectory()) {
                this.addLibraries(file2);
                continue;
            }
            if (!file2.getName().endsWith(".jar")) continue;
            this.addFile(file2);
        }
    }

    private void addFile(@NotNull File file2) {
        if (file2 == null) {
            UrlCollector.$$$reportNull$$$0(2);
        }
        LOG.debug("addFile: " + file2.getAbsolutePath() + ", exists: " + file2.exists());
        this.myFiles.add(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/remoteServer/agent/impl/util/UrlCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibraries";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

