/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.text.NameUtilCore;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpeedSearchBase<Comp extends JComponent>
extends SpeedSearchSupply {
    private static final Logger LOG = Logger.getInstance(SpeedSearchBase.class);
    private static final Border BORDER = new CustomLineBorder((Color)JBColor.namedColor((String)"SpeedSearch.borderColor", (Color)JBColor.GRAY), (Insets)JBUI.insets((int)1));
    private static final Color FOREGROUND_COLOR = JBColor.namedColor((String)"SpeedSearch.foreground", (Color)UIUtil.getToolTipForeground());
    private static final Color BACKGROUND_COLOR = JBColor.namedColor((String)"SpeedSearch.background", (Color)new JBColor((Color)Gray.xFF, (Color)Gray._111));
    private static final Color ERROR_FOREGROUND_COLOR = JBColor.namedColor((String)"SpeedSearch.errorForeground", (Color)JBColor.RED);
    private SearchPopup mySearchPopup;
    private JLayeredPane myPopupLayeredPane;
    protected final Comp myComponent;
    private final ToolWindowManagerListener myWindowManagerListener;
    private final PropertyChangeSupport myChangeSupport;
    private String myRecentEnteredPrefix;
    private SpeedSearchComparator myComparator;
    private boolean myClearSearchOnNavigateNoMatch;
    private Disposable myListenerDisposable;

    public SpeedSearchBase(@NotNull Comp component2) {
        if (component2 == null) {
            SpeedSearchBase.$$$reportNull$$$0(0);
        }
        this.myWindowManagerListener = new ToolWindowManagerListener(){

            @Override
            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.isInsideActiveToolWindow(toolWindowManager)) {
                    SpeedSearchBase.this.manageSearchPopup(null);
                }
            }

            private boolean isInsideActiveToolWindow(@NotNull ToolWindowManager toolWindowManager) {
                ToolWindow toolWindow;
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(1);
                }
                return (toolWindow = toolWindowManager.getToolWindow(toolWindowManager.getActiveToolWindowId())) != null && SwingUtilities.isDescendingFrom(SpeedSearchBase.this.myComponent, toolWindow.getComponent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "toolWindowManager";
                objectArray2[1] = "com/intellij/ui/SpeedSearchBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "stateChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isInsideActiveToolWindow";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myChangeSupport = new PropertyChangeSupport((Object)this);
        this.myComparator = new SpeedSearchComparator(false);
        this.myComponent = component2;
        ((Component)this.myComponent).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent event) {
                SpeedSearchBase.this.manageSearchPopup(null);
            }

            @Override
            public void componentMoved(ComponentEvent event) {
                SpeedSearchBase.this.moveSearchPopup();
            }

            @Override
            public void componentResized(ComponentEvent event) {
                SpeedSearchBase.this.moveSearchPopup();
            }
        });
        ((Component)this.myComponent).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SpeedSearchBase.this.manageSearchPopup(null);
            }
        });
        ((Component)this.myComponent).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SpeedSearchBase.this.processKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                SpeedSearchBase.this.processKeyEvent(e);
            }
        });
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                String prefix = SpeedSearchBase.this.getEnteredPrefix();
                assert (prefix != null);
                String[] strings = NameUtilCore.splitNameIntoWords((String)prefix);
                String last = strings[strings.length - 1];
                int i2 = prefix.lastIndexOf(last);
                SpeedSearchBase.this.mySearchPopup.mySearchField.setText(prefix.substring(0, i2).trim());
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(SpeedSearchBase.this.isPopupActive() && !StringUtil.isEmpty((String)SpeedSearchBase.this.getEnteredPrefix()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ui/SpeedSearchBase$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{SystemInfo.isMac ? "meta BACK_SPACE" : "control BACK_SPACE"}), this.myComponent);
        this.installSupplyTo((JComponent)component2);
    }

    @Nullable
    public JTextField getSearchField() {
        if (this.mySearchPopup != null) {
            return this.mySearchPopup.mySearchField;
        }
        return null;
    }

    public static boolean hasActiveSpeedSearch(JComponent component2) {
        return SpeedSearchBase.getSupply((JComponent)component2) != null;
    }

    public void setClearSearchOnNavigateNoMatch(boolean clearSearchOnNavigateNoMatch) {
        this.myClearSearchOnNavigateNoMatch = clearSearchOnNavigateNoMatch;
    }

    public boolean isPopupActive() {
        return this.mySearchPopup != null && this.mySearchPopup.isVisible();
    }

    public Iterable<TextRange> matchingFragments(@NotNull String text2) {
        if (text2 == null) {
            SpeedSearchBase.$$$reportNull$$$0(1);
        }
        if (!this.isPopupActive()) {
            return null;
        }
        SpeedSearchComparator comparator2 = this.getComparator();
        String recentSearchText = comparator2.getRecentSearchText();
        return StringUtil.isNotEmpty((String)recentSearchText) ? comparator2.matchingFragments(recentSearchText, text2) : null;
    }

    protected abstract int getSelectedIndex();

    protected abstract Object @NotNull [] getAllElements();

    @Nullable
    protected abstract String getElementText(Object var1);

    protected int getElementCount() {
        return this.getAllElements().length;
    }

    protected int convertIndexToModel(int viewIndex) {
        return viewIndex;
    }

    protected abstract void selectElement(Object var1, String var2);

    @NotNull
    protected ListIterator<Object> getElementIterator(int startingIndex) {
        return new ViewIterator(this, startingIndex < 0 ? this.getElementCount() : startingIndex);
    }

    public void addChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            SpeedSearchBase.$$$reportNull$$$0(2);
        }
        this.myChangeSupport.addPropertyChangeListener(listener2);
    }

    public void removeChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            SpeedSearchBase.$$$reportNull$$$0(3);
        }
        this.myChangeSupport.removePropertyChangeListener(listener2);
    }

    private void fireStateChanged() {
        String enteredPrefix = this.getEnteredPrefix();
        this.myChangeSupport.firePropertyChange("enteredPrefix", this.myRecentEnteredPrefix, enteredPrefix);
        this.myRecentEnteredPrefix = enteredPrefix;
    }

    protected boolean isMatchingElement(Object element2, String pattern) {
        String str = this.getElementText(element2);
        return str != null && this.compare(str, pattern);
    }

    protected boolean compare(@NotNull String text2, @Nullable String pattern) {
        if (text2 == null) {
            SpeedSearchBase.$$$reportNull$$$0(4);
        }
        return pattern != null && this.myComparator.matchingFragments(pattern, text2) != null;
    }

    public SpeedSearchComparator getComparator() {
        return this.myComparator;
    }

    public void setComparator(SpeedSearchComparator comparator2) {
        this.myComparator = comparator2;
    }

    @Nullable
    private Object findNextElement(String s) {
        Object current2;
        int selectedIndex = this.getSelectedIndex();
        ListIterator<Object> it = this.getElementIterator(selectedIndex + 1);
        if (it.hasPrevious()) {
            current2 = it.previous();
            it.next();
        } else {
            current2 = null;
        }
        String _s = s.trim();
        while (it.hasNext()) {
            Object element2 = it.next();
            if (!this.isMatchingElement(element2, _s)) continue;
            return element2;
        }
        if (UISettings.getInstance().getCycleScrolling()) {
            ListIterator<Object> i2 = this.getElementIterator(0);
            while (i2.hasNext()) {
                Object element3 = i2.next();
                if (!this.isMatchingElement(element3, _s)) continue;
                return element3;
            }
        }
        return current2 != null && this.isMatchingElement(current2, _s) ? current2 : null;
    }

    @Nullable
    private Object findPreviousElement(@NotNull String s) {
        Object current2;
        int selectedIndex;
        if (s == null) {
            SpeedSearchBase.$$$reportNull$$$0(5);
        }
        if ((selectedIndex = this.getSelectedIndex()) < 0) {
            return null;
        }
        ListIterator<Object> it = this.getElementIterator(selectedIndex);
        if (it.hasNext()) {
            current2 = it.next();
            it.previous();
        } else {
            current2 = null;
        }
        String _s = s.trim();
        while (it.hasPrevious()) {
            Object element2 = it.previous();
            if (!this.isMatchingElement(element2, _s)) continue;
            return element2;
        }
        if (UISettings.getInstance().getCycleScrolling()) {
            ListIterator<Object> i2 = this.getElementIterator(this.getElementCount());
            while (i2.hasPrevious()) {
                Object element3 = i2.previous();
                if (!this.isMatchingElement(element3, _s)) continue;
                return element3;
            }
        }
        return this.isMatchingElement(current2, _s) ? current2 : null;
    }

    @Nullable
    protected Object findElement(@NotNull String s) {
        Object element2;
        int selectedIndex;
        if (s == null) {
            SpeedSearchBase.$$$reportNull$$$0(6);
        }
        if ((selectedIndex = this.getSelectedIndex()) < 0) {
            selectedIndex = 0;
        }
        ListIterator<Object> it = this.getElementIterator(selectedIndex);
        String _s = s.trim();
        while (it.hasNext()) {
            element2 = it.next();
            if (!this.isMatchingElement(element2, _s)) continue;
            return element2;
        }
        if (selectedIndex > 0) {
            while (it.hasPrevious()) {
                it.previous();
            }
            while (it.hasNext() && it.nextIndex() != selectedIndex) {
                element2 = it.next();
                if (!this.isMatchingElement(element2, _s)) continue;
                return element2;
            }
        }
        return null;
    }

    @Nullable
    private Object findFirstElement(String s) {
        String _s = s.trim();
        ListIterator<Object> it = this.getElementIterator(0);
        while (it.hasNext()) {
            Object element2 = it.next();
            if (!this.isMatchingElement(element2, _s)) continue;
            return element2;
        }
        return null;
    }

    @Nullable
    private Object findLastElement(String s) {
        String _s = s.trim();
        ListIterator<Object> it = this.getElementIterator(-1);
        while (it.hasPrevious()) {
            Object element2 = it.previous();
            if (!this.isMatchingElement(element2, _s)) continue;
            return element2;
        }
        return null;
    }

    public void showPopup(String searchText) {
        this.manageSearchPopup(new SearchPopup(searchText));
    }

    public void showPopup() {
        this.showPopup("");
    }

    public void hidePopup() {
        this.manageSearchPopup(null);
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.isAltDown()) {
            return;
        }
        if (e.isShiftDown() && SpeedSearchBase.isNavigationKey(e.getKeyCode())) {
            return;
        }
        if (this.mySearchPopup != null) {
            this.mySearchPopup.processKeyEvent(e);
            return;
        }
        if (!this.isSpeedSearchEnabled()) {
            return;
        }
        if (e.getID() == 400) {
            if (!UIUtil.isReallyTypedEvent((KeyEvent)e)) {
                return;
            }
            char c = e.getKeyChar();
            if (Character.isLetterOrDigit(c) || !Character.isWhitespace(c) && "*_-+\"'/.#$>: ,;?!@%^&".indexOf(c) != -1) {
                this.manageSearchPopup(new SearchPopup(String.valueOf(c)));
                e.consume();
            }
        }
    }

    public Comp getComponent() {
        return this.myComponent;
    }

    protected boolean isSpeedSearchEnabled() {
        return true;
    }

    @Nullable
    @NlsSafe
    public String getEnteredPrefix() {
        return this.mySearchPopup != null ? this.mySearchPopup.mySearchField.getText() : null;
    }

    public void refreshSelection() {
        if (this.mySearchPopup != null) {
            this.mySearchPopup.refreshSelection();
        }
    }

    public void findAndSelectElement(@NotNull String searchQuery) {
        if (searchQuery == null) {
            SpeedSearchBase.$$$reportNull$$$0(7);
        }
        this.selectElement(this.findElement(searchQuery), searchQuery);
    }

    public boolean adjustSelection(int keyCode, @NotNull String searchQuery) {
        if (searchQuery == null) {
            SpeedSearchBase.$$$reportNull$$$0(8);
        }
        if (SpeedSearchBase.isUpDownHomeEnd(keyCode)) {
            UIEventLogger.IncrementalSearchNextPrevItemSelected.log(this.myComponent.getClass());
            Object element2 = this.findTargetElement(keyCode, searchQuery);
            if (element2 != null) {
                this.selectElement(element2, searchQuery);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private Object findTargetElement(int keyCode, @NotNull String searchPrefix) {
        if (searchPrefix == null) {
            SpeedSearchBase.$$$reportNull$$$0(9);
        }
        if (keyCode == 38) {
            return this.findPreviousElement(searchPrefix);
        }
        if (keyCode == 40) {
            return this.findNextElement(searchPrefix);
        }
        if (keyCode == 36) {
            return this.findFirstElement(searchPrefix);
        }
        assert (keyCode == 35);
        return this.findLastElement(searchPrefix);
    }

    protected void onSearchFieldUpdated(String pattern) {
    }

    private static boolean isUpDownHomeEnd(int keyCode) {
        return keyCode == 36 || keyCode == 35 || keyCode == 38 || keyCode == 40;
    }

    private static boolean isPgUpPgDown(int keyCode) {
        return keyCode == 33 || keyCode == 34;
    }

    private static boolean isNavigationKey(int keyCode) {
        return SpeedSearchBase.isPgUpPgDown(keyCode) || SpeedSearchBase.isUpDownHomeEnd(keyCode);
    }

    private void manageSearchPopup(@Nullable SearchPopup searchPopup) {
        JRootPane rootPane;
        Project project = null;
        if (ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isDisposed()) {
            project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(this.myComponent));
        }
        if (project != null && project.isDefault()) {
            project = null;
        }
        if (this.mySearchPopup != null) {
            UIEventLogger.IncrementalSearchCancelled.log(this.myComponent.getClass());
            if (this.myPopupLayeredPane != null) {
                this.myPopupLayeredPane.remove(this.mySearchPopup);
                this.myPopupLayeredPane.validate();
                this.myPopupLayeredPane.repaint();
                this.myPopupLayeredPane = null;
            }
            if (this.myListenerDisposable != null) {
                Disposer.dispose((Disposable)this.myListenerDisposable);
                this.myListenerDisposable = null;
            }
        } else if (searchPopup != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("ui.tree.speedsearch");
            UIEventLogger.IncrementalSearchActivated.log(project, this.myComponent.getClass());
        }
        this.mySearchPopup = ((Component)this.myComponent).isShowing() ? searchPopup : null;
        this.fireStateChanged();
        if (this.mySearchPopup == null || !((Component)this.myComponent).isDisplayable()) {
            return;
        }
        if (project != null) {
            this.myListenerDisposable = Disposer.newDisposable();
            project.getMessageBus().connect(this.myListenerDisposable).subscribe(ToolWindowManagerListener.TOPIC, (Object)this.myWindowManagerListener);
        }
        JLayeredPane jLayeredPane = this.myPopupLayeredPane = (rootPane = ((JComponent)this.myComponent).getRootPane()) == null ? null : rootPane.getLayeredPane();
        if (this.myPopupLayeredPane == null) {
            LOG.error(this + " in " + this.myComponent);
            return;
        }
        this.myPopupLayeredPane.add((Component)this.mySearchPopup, JLayeredPane.POPUP_LAYER);
        this.moveSearchPopup();
        this.mySearchPopup.refreshSelection();
    }

    private void moveSearchPopup() {
        if (this.myComponent == null || this.mySearchPopup == null || this.myPopupLayeredPane == null) {
            return;
        }
        Point lPaneP = this.myPopupLayeredPane.getLocationOnScreen();
        Point componentP = this.getComponentLocationOnScreen();
        Rectangle r = this.getComponentVisibleRect();
        Dimension prefSize = this.mySearchPopup.getPreferredSize();
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.myComponent);
        Point windowP = window instanceof JDialog ? ((JDialog)window).getContentPane().getLocationOnScreen() : (window instanceof JFrame ? ((JFrame)window).getContentPane().getLocationOnScreen() : window.getLocationOnScreen());
        int y = r.y + componentP.y - lPaneP.y - prefSize.height;
        y = Math.max(y, windowP.y - lPaneP.y);
        this.mySearchPopup.setLocation(componentP.x - lPaneP.x + r.x, y);
        this.mySearchPopup.setSize(prefSize);
        this.mySearchPopup.setVisible(true);
        this.mySearchPopup.validate();
    }

    protected Rectangle getComponentVisibleRect() {
        return ((JComponent)this.myComponent).getVisibleRect();
    }

    protected Point getComponentLocationOnScreen() {
        return ((Component)this.myComponent).getLocationOnScreen();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchQuery";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPrefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/SpeedSearchBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "matchingFragments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addChangeListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeChangeListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findPreviousElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndSelectElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustSelection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected final class ViewIterator
    implements ListIterator<Object> {
        private final SpeedSearchBase mySpeedSearch;
        private int myCurrentIndex;
        private final Object[] myElements;

        ViewIterator(SpeedSearchBase speedSearch2, int startIndex) {
            if (speedSearch2 == null) {
                ViewIterator.$$$reportNull$$$0(0);
            }
            this.mySpeedSearch = speedSearch2;
            this.myCurrentIndex = startIndex;
            this.myElements = speedSearch2.getAllElements();
            if (startIndex < 0 || startIndex > this.myElements.length) {
                throw new IndexOutOfBoundsException("Index: " + startIndex + " in: " + ((Object)((Object)SpeedSearchBase.this)).getClass());
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.myCurrentIndex != 0;
        }

        @Override
        public Object previous() {
            int i2 = this.myCurrentIndex - 1;
            if (i2 < 0) {
                throw new NoSuchElementException();
            }
            Object previous = this.myElements[this.mySpeedSearch.convertIndexToModel(i2)];
            this.myCurrentIndex = i2;
            return previous;
        }

        @Override
        public int nextIndex() {
            return this.myCurrentIndex;
        }

        @Override
        public int previousIndex() {
            return this.myCurrentIndex - 1;
        }

        @Override
        public boolean hasNext() {
            return this.myCurrentIndex != this.myElements.length;
        }

        @Override
        public Object next() {
            if (this.myCurrentIndex + 1 > this.myElements.length) {
                throw new NoSuchElementException();
            }
            return this.myElements[this.mySpeedSearch.convertIndexToModel(this.myCurrentIndex++)];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented in: " + this.getClass().getCanonicalName());
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException("Not implemented in: " + this.getClass().getCanonicalName());
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException("Not implemented in: " + this.getClass().getCanonicalName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "speedSearch", "com/intellij/ui/SpeedSearchBase$ViewIterator", "<init>"));
        }
    }

    private class SearchField
    extends JTextField {
        SearchField() {
            this.setFocusable(false);
        }

        @Override
        public void setForeground(Color color) {
            super.setForeground(color);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            Insets m = this.getMargin();
            dim.width = this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + 10 + m.left + m.right;
            return dim;
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            int i2 = e.getKeyCode();
            if (i2 == 8 && this.getDocument().getLength() == 0) {
                e.consume();
                return;
            }
            if (i2 == 10 || i2 == 27 || i2 == 33 || i2 == 34 || i2 == 37 || i2 == 39) {
                SpeedSearchBase.this.manageSearchPopup(null);
                if (i2 == 27) {
                    e.consume();
                }
                return;
            }
            if (SpeedSearchBase.isUpDownHomeEnd(i2)) {
                e.consume();
                return;
            }
            super.processKeyEvent(e);
            if (i2 == 8) {
                e.consume();
            }
        }
    }

    private class SearchPopup
    extends JPanel {
        private final SearchField mySearchField;

        SearchPopup(String initialString) {
            this.mySearchField = new SearchField();
            JLabel searchLabel = new JLabel(" " + UIBundle.message((String)"search.popup.search.for.label", (Object[])new Object[0]) + " ");
            searchLabel.setFont(searchLabel.getFont().deriveFont(1));
            searchLabel.setForeground(FOREGROUND_COLOR);
            this.mySearchField.setBorder(null);
            this.mySearchField.setBackground(BACKGROUND_COLOR);
            this.mySearchField.setForeground(FOREGROUND_COLOR);
            this.mySearchField.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    String oldText;
                    try {
                        oldText = this.getText(0, this.getLength());
                    }
                    catch (BadLocationException e1) {
                        oldText = "";
                    }
                    String newText = oldText.substring(0, offs) + str + oldText.substring(offs);
                    super.insertString(offs, str, a);
                    if (SpeedSearchBase.this.findElement(newText) == null) {
                        SearchPopup.this.mySearchField.setForeground(ERROR_FOREGROUND_COLOR);
                    } else {
                        SearchPopup.this.mySearchField.setForeground(FOREGROUND_COLOR);
                    }
                }
            });
            this.mySearchField.setText(initialString);
            this.setBorder(BORDER);
            this.setBackground(BACKGROUND_COLOR);
            this.setLayout(new BorderLayout());
            this.add((Component)searchLabel, "West");
            this.add((Component)this.mySearchField, "East");
            Object element2 = SpeedSearchBase.this.findElement(this.mySearchField.getText());
            SpeedSearchBase.this.onSearchFieldUpdated(initialString);
            this.updateSelection(element2);
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            this.mySearchField.processKeyEvent(e);
            if (e.isConsumed()) {
                Object element2;
                String s = this.mySearchField.getText();
                SpeedSearchBase.this.onSearchFieldUpdated(s);
                int keyCode = e.getKeyCode();
                if (SpeedSearchBase.isUpDownHomeEnd(keyCode)) {
                    element2 = SpeedSearchBase.this.findTargetElement(keyCode, s);
                    if (SpeedSearchBase.this.myClearSearchOnNavigateNoMatch && element2 == null) {
                        SpeedSearchBase.this.manageSearchPopup(null);
                        element2 = SpeedSearchBase.this.findTargetElement(keyCode, "");
                    }
                } else {
                    UIEventLogger.IncrementalSearchKeyTyped.log(SpeedSearchBase.this.myComponent.getClass());
                    element2 = SpeedSearchBase.this.findElement(s);
                }
                this.updateSelection(element2);
            }
        }

        void refreshSelection() {
            SpeedSearchBase.this.findAndSelectElement(this.mySearchField.getText());
        }

        private void updateSelection(Object element2) {
            if (element2 != null) {
                SpeedSearchBase.this.selectElement(element2, this.mySearchField.getText());
                this.mySearchField.setForeground(FOREGROUND_COLOR);
            } else {
                this.mySearchField.setForeground(ERROR_FOREGROUND_COLOR);
            }
            if (SpeedSearchBase.this.mySearchPopup != null) {
                SpeedSearchBase.this.mySearchPopup.setSize(SpeedSearchBase.this.mySearchPopup.getPreferredSize());
                SpeedSearchBase.this.mySearchPopup.validate();
            }
            SpeedSearchBase.this.fireStateChanged();
        }
    }
}

