/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ui.ErrorTreeView;
import org.jetbrains.annotations.Nullable;

public final class ContentManagerUtil {
    private ContentManagerUtil() {
    }

    @Nullable
    public static ContentManager getContentManagerFromContext(DataContext dataContext, boolean requiresVisibleToolWindow) {
        ToolWindowEx toolWindow;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        String id2 = toolWindowManager.getActiveToolWindowId();
        if (id2 == null && toolWindowManager.isEditorComponentActive()) {
            id2 = toolWindowManager.getLastActiveToolWindowId();
        }
        ToolWindowEx toolWindowEx = toolWindow = id2 != null ? (ToolWindowEx)toolWindowManager.getToolWindow(id2) : null;
        if (requiresVisibleToolWindow && (toolWindow == null || !toolWindow.isVisible())) {
            return null;
        }
        ContentManager fromToolWindow = toolWindow != null ? toolWindow.getContentManager() : null;
        ContentManager fromContext = (ContentManager)PlatformDataKeys.CONTENT_MANAGER.getData(dataContext);
        return fromContext == null ? fromToolWindow : fromContext;
    }

    public static void cleanupContents(Content notToRemove, Project project, String contentName) {
        MessageView messageView = MessageView.SERVICE.getInstance(project);
        for (Content content2 : messageView.getContentManager().getContents()) {
            ErrorTreeView listErrorView;
            if (content2.isPinned() || !contentName.equals(content2.getDisplayName()) || content2 == notToRemove || (listErrorView = (ErrorTreeView)content2.getComponent()) == null || !messageView.getContentManager().removeContent(content2, true)) continue;
            content2.release();
        }
    }
}

