/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.ui.messages.JBMacMessages;
import java.awt.Window;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/intellij/ui/messages/MessageInfo;", "", "title", "", "message", "buttons", "", "errorStyle", "", "window", "Ljava/awt/Window;", "defaultOptionIndex", "", "doNotAskDialogOption", "Lcom/intellij/openapi/ui/DialogWrapper$DoNotAskOption;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;ZLjava/awt/Window;ILcom/intellij/openapi/ui/DialogWrapper$DoNotAskOption;)V", "getButtons", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getDefaultOptionIndex", "()I", "getDoNotAskDialogOption", "()Lcom/intellij/openapi/ui/DialogWrapper$DoNotAskOption;", "getErrorStyle", "()Z", "getMessage", "()Ljava/lang/String;", "nativeWindow", "Lcom/intellij/ui/mac/foundation/ID;", "getNativeWindow", "()Lcom/intellij/ui/mac/foundation/ID;", "getTitle", "getWindow", "()Ljava/awt/Window;", "intellij.platform.ide.impl"})
final class MessageInfo {
    @NotNull
    private final String message;
    @NotNull
    private final Window window;
    @NotNull
    private final ID nativeWindow;
    @NotNull
    private final String title;
    @NotNull
    private final String[] buttons;
    private final boolean errorStyle;
    private final int defaultOptionIndex;
    @Nullable
    private final DialogWrapper.DoNotAskOption doNotAskDialogOption;

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final Window getWindow() {
        return this.window;
    }

    @NotNull
    public final ID getNativeWindow() {
        return this.nativeWindow;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String[] getButtons() {
        return this.buttons;
    }

    public final boolean getErrorStyle() {
        return this.errorStyle;
    }

    public final int getDefaultOptionIndex() {
        return this.defaultOptionIndex;
    }

    @Nullable
    public final DialogWrapper.DoNotAskOption getDoNotAskDialogOption() {
        return this.doNotAskDialogOption;
    }

    public MessageInfo(@NotNull String title, @Nullable String message, @NotNull String[] buttons, boolean errorStyle, @Nullable Window window, int defaultOptionIndex, @Nullable DialogWrapper.DoNotAskOption doNotAskDialogOption) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)buttons, (String)"buttons");
        this.title = title;
        this.buttons = buttons;
        this.errorStyle = errorStyle;
        this.defaultOptionIndex = defaultOptionIndex;
        this.doNotAskDialogOption = doNotAskDialogOption;
        String string = message;
        if (string == null) {
            string = "";
        }
        String string2 = StringUtil.unescapeXmlEntities((String)StringUtil.stripHtml((String)string, (String)"\n"));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.unescapeXmlEn\u2026tml(message ?: \"\", \"\\n\"))");
        this.message = StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"%", (String)"%%", (boolean)false, (int)4, null), (String)"&nbsp;", (String)" ", (boolean)false, (int)4, null);
        Window window2 = window;
        if (window2 == null) {
            Window window3 = JBMacMessages.getForemostWindow();
            window2 = window3;
            Intrinsics.checkNotNullExpressionValue((Object)window3, (String)"JBMacMessages.getForemostWindow()");
        }
        this.window = window2;
        ID iD = MacUtil.findWindowFromJavaWindow((Window)this.window);
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"MacUtil.findWindowFromJavaWindow(this.window)");
        this.nativeWindow = iD;
    }
}

