/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.contentQueue;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class CachedFileContent
extends UserDataHolderBase {
    private final VirtualFile myVirtualFile;
    private long myLength;
    private byte[] myCachedBytes;
    private long myCachedTimeStamp;
    private Boolean myCachedWritable;

    public CachedFileContent(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CachedFileContent.$$$reportNull$$$0(0);
        }
        this.myCachedTimeStamp = -1L;
        this.myVirtualFile = virtualFile;
        this.myLength = virtualFile.getLength();
    }

    public byte @NotNull [] getBytes() throws IOException {
        if (this.myCachedBytes == null) {
            if (this.myVirtualFile.isValid()) {
                this.myCachedTimeStamp = this.myVirtualFile.getTimeStamp();
                this.myCachedBytes = this.myVirtualFile.contentsToByteArray(false);
            } else {
                this.myCachedTimeStamp = -1L;
                this.myCachedBytes = ArrayUtilRt.EMPTY_BYTE_ARRAY;
            }
        }
        if (this.myCachedBytes == null) {
            CachedFileContent.$$$reportNull$$$0(1);
        }
        return this.myCachedBytes;
    }

    public void setEmptyContent() {
        this.myCachedBytes = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        this.myLength = 0L;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            CachedFileContent.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    public long getLength() {
        return this.myLength;
    }

    public long getTimeStamp() {
        if (this.myCachedTimeStamp == -1L) {
            this.myCachedTimeStamp = this.myVirtualFile.getTimeStamp();
        }
        return this.myCachedTimeStamp;
    }

    public boolean isWritable() {
        if (this.myCachedWritable == null) {
            this.myCachedWritable = this.myVirtualFile.isWritable();
        }
        return this.myCachedWritable == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/contentQueue/CachedFileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/contentQueue/CachedFileContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

