/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.roots.IndexableFilesContributor;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIterator;
import com.intellij.util.indexing.roots.ModuleIndexableFilesIterator;
import com.intellij.util.indexing.roots.SdkIndexableFilesIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/indexing/roots/DefaultProjectIndexableFilesContributor;", "Lcom/intellij/util/indexing/roots/IndexableFilesContributor;", "()V", "getIndexableFiles", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "project", "Lcom/intellij/openapi/project/Project;", "getOwnFilePredicate", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lang.impl"})
public final class DefaultProjectIndexableFilesContributor
implements IndexableFilesContributor {
    @NotNull
    public List<IndexableFilesIterator> getIndexableFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set seenLibraries = new HashSet();
        Set seenSdks = new HashSet();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] modules2 = moduleManager.getSortedModules();
        boolean bl = false;
        List providers = new ArrayList();
        Module[] moduleArray = modules2;
        int n = moduleArray.length;
        for (int j = 0; j < n; ++j) {
            OrderEntry[] orderEntries;
            Module module;
            Module module2 = module = moduleArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            providers.add(new ModuleIndexableFilesIterator(module2));
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                Sdk sdk2;
                OrderEntry orderEntry2 = orderEntry;
                if (orderEntry2 instanceof LibraryOrderEntry) {
                    Library library2 = ((LibraryOrderEntry)orderEntry).getLibrary();
                    if (library2 == null || !seenLibraries.add(library2)) continue;
                    providers.add(new LibraryIndexableFilesIterator(library2));
                    continue;
                }
                if (!(orderEntry2 instanceof JdkOrderEntry) || (sdk2 = ((JdkOrderEntry)orderEntry).getJdk()) == null || !seenSdks.add(sdk2)) continue;
                providers.add(new SdkIndexableFilesIterator(sdk2));
            }
        }
        return providers;
    }

    @NotNull
    public Predicate<VirtualFile> getOwnFilePredicate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        return new Predicate<VirtualFile>(project, projectFileIndex2){
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectFileIndex $projectFileIndex;

            public final boolean test(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (LightEdit.owns((Project)this.$project)) {
                    return false;
                }
                return this.$projectFileIndex.isInContent(it) || this.$projectFileIndex.isInLibrary(it) ? !FileTypeManager.getInstance().isFileIgnored(it) : false;
            }
            {
                this.$project = project;
                this.$projectFileIndex = projectFileIndex;
            }
        };
    }
}

