/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public final class UpDownHandler {
    private static final CustomShortcutSet UP_KEY = CustomShortcutSet.fromString((String[])new String[]{"UP"});
    private static final CustomShortcutSet DOWN_KEY = CustomShortcutSet.fromString((String[])new String[]{"DOWN"});

    private UpDownHandler() {
    }

    public static void register(JComponent input, JComponent affectedComponent) {
        UpDownHandler.register(input, affectedComponent, true);
    }

    public static void register(JComponent input, JComponent affectedComponent, boolean registerOnBothComponents) {
        SelectionMover mover = new SelectionMover(affectedComponent);
        UpDownAction up = new UpDownAction(mover, input, true);
        up.registerCustomShortcutSet((ShortcutSet)UP_KEY, input);
        UpDownAction down = new UpDownAction(mover, input, false);
        down.registerCustomShortcutSet((ShortcutSet)DOWN_KEY, input);
        if (registerOnBothComponents) {
            up.registerCustomShortcutSet((ShortcutSet)UP_KEY, affectedComponent);
            down.registerCustomShortcutSet((ShortcutSet)DOWN_KEY, affectedComponent);
        }
    }

    static class UpDownAction
    extends AnAction {
        private final int myDirection;
        private final SelectionMover myMover;
        private final JComponent myInput;

        UpDownAction(SelectionMover mover, JComponent input, boolean isUp) {
            super(isUp ? LangBundle.message((String)"action.UpDownAction.up.text", (Object[])new Object[0]) : LangBundle.message((String)"action.UpDownAction.down.text", (Object[])new Object[0]));
            this.myMover = mover;
            this.myInput = input;
            this.myDirection = isUp ? -1 : 1;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                UpDownAction.$$$reportNull$$$0(0);
            }
            this.myMover.move(this.myDirection);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                UpDownAction.$$$reportNull$$$0(1);
            }
            LookupEx lookup2 = this.myInput instanceof EditorTextField ? LookupManager.getActiveLookup(((EditorTextField)((Object)this.myInput)).getEditor()) : (this.myInput instanceof EditorComponentImpl ? LookupManager.getActiveLookup(((EditorComponentImpl)this.myInput).getEditor()) : null);
            JComboBox comboBox2 = (JComboBox)UIUtil.findComponentOfType((JComponent)this.myInput, JComboBox.class);
            boolean popupMenuVisible = comboBox2 != null && comboBox2.isPopupVisible();
            e.getPresentation().setEnabled(lookup2 == null && !popupMenuVisible);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/util/ui/UpDownHandler$UpDownAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SelectionMover {
        private JComboBox myCombo;
        private JList myList;

        private SelectionMover(JComponent comp) {
            if (comp instanceof JComboBox) {
                this.myCombo = (JComboBox)comp;
            } else if (comp instanceof JList) {
                this.myList = (JList)comp;
            }
        }

        void move(int direction) {
            int index = -1;
            int size = 0;
            if (this.myCombo != null) {
                index = this.myCombo.getSelectedIndex();
                size = this.myCombo.getModel().getSize();
            } else if (this.myList != null) {
                index = this.myList.getSelectedIndex();
                size = this.myList.getModel().getSize();
            }
            if (index == -1 || size == 0) {
                return;
            }
            if ((index += direction) == size) {
                if (!UISettings.getInstance().getCycleScrolling()) {
                    return;
                }
                index = 0;
            } else if (index == -1) {
                if (!UISettings.getInstance().getCycleScrolling()) {
                    return;
                }
                index = size - 1;
            }
            if (this.myCombo != null) {
                this.myCombo.setSelectedIndex(index);
            } else if (this.myList != null) {
                this.myList.setSelectedIndex(index);
            }
        }
    }
}

