/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEditorLinePainter;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.inline.XDebuggerTreeInlayPopup;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InlineDebugRenderer
implements EditorCustomElementRenderer {
    public static final String NAME_VALUE_SEPARATION = ": ";
    public static final String INDENT = "  ";
    boolean myPopupIsShown;
    private final boolean myCustomNode;
    private final XDebugSession mySession;
    private final XValueNodeImpl myValueNode;
    private final Editor myEditor;
    private final XDebuggerTreeCreator myTreeCreator;
    private boolean isHovered;
    private int myRemoveXCoordinate;
    private int myTextStartXCoordinate;
    private XSourcePosition myPosition;
    private static final float BACKGROUND_ALPHA = 0.55f;

    InlineDebugRenderer(XValueNodeImpl valueNode, @NotNull XSourcePosition position, @NotNull XDebugSession session2, Editor editor) {
        if (position == null) {
            InlineDebugRenderer.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            InlineDebugRenderer.$$$reportNull$$$0(1);
        }
        this.myPopupIsShown = false;
        this.isHovered = false;
        this.myRemoveXCoordinate = Integer.MAX_VALUE;
        this.myPosition = position;
        this.mySession = session2;
        this.myCustomNode = valueNode instanceof InlineWatchNodeImpl;
        this.myValueNode = valueNode;
        this.myEditor = editor;
        this.myTreeCreator = new XDebuggerTreeCreator(session2.getProject(), session2.getDebugProcess().getEditorsProvider(), session2.getCurrentPosition(), ((XDebugSessionImpl)session2).getValueMarkers());
    }

    private SimpleColoredText getPresentation() {
        TextAttributes attributes = XDebuggerEditorLinePainter.getAttributes(this.myPosition.getLine(), this.myPosition.getFile(), this.mySession);
        SimpleColoredText valuePresentation = XDebuggerEditorLinePainter.createPresentation(this.myValueNode);
        return XDebuggerEditorLinePainter.computeVariablePresentationWithChanges(this.myValueNode, this.myValueNode.getName(), valuePresentation, attributes, this.myPosition.getLine(), this.mySession.getProject());
    }

    private boolean isInExecutionPointHighlight() {
        XSourcePosition debuggerPosition = this.mySession.getCurrentPosition();
        if (debuggerPosition != null) {
            XDebuggerManagerImpl debuggerManager = (XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)this.mySession.getProject());
            return XSourcePosition.isOnTheSameLine((XSourcePosition)this.myPosition, (XSourcePosition)debuggerPosition) && debuggerManager.isFullLineHighlighter();
        }
        return false;
    }

    private static Font getFont(@NotNull Editor editor) {
        if (editor == null) {
            InlineDebugRenderer.$$$reportNull$$$0(2);
        }
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        TextAttributes attributes = editor.getColorsScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
        int fontStyle = attributes == null ? 0 : attributes.getFontType();
        return UIUtil.getFontWithFallback((String)colorsScheme.getEditorFontName(), (int)fontStyle, (int)colorsScheme.getEditorFontSize());
    }

    public void onClick(Inlay inlay, @NotNull EditorMouseEvent event) {
        boolean isRemoveIconClick;
        if (event == null) {
            InlineDebugRenderer.$$$reportNull$$$0(3);
        }
        int x = event.getMouseEvent().getX();
        boolean bl = isRemoveIconClick = this.myCustomNode && x >= this.myRemoveXCoordinate;
        if (isRemoveIconClick) {
            XDebugSessionTab tab = ((XDebugSessionImpl)this.mySession).getSessionTab();
            if (tab != null) {
                tab.getWatchesView().removeWatches(Collections.singletonList(this.myValueNode));
            }
            inlay.update();
        } else if (x >= this.myTextStartXCoordinate) {
            this.handleClick(inlay);
        }
    }

    private void handleClick(Inlay inlay) {
        InlineDebugRenderer inlayRenderer = (InlineDebugRenderer)inlay.getRenderer();
        if (inlayRenderer.myPopupIsShown) {
            return;
        }
        String name = "valueName";
        XValue container = (XValue)this.myValueNode.getValueContainer();
        if (container instanceof XNamedValue) {
            name = ((XNamedValue)container).getName();
        }
        Pair descriptor2 = Pair.create((Object)container, (Object)name);
        Rectangle bounds2 = inlay.getBounds();
        Point point = new Point(bounds2.x, bounds2.y + bounds2.height);
        inlayRenderer.myPopupIsShown = true;
        XDebuggerTreeInlayPopup.showTreePopup(this.myTreeCreator, (Pair<XValue, String>)descriptor2, this.myValueNode, this.myEditor, point, this.myPosition, this.mySession, () -> ApplicationManager.getApplication().invokeLater(() -> {
            inlayRenderer.myPopupIsShown = false;
        }));
    }

    public void onMouseExit(Inlay inlay, @NotNull EditorMouseEvent event) {
        if (event == null) {
            InlineDebugRenderer.$$$reportNull$$$0(4);
        }
        this.setHovered(false, inlay, (EditorEx)event.getEditor());
    }

    public void onMouseMove(Inlay inlay, @NotNull EditorMouseEvent event) {
        if (event == null) {
            InlineDebugRenderer.$$$reportNull$$$0(5);
        }
        EditorEx editorEx = (EditorEx)event.getEditor();
        if (event.getMouseEvent().getX() >= this.myTextStartXCoordinate) {
            this.setHovered(true, inlay, editorEx);
        } else {
            this.setHovered(false, inlay, editorEx);
        }
    }

    private void setHovered(boolean active, Inlay inlay, EditorEx editorEx) {
        boolean oldState = this.isHovered;
        this.isHovered = active;
        Cursor cursor = active ? Cursor.getPredefinedCursor(12) : null;
        editorEx.setCustomCursor(InlineDebugRenderer.class, cursor);
        if (oldState != active) {
            inlay.update();
        }
    }

    @Nullable
    public ActionGroup getContextMenuGroup(@NotNull Inlay inlay) {
        if (inlay == null) {
            InlineDebugRenderer.$$$reportNull$$$0(6);
        }
        return null;
    }

    public int calcWidthInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            InlineDebugRenderer.$$$reportNull$$$0(7);
        }
        int width = this.getInlayTextWidth(inlay);
        width += this.myCustomNode ? AllIcons.Actions.Close.getIconWidth() : AllIcons.General.LinkDropTriangle.getIconWidth();
        if (this.myCustomNode) {
            width += AllIcons.Debugger.Watch.getIconWidth();
        }
        return width;
    }

    private int getInlayTextWidth(@NotNull Inlay inlay) {
        if (inlay == null) {
            InlineDebugRenderer.$$$reportNull$$$0(8);
        }
        Font font = InlineDebugRenderer.getFont(inlay.getEditor());
        SimpleColoredText presentation2 = this.getPresentation();
        Object text2 = this.isErrorMessage() ? (String)presentation2.getTexts().get(0) : presentation2.toString() + NAME_VALUE_SEPARATION;
        return InlineDebugRenderer.getFontMetrics(font, inlay.getEditor()).stringWidth((String)text2 + INDENT);
    }

    @NotNull
    private static FontMetrics getFontMetrics(Font font, @NotNull Editor editor) {
        if (editor == null) {
            InlineDebugRenderer.$$$reportNull$$$0(9);
        }
        FontMetrics fontMetrics = FontInfo.getFontMetrics(font, FontInfo.getFontRenderContext(editor.getContentComponent()));
        if (fontMetrics == null) {
            InlineDebugRenderer.$$$reportNull$$$0(10);
        }
        return fontMetrics;
    }

    private static int getIconY(Icon icon2, Rectangle r) {
        return r.y + r.height / 2 - icon2.getIconHeight() / 2;
    }

    public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        EditorImpl editor;
        TextAttributes inlineAttributes;
        if (inlay == null) {
            InlineDebugRenderer.$$$reportNull$$$0(11);
        }
        if (g == null) {
            InlineDebugRenderer.$$$reportNull$$$0(12);
        }
        if (r == null) {
            InlineDebugRenderer.$$$reportNull$$$0(13);
        }
        if (textAttributes == null) {
            InlineDebugRenderer.$$$reportNull$$$0(14);
        }
        if ((inlineAttributes = this.getAttributes(editor = (EditorImpl)inlay.getEditor())) == null || inlineAttributes.getForegroundColor() == null) {
            return;
        }
        SimpleColoredText presentation2 = this.getPresentation();
        Font font = InlineDebugRenderer.getFont(editor);
        g.setFont(font);
        FontMetrics metrics = InlineDebugRenderer.getFontMetrics(font, editor);
        int gap = 1;
        int margin = metrics.charWidth(' ') / 4;
        Color backgroundColor = inlineAttributes.getBackgroundColor();
        int curX = r.x + metrics.charWidth(' ');
        if (backgroundColor != null) {
            float alpha = 0.55f;
            GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
            GraphicsUtil.paintWithAlpha((Graphics)g, (float)alpha);
            g.setColor(backgroundColor);
            g.fillRoundRect(curX + margin, r.y + gap, r.width - 2 * margin - metrics.charWidth(' '), r.height - gap * 2, 6, 6);
            config2.restore();
        }
        curX += 2 * margin;
        if (this.myCustomNode) {
            Icon watchIcon = AllIcons.Debugger.Watch;
            watchIcon.paintIcon(inlay.getEditor().getComponent(), g, curX, InlineDebugRenderer.getIconY(watchIcon, r));
            curX += watchIcon.getIconWidth() + margin * 2;
        }
        this.myTextStartXCoordinate = curX;
        for (int i2 = 0; i2 < presentation2.getTexts().size(); ++i2) {
            Object curText = (String)presentation2.getTexts().get(i2);
            if (i2 == 0 && !this.isErrorMessage()) {
                curText = (String)curText + NAME_VALUE_SEPARATION;
            }
            SimpleTextAttributes attr = (SimpleTextAttributes)presentation2.getAttributes().get(i2);
            Color fgColor = this.isHovered ? inlineAttributes.getForegroundColor() : attr.getFgColor();
            g.setColor(fgColor);
            g.drawString((String)curText, curX, r.y + inlay.getEditor().getAscent());
            curX += metrics.stringWidth((String)curText);
            if (this.isErrorMessage()) break;
        }
        if (this.isHovered) {
            Icon icon2;
            if (this.myCustomNode) {
                icon2 = AllIcons.Actions.Close;
                this.myRemoveXCoordinate = curX;
            } else {
                icon2 = AllIcons.General.LinkDropTriangle;
            }
            icon2.paintIcon(inlay.getEditor().getComponent(), g, curX, InlineDebugRenderer.getIconY(icon2, r));
        }
        InlineDebugRenderer.paintEffects(g, r, editor, inlineAttributes, font, metrics);
    }

    private boolean isErrorMessage() {
        return XDebuggerUIConstants.ERROR_MESSAGE_ICON.equals(this.myValueNode.getIcon());
    }

    private static void paintEffects(@NotNull Graphics g, @NotNull Rectangle r, EditorImpl editor, TextAttributes inlineAttributes, Font font, FontMetrics metrics) {
        if (g == null) {
            InlineDebugRenderer.$$$reportNull$$$0(15);
        }
        if (r == null) {
            InlineDebugRenderer.$$$reportNull$$$0(16);
        }
        Color effectColor = inlineAttributes.getEffectColor();
        EffectType effectType = inlineAttributes.getEffectType();
        if (effectColor != null) {
            g.setColor(effectColor);
            Graphics2D g2d = (Graphics2D)g;
            int xStart = r.x;
            int xEnd = r.x + r.width;
            int y = r.y + metrics.getAscent();
            if (effectType == EffectType.LINE_UNDERSCORE) {
                EffectPainter.LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, metrics.getDescent(), (Object)font);
            } else if (effectType == EffectType.BOLD_LINE_UNDERSCORE) {
                EffectPainter.BOLD_LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, metrics.getDescent(), (Object)font);
            } else if (effectType == EffectType.STRIKEOUT) {
                EffectPainter.STRIKE_THROUGH.paint(g2d, xStart, y, xEnd - xStart, editor.getCharHeight(), (Object)font);
            } else if (effectType == EffectType.WAVE_UNDERSCORE) {
                EffectPainter.WAVE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, metrics.getDescent(), (Object)font);
            } else if (effectType == EffectType.BOLD_DOTTED_LINE) {
                EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, metrics.getDescent(), (Object)font);
            }
        }
    }

    private TextAttributes getAttributes(Editor editor) {
        TextAttributesKey key = this.isInExecutionPointHighlight() ? DebuggerColors.INLINED_VALUES_EXECUTION_LINE : DebuggerColors.INLINED_VALUES;
        EditorColorsScheme scheme = editor.getColorsScheme();
        TextAttributes inlinedAttributes = scheme.getAttributes(key);
        if (this.isHovered) {
            Color foregroundColor;
            TextAttributes hoveredInlineAttr = new TextAttributes();
            hoveredInlineAttr.copyFrom(inlinedAttributes);
            Color hoveredAndSelectedColor = scheme.getAttributes(DebuggerColors.EXECUTIONPOINT_ATTRIBUTES).getForegroundColor();
            Color color = foregroundColor = this.isInExecutionPointHighlight() ? hoveredAndSelectedColor : scheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getForegroundColor();
            if (foregroundColor == null) {
                foregroundColor = scheme.getDefaultForeground();
            }
            hoveredInlineAttr.setForegroundColor(foregroundColor);
            return hoveredInlineAttr;
        }
        return inlinedAttributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/inline/InlineDebugRenderer";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineDebugRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onClick";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onMouseExit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onMouseMove";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getContextMenuGroup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcWidthInPixels";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInlayTextWidth";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFontMetrics";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "paintEffects";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

