/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.sorting;

import com.intellij.completion.ml.experiment.ExperimentInfo;
import com.intellij.completion.ml.experiment.ExperimentStatus;
import com.intellij.completion.ml.ranker.ExperimentModelProvider;
import com.intellij.completion.ml.ranker.local.MLCompletionLocalModelsUtil;
import com.intellij.completion.ml.settings.CompletionMLRankingSettings;
import com.intellij.completion.ml.sorting.LanguageRankingModel;
import com.intellij.completion.ml.sorting.RankingModelWrapper;
import com.intellij.completion.ml.sorting.RankingSupport;
import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.completion.RankingModelProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\nH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/completion/ml/sorting/RankingSupport;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "enabledInTests", "", "availableRankers", "", "Lcom/intellij/internal/ml/completion/RankingModelProvider;", "enableInTests", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "findProviderSafe", "language", "Lcom/intellij/lang/Language;", "getRankingModel", "Lcom/intellij/completion/ml/sorting/RankingModelWrapper;", "shouldSortByML", "provider", "tryGetModel", "intellij.completionMlRanking"})
public final class RankingSupport {
    private static final Logger LOG;
    private static boolean enabledInTests;
    public static final RankingSupport INSTANCE;

    @Nullable
    public final RankingModelWrapper getRankingModel(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String string = language.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"language.id");
        DecisionFunction decisionFunction = MLCompletionLocalModelsUtil.INSTANCE.getModel(string);
        if (decisionFunction != null) {
            DecisionFunction decisionFunction2 = decisionFunction;
            boolean bl = false;
            boolean bl2 = false;
            DecisionFunction it = decisionFunction2;
            boolean bl3 = false;
            return new LanguageRankingModel(it);
        }
        RankingModelProvider provider = this.findProviderSafe(language);
        return provider != null && this.shouldSortByML(language, provider) ? this.tryGetModel(provider) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RankingModelProvider> availableRankers() {
        void $this$filterTo$iv$iv;
        Collection collection = Language.getRegisteredLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"Language.getRegisteredLanguages()");
        Collection registeredLanguages = collection;
        ExperimentStatus experimentStatus = ExperimentStatus.Companion.getInstance();
        Iterable $this$filter$iv = ExperimentModelProvider.Companion.availableProviders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                RankingModelProvider provider = (RankingModelProvider)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = registeredLanguages;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Language it = (Language)element$iv;
                        boolean bl3 = false;
                        Language language = it;
                        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"it");
                        if (!ExperimentModelProvider.Companion.match(provider, language, experimentStatus.forLanguage(it).getVersion())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final RankingModelProvider findProviderSafe(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        ExperimentInfo experimentInfo = ExperimentStatus.Companion.getInstance().forLanguage(language);
        try {
            return ExperimentModelProvider.Companion.findProvider(language, experimentInfo.getVersion());
        }
        catch (IllegalStateException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private final RankingModelWrapper tryGetModel(RankingModelProvider provider) {
        try {
            DecisionFunction decisionFunction = provider.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)decisionFunction, (String)"provider.model");
            return new LanguageRankingModel(decisionFunction);
        }
        catch (Exception e) {
            LOG.error("Could not create ranking model with id '" + provider.getId() + "' and name '" + provider.getDisplayNameInSettings() + '\'', (Throwable)e);
            return null;
        }
    }

    private final boolean shouldSortByML(Language language, RankingModelProvider provider) {
        Application application;
        Application application2 = application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"application");
        if (application2.isUnitTestMode()) {
            return enabledInTests;
        }
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
        CompletionMLRankingSettings settings = completionMLRankingSettings;
        ExperimentStatus experimentStatus = ExperimentStatus.Companion.getInstance();
        ExperimentInfo experimentInfo = experimentStatus.forLanguage(language);
        if (application.isEAP() && experimentInfo.getInExperiment() && !experimentStatus.isDisabled()) {
            settings.updateShowDiffInExperiment(experimentInfo.getShouldShowArrows());
        }
        return settings.isRankingEnabled() && settings.isLanguageEnabled(provider.getId());
    }

    @TestOnly
    public final void enableInTests(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        enabledInTests = true;
        Disposer.register((Disposable)parentDisposable, (Disposable)enableInTests.1.INSTANCE);
    }

    private RankingSupport() {
    }

    static {
        RankingSupport rankingSupport;
        INSTANCE = rankingSupport = new RankingSupport();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RankingSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$getEnabledInTests$p(RankingSupport $this) {
        RankingSupport rankingSupport = $this;
        return enabledInTests;
    }

    public static final /* synthetic */ void access$setEnabledInTests$p(RankingSupport $this, boolean bl) {
        RankingSupport rankingSupport = $this;
        enabledInTests = bl;
    }
}

