/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationTargetUtil {
    private static final Logger LOG = Logger.getInstance(AnnotationTargetUtil.class);
    public static final Set<PsiAnnotation.TargetType> DEFAULT_TARGETS = ContainerUtil.immutableSet(PsiAnnotation.TargetType.PACKAGE, PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.CONSTRUCTOR, PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.LOCAL_VARIABLE);
    private static final PsiAnnotation.TargetType[] PACKAGE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PACKAGE};
    private static final PsiAnnotation.TargetType[] TYPE_USE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] ANNOTATION_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] TYPE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] TYPE_PARAMETER_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] CONSTRUCTOR_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.CONSTRUCTOR, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] METHOD_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] FIELD_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] PARAMETER_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] LOCAL_VARIABLE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.LOCAL_VARIABLE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] MODULE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.MODULE};

    @NotNull
    public static PsiAnnotation.TargetType[] getTargetsForLocation(@Nullable PsiAnnotationOwner owner) {
        if (owner == null) {
            if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                AnnotationTargetUtil.$$$reportNull$$$0(0);
            }
            return PsiAnnotation.TargetType.EMPTY_ARRAY;
        }
        if (owner instanceof PsiType || owner instanceof PsiTypeElement) {
            if (TYPE_USE_TARGETS == null) {
                AnnotationTargetUtil.$$$reportNull$$$0(1);
            }
            return TYPE_USE_TARGETS;
        }
        if (owner instanceof PsiTypeParameter) {
            if (TYPE_PARAMETER_TARGETS == null) {
                AnnotationTargetUtil.$$$reportNull$$$0(2);
            }
            return TYPE_PARAMETER_TARGETS;
        }
        if (owner instanceof PsiModifierList) {
            PsiElement element = ((PsiModifierList)owner).getParent();
            if (element instanceof PsiPackageStatement) {
                if (PACKAGE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(3);
                }
                return PACKAGE_TARGETS;
            }
            if (element instanceof PsiClass) {
                if (((PsiClass)element).getModifierList() != owner) {
                    if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(4);
                    }
                    return PsiAnnotation.TargetType.EMPTY_ARRAY;
                }
                if (((PsiClass)element).isAnnotationType()) {
                    if (ANNOTATION_TARGETS == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(5);
                    }
                    return ANNOTATION_TARGETS;
                }
                if (TYPE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(6);
                }
                return TYPE_TARGETS;
            }
            if (element instanceof PsiMethod) {
                if (((PsiMethod)element).isConstructor()) {
                    if (CONSTRUCTOR_TARGETS == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(7);
                    }
                    return CONSTRUCTOR_TARGETS;
                }
                if (METHOD_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(8);
                }
                return METHOD_TARGETS;
            }
            if (element instanceof PsiField) {
                if (FIELD_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(9);
                }
                return FIELD_TARGETS;
            }
            if (element instanceof PsiParameter) {
                PsiElement scope2 = element.getParent();
                if (scope2 instanceof PsiForeachStatement) {
                    if (LOCAL_VARIABLE_TARGETS == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(10);
                    }
                    return LOCAL_VARIABLE_TARGETS;
                }
                if (scope2 instanceof PsiParameterList && scope2.getParent() instanceof PsiLambdaExpression && ((PsiParameter)element).getTypeElement() == null) {
                    if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                        AnnotationTargetUtil.$$$reportNull$$$0(11);
                    }
                    return PsiAnnotation.TargetType.EMPTY_ARRAY;
                }
                if (PARAMETER_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(12);
                }
                return PARAMETER_TARGETS;
            }
            if (element instanceof PsiLocalVariable) {
                if (LOCAL_VARIABLE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(13);
                }
                return LOCAL_VARIABLE_TARGETS;
            }
            if (element instanceof PsiReceiverParameter) {
                if (TYPE_USE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(14);
                }
                return TYPE_USE_TARGETS;
            }
            if (element instanceof PsiJavaModule) {
                if (MODULE_TARGETS == null) {
                    AnnotationTargetUtil.$$$reportNull$$$0(15);
                }
                return MODULE_TARGETS;
            }
        }
        if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(16);
        }
        return PsiAnnotation.TargetType.EMPTY_ARRAY;
    }

    @Nullable
    public static Set<PsiAnnotation.TargetType> extractRequiredAnnotationTargets(@Nullable PsiAnnotationMemberValue value2) {
        if (value2 instanceof PsiReference) {
            PsiAnnotation.TargetType targetType = AnnotationTargetUtil.translateTargetRef((PsiReference)((Object)value2));
            if (targetType != null) {
                return Collections.singleton(targetType);
            }
        } else if (value2 instanceof PsiArrayInitializerMemberValue) {
            EnumSet<PsiAnnotation.TargetType> targets = EnumSet.noneOf(PsiAnnotation.TargetType.class);
            for (PsiAnnotationMemberValue initializer2 : ((PsiArrayInitializerMemberValue)value2).getInitializers()) {
                PsiAnnotation.TargetType targetType;
                if (!(initializer2 instanceof PsiReference) || (targetType = AnnotationTargetUtil.translateTargetRef((PsiReference)((Object)initializer2))) == null) continue;
                targets.add(targetType);
            }
            return targets;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation.TargetType translateTargetRef(@NotNull PsiReference reference) {
        PsiElement field;
        String name;
        if (reference == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(17);
        }
        if (reference instanceof PsiJavaCodeReferenceElement && (name = ((PsiJavaCodeReferenceElement)reference).getReferenceName()) != null) {
            try {
                return PsiAnnotation.TargetType.valueOf(name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((field = reference.resolve()) instanceof PsiEnumConstant) {
            String name2 = ((PsiEnumConstant)field).getName();
            try {
                return PsiAnnotation.TargetType.valueOf(name2);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unknown target: " + name2);
            }
        }
        return null;
    }

    public static boolean isTypeAnnotation(@NotNull PsiAnnotation element) {
        if (element == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(18);
        }
        return AnnotationTargetUtil.findAnnotationTarget(element, PsiAnnotation.TargetType.TYPE_USE) == PsiAnnotation.TargetType.TYPE_USE;
    }

    @Nullable
    public static PsiAnnotation.TargetType findAnnotationTarget(@NotNull PsiAnnotation annotation2, PsiAnnotation.TargetType ... types2) {
        PsiElement annotationType;
        PsiJavaCodeReferenceElement ref;
        if (annotation2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(19);
        }
        if (types2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(20);
        }
        if (types2.length != 0 && (ref = annotation2.getNameReferenceElement()) != null && (annotationType = ref.resolve()) instanceof PsiClass) {
            return AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationType, types2);
        }
        return PsiAnnotation.TargetType.UNKNOWN;
    }

    @Nullable
    public static PsiAnnotation.TargetType findAnnotationTarget(@NotNull PsiClass annotationType, PsiAnnotation.TargetType ... types2) {
        Set<PsiAnnotation.TargetType> targets;
        if (annotationType == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(21);
        }
        if (types2 == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(22);
        }
        if (types2.length != 0 && (targets = AnnotationTargetUtil.getAnnotationTargets(annotationType)) != null) {
            for (PsiAnnotation.TargetType type2 : types2) {
                if (type2 == PsiAnnotation.TargetType.UNKNOWN || !targets.contains((Object)type2)) continue;
                return type2;
            }
            return null;
        }
        return PsiAnnotation.TargetType.UNKNOWN;
    }

    @Nullable
    public static Set<PsiAnnotation.TargetType> getAnnotationTargets(@NotNull PsiClass annotationType) {
        if (annotationType == null) {
            AnnotationTargetUtil.$$$reportNull$$$0(23);
        }
        if (!annotationType.isAnnotationType()) {
            return null;
        }
        PsiModifierList modifierList2 = annotationType.getModifierList();
        if (modifierList2 == null) {
            return null;
        }
        return (Set)CachedValuesManager.getCachedValue(modifierList2, () -> CachedValueProvider.Result.create(AnnotationTargetUtil.calcAnnotationTargets(modifierList2), PsiModificationTracker.MODIFICATION_COUNT));
    }

    @Nullable
    private static Set<PsiAnnotation.TargetType> calcAnnotationTargets(PsiModifierList modifierList2) {
        PsiAnnotation target = modifierList2.findAnnotation("java.lang.annotation.Target");
        if (target == null) {
            return DEFAULT_TARGETS;
        }
        PsiNameValuePair attribute = AnnotationUtil.findDeclaredAttribute(target, null);
        if (attribute == null) {
            return null;
        }
        return AnnotationTargetUtil.extractRequiredAnnotationTargets(attribute.getDetachedValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/AnnotationTargetUtil";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsForLocation";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/AnnotationTargetUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "translateTargetRef";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isTypeAnnotation";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationTarget";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTargets";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

