/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.builtins.functions.BuiltInFictitiousFunctionClassFactory;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.BuiltInAnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.FilteredAnnotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001aR\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020\u00022\b\b\u0002\u0010 \u001a\u00020\u0001H\u0007\u001a\u001e\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0001\u001aD\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001c2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001e\u0010(\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0001\u001a\u000e\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020+\u001a\u000e\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020.\u001a\n\u0010/\u001a\u00020\u0002*\u00020\u0002\u001a\f\u00100\u001a\u0004\u0018\u00010\u001e*\u00020\u0002\u001a\f\u00101\u001a\u0004\u0018\u000102*\u00020\u0005\u001a\u000e\u00101\u001a\u0004\u0018\u000102*\u00020.H\u0002\u001a\u0010\u00103\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c*\u00020\u0002\u001a\f\u00104\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\n\u00105\u001a\u00020\u0002*\u00020\u0002\u001a\u0018\u00106\u001a\b\u0012\u0004\u0012\u00020'0\u001c*\u00020\u00022\u0006\u00107\u001a\u00020\u0001\u001a\u0010\u00108\u001a\b\u0012\u0004\u0012\u00020'0\u001c*\u00020\u0002\u001a\n\u00109\u001a\u00020\u0001*\u00020\u0019\u001a\u001e\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010;\u001a \u0010<\u001a\u00020\u0001*\u00020\u00022\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010;H\u0002\u001a\u0012\u0010=\u001a\u00020\u0002*\u00020\u00022\u0006\u0010>\u001a\u00020\u0002\u001a\u0012\u0010?\u001a\u00020\u0019*\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017\u001a\n\u0010@\u001a\u00020A*\u00020\u0019\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0003\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0003\"\u0015\u0010\n\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0003\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0003\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0003\"\u0015\u0010\r\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0003\"\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0003\"\u0015\u0010\u000f\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0003\"\u0015\u0010\u0010\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0003\"\u0015\u0010\u0011\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0003\"\u0015\u0010\u0012\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0003\"\u0018\u0010\u0013\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0003\u00a8\u0006B"}, d2={"isBuiltinExtensionFunctionalType", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "isBuiltinFunctionalClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isBuiltinFunctionalType", "isBuiltinFunctionalTypeOrSubtype", "isExtensionFunctionType", "isFunctionOrKFunctionTypeWithAnySuspendability", "isFunctionOrSuspendFunctionType", "isFunctionType", "isFunctionTypeOrSubtype", "isKFunctionType", "isKSuspendFunctionType", "isNonExtensionFunctionType", "isSuspendFunctionType", "isSuspendFunctionTypeOrSubtype", "isTypeAnnotatedWithExtensionFunctionType", "createFunctionType", "Lorg/jetbrains/kotlin/types/SimpleType;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "receiverType", "parameterTypes", "", "parameterNames", "Lorg/jetbrains/kotlin/name/Name;", "returnType", "suspendFunction", "getFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "parameterCount", "", "isSuspendFunction", "getFunctionTypeArgumentProjections", "Lorg/jetbrains/kotlin/types/TypeProjection;", "getKFunctionDescriptor", "isBuiltinFunctionClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "isNumberedFunctionClassFqName", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "extractFunctionalTypeFromSupertypes", "extractParameterNameFromFunctionTypeArgument", "getFunctionalClassKind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassDescriptor$Kind;", "getPureArgumentsForFunctionalTypeOrSubtype", "getReceiverTypeFromFunctionType", "getReturnTypeFromFunctionType", "getValueParameterTypesFromCallableReflectionType", "isCallableTypeWithExtension", "getValueParameterTypesFromFunctionType", "hasExtensionFunctionAnnotation", "predicate", "Lkotlin/Function1;", "isTypeOrSubtypeOf", "replaceReturnType", "newReturnType", "withExtensionFunctionAnnotation", "withoutExtensionFunctionAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/FilteredAnnotations;", "descriptors"})
public final class FunctionTypesKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isTypeOrSubtypeOf(KotlinType $this$isTypeOrSubtypeOf, Function1<? super KotlinType, Boolean> predicate) {
        if (predicate.invoke($this$isTypeOrSubtypeOf) != false) return true;
        Object r = DFS.dfsFromNode($this$isTypeOrSubtypeOf, isTypeOrSubtypeOf.1.INSTANCE, new DFS.VisitedWithSet(), new DFS.AbstractNodeHandler<KotlinType, Boolean>(predicate){
            private boolean result;
            final /* synthetic */ Function1 $predicate;

            public boolean beforeChildren(@NotNull KotlinType current) {
                Intrinsics.checkNotNullParameter(current, "current");
                if (((Boolean)this.$predicate.invoke(current)).booleanValue()) {
                    this.result = true;
                }
                return !this.result;
            }

            @NotNull
            public Boolean result() {
                return this.result;
            }
            {
                this.$predicate = $captured_local_variable$0;
            }
        });
        Intrinsics.checkNotNullExpressionValue(r, "DFS.dfsFromNode(\n       \u2026              }\n        )");
        if ((Boolean)r == false) return false;
        return true;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull KotlinType $this$isFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter($this$isFunctionTypeOrSubtype, "$this$isFunctionTypeOrSubtype");
        return FunctionTypesKt.isTypeOrSubtypeOf($this$isFunctionTypeOrSubtype, isFunctionTypeOrSubtype.1.INSTANCE);
    }

    public static final boolean isSuspendFunctionTypeOrSubtype(@NotNull KotlinType $this$isSuspendFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunctionTypeOrSubtype, "$this$isSuspendFunctionTypeOrSubtype");
        return FunctionTypesKt.isTypeOrSubtypeOf($this$isSuspendFunctionTypeOrSubtype, isSuspendFunctionTypeOrSubtype.1.INSTANCE);
    }

    public static final boolean isBuiltinFunctionalTypeOrSubtype(@NotNull KotlinType $this$isBuiltinFunctionalTypeOrSubtype) {
        Intrinsics.checkNotNullParameter($this$isBuiltinFunctionalTypeOrSubtype, "$this$isBuiltinFunctionalTypeOrSubtype");
        return FunctionTypesKt.isTypeOrSubtypeOf($this$isBuiltinFunctionalTypeOrSubtype, isBuiltinFunctionalTypeOrSubtype.1.INSTANCE);
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull KotlinType $this$isFunctionTypeOrSubtype, @NotNull Function1<? super KotlinType, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$isFunctionTypeOrSubtype, "$this$isFunctionTypeOrSubtype");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return FunctionTypesKt.isTypeOrSubtypeOf($this$isFunctionTypeOrSubtype, (Function1<? super KotlinType, Boolean>)new Function1<KotlinType, Boolean>(predicate){
            final /* synthetic */ Function1 $predicate;

            public final boolean invoke(@NotNull KotlinType it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return FunctionTypesKt.isFunctionType(it) && (Boolean)this.$predicate.invoke(it) != false;
            }
            {
                this.$predicate = function1;
                super(1);
            }
        });
    }

    public static final boolean isFunctionType(@NotNull KotlinType $this$isFunctionType) {
        Intrinsics.checkNotNullParameter($this$isFunctionType, "$this$isFunctionType");
        ClassifierDescriptor classifierDescriptor = $this$isFunctionType.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassDescriptor.Kind.Function;
    }

    public static final boolean isKFunctionType(@NotNull KotlinType $this$isKFunctionType) {
        Intrinsics.checkNotNullParameter($this$isKFunctionType, "$this$isKFunctionType");
        ClassifierDescriptor classifierDescriptor = $this$isKFunctionType.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassDescriptor.Kind.KFunction;
    }

    public static final boolean isSuspendFunctionType(@NotNull KotlinType $this$isSuspendFunctionType) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunctionType, "$this$isSuspendFunctionType");
        ClassifierDescriptor classifierDescriptor = $this$isSuspendFunctionType.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassDescriptor.Kind.SuspendFunction;
    }

    public static final boolean isKSuspendFunctionType(@NotNull KotlinType $this$isKSuspendFunctionType) {
        Intrinsics.checkNotNullParameter($this$isKSuspendFunctionType, "$this$isKSuspendFunctionType");
        ClassifierDescriptor classifierDescriptor = $this$isKSuspendFunctionType.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassDescriptor.Kind.KSuspendFunction;
    }

    public static final boolean isFunctionOrSuspendFunctionType(@NotNull KotlinType $this$isFunctionOrSuspendFunctionType) {
        Intrinsics.checkNotNullParameter($this$isFunctionOrSuspendFunctionType, "$this$isFunctionOrSuspendFunctionType");
        return FunctionTypesKt.isFunctionType($this$isFunctionOrSuspendFunctionType) || FunctionTypesKt.isSuspendFunctionType($this$isFunctionOrSuspendFunctionType);
    }

    public static final boolean isFunctionOrKFunctionTypeWithAnySuspendability(@NotNull KotlinType $this$isFunctionOrKFunctionTypeWithAnySuspendability) {
        Intrinsics.checkNotNullParameter($this$isFunctionOrKFunctionTypeWithAnySuspendability, "$this$isFunctionOrKFunctionTypeWithAnySuspendability");
        return FunctionTypesKt.isFunctionType($this$isFunctionOrKFunctionTypeWithAnySuspendability) || FunctionTypesKt.isSuspendFunctionType($this$isFunctionOrKFunctionTypeWithAnySuspendability) || FunctionTypesKt.isKFunctionType($this$isFunctionOrKFunctionTypeWithAnySuspendability) || FunctionTypesKt.isKSuspendFunctionType($this$isFunctionOrKFunctionTypeWithAnySuspendability);
    }

    public static final boolean isBuiltinFunctionalType(@NotNull KotlinType $this$isBuiltinFunctionalType) {
        Intrinsics.checkNotNullParameter($this$isBuiltinFunctionalType, "$this$isBuiltinFunctionalType");
        ClassifierDescriptor classifierDescriptor = $this$isBuiltinFunctionalType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null && FunctionTypesKt.isBuiltinFunctionalClassDescriptor(classifierDescriptor);
    }

    public static final boolean isBuiltinFunctionalClassDescriptor(@NotNull DeclarationDescriptor $this$isBuiltinFunctionalClassDescriptor) {
        Intrinsics.checkNotNullParameter($this$isBuiltinFunctionalClassDescriptor, "$this$isBuiltinFunctionalClassDescriptor");
        FunctionClassDescriptor.Kind functionalClassKind = FunctionTypesKt.getFunctionalClassKind($this$isBuiltinFunctionalClassDescriptor);
        return functionalClassKind == FunctionClassDescriptor.Kind.Function || functionalClassKind == FunctionClassDescriptor.Kind.SuspendFunction;
    }

    public static final boolean isBuiltinFunctionClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        if (!classId.startsWith(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME)) {
            return false;
        }
        FqNameUnsafe fqNameUnsafe = classId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "classId.asSingleFqName().toUnsafe()");
        FunctionClassDescriptor.Kind kind = FunctionTypesKt.getFunctionalClassKind(fqNameUnsafe);
        return kind == FunctionClassDescriptor.Kind.Function || kind == FunctionClassDescriptor.Kind.SuspendFunction;
    }

    public static final boolean isNonExtensionFunctionType(@NotNull KotlinType $this$isNonExtensionFunctionType) {
        Intrinsics.checkNotNullParameter($this$isNonExtensionFunctionType, "$this$isNonExtensionFunctionType");
        return FunctionTypesKt.isFunctionType($this$isNonExtensionFunctionType) && !FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$isNonExtensionFunctionType);
    }

    public static final boolean isExtensionFunctionType(@NotNull KotlinType $this$isExtensionFunctionType) {
        Intrinsics.checkNotNullParameter($this$isExtensionFunctionType, "$this$isExtensionFunctionType");
        return FunctionTypesKt.isFunctionType($this$isExtensionFunctionType) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$isExtensionFunctionType);
    }

    public static final boolean isBuiltinExtensionFunctionalType(@NotNull KotlinType $this$isBuiltinExtensionFunctionalType) {
        Intrinsics.checkNotNullParameter($this$isBuiltinExtensionFunctionalType, "$this$isBuiltinExtensionFunctionalType");
        return FunctionTypesKt.isBuiltinFunctionalType($this$isBuiltinExtensionFunctionalType) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$isBuiltinExtensionFunctionalType);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(KotlinType $this$isTypeAnnotatedWithExtensionFunctionType) {
        Annotations annotations2 = $this$isTypeAnnotatedWithExtensionFunctionType.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkNotNullExpressionValue(fqName2, "KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        return annotations2.findAnnotation(fqName2) != null;
    }

    public static final boolean isNumberedFunctionClassFqName(@NotNull FqNameUnsafe fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return fqName2.startsWith(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME) && FunctionTypesKt.getFunctionalClassKind(fqName2) == FunctionClassDescriptor.Kind.Function;
    }

    @Nullable
    public static final FunctionClassDescriptor.Kind getFunctionalClassKind(@NotNull DeclarationDescriptor $this$getFunctionalClassKind) {
        Intrinsics.checkNotNullParameter($this$getFunctionalClassKind, "$this$getFunctionalClassKind");
        if (!($this$getFunctionalClassKind instanceof ClassDescriptor)) {
            return null;
        }
        if (!KotlinBuiltIns.isUnderKotlinPackage($this$getFunctionalClassKind)) {
            return null;
        }
        return FunctionTypesKt.getFunctionalClassKind(DescriptorUtilsKt.getFqNameUnsafe($this$getFunctionalClassKind));
    }

    private static final FunctionClassDescriptor.Kind getFunctionalClassKind(FqNameUnsafe $this$getFunctionalClassKind) {
        if (!$this$getFunctionalClassKind.isSafe() || $this$getFunctionalClassKind.isRoot()) {
            return null;
        }
        String string2 = $this$getFunctionalClassKind.shortName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "shortName().asString()");
        FqName fqName2 = $this$getFunctionalClassKind.toSafe().parent();
        Intrinsics.checkNotNullExpressionValue(fqName2, "toSafe().parent()");
        return BuiltInFictitiousFunctionClassFactory.Companion.getFunctionalClassKind(string2, fqName2);
    }

    @Nullable
    public static final KotlinType getReceiverTypeFromFunctionType(@NotNull KotlinType $this$getReceiverTypeFromFunctionType) {
        Intrinsics.checkNotNullParameter($this$getReceiverTypeFromFunctionType, "$this$getReceiverTypeFromFunctionType");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$getReceiverTypeFromFunctionType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Not a function type: " + $this$getReceiverTypeFromFunctionType;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$getReceiverTypeFromFunctionType) ? kotlin.collections.CollectionsKt.first($this$getReceiverTypeFromFunctionType.getArguments()).getType() : null;
    }

    @NotNull
    public static final KotlinType getReturnTypeFromFunctionType(@NotNull KotlinType $this$getReturnTypeFromFunctionType) {
        Intrinsics.checkNotNullParameter($this$getReturnTypeFromFunctionType, "$this$getReturnTypeFromFunctionType");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$getReturnTypeFromFunctionType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Not a function type: " + $this$getReturnTypeFromFunctionType;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        KotlinType kotlinType = kotlin.collections.CollectionsKt.last($this$getReturnTypeFromFunctionType.getArguments()).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "arguments.last().type");
        return kotlinType;
    }

    @NotNull
    public static final KotlinType replaceReturnType(@NotNull KotlinType $this$replaceReturnType, @NotNull KotlinType newReturnType) {
        Intrinsics.checkNotNullParameter($this$replaceReturnType, "$this$replaceReturnType");
        Intrinsics.checkNotNullParameter(newReturnType, "newReturnType");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$replaceReturnType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Not a function type: " + $this$replaceReturnType;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        List list2 = kotlin.collections.CollectionsKt.toMutableList((Collection)$this$replaceReturnType.getArguments());
        boolean bl4 = false;
        boolean bl5 = false;
        List $this$apply = list2;
        boolean bl6 = false;
        $this$apply.set($this$apply.size() - 1, new TypeProjectionImpl(newReturnType));
        List argumentsWithNewReturnType = list2;
        return TypeSubstitutionKt.replace$default($this$replaceReturnType, argumentsWithNewReturnType, null, 2, null);
    }

    @NotNull
    public static final List<TypeProjection> getValueParameterTypesFromFunctionType(@NotNull KotlinType $this$getValueParameterTypesFromFunctionType) {
        Intrinsics.checkNotNullParameter($this$getValueParameterTypesFromFunctionType, "$this$getValueParameterTypesFromFunctionType");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$getValueParameterTypesFromFunctionType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromFunctionType$32 = false;
            String $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromFunctionType$32 = "Not a function type: " + $this$getValueParameterTypesFromFunctionType;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FunctionTypesKt$getValueParameterTypesFromFunctionType$32));
        }
        List<TypeProjection> arguments2 = $this$getValueParameterTypesFromFunctionType.getArguments();
        int first = FunctionTypesKt.isBuiltinExtensionFunctionalType($this$getValueParameterTypesFromFunctionType) ? 1 : 0;
        int last = arguments2.size() - 1;
        boolean bl3 = first <= last;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl3) {
            boolean bl5 = false;
            String string2 = "Not an exact function type: " + $this$getValueParameterTypesFromFunctionType;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return arguments2.subList(first, last);
    }

    @NotNull
    public static final List<TypeProjection> getValueParameterTypesFromCallableReflectionType(@NotNull KotlinType $this$getValueParameterTypesFromCallableReflectionType, boolean isCallableTypeWithExtension) {
        Intrinsics.checkNotNullParameter($this$getValueParameterTypesFromCallableReflectionType, "$this$getValueParameterTypesFromCallableReflectionType");
        boolean bl = ReflectionTypes.Companion.isKCallableType($this$getValueParameterTypesFromCallableReflectionType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromCallableReflectionType$32 = false;
            String $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromCallableReflectionType$32 = "Not a callable reflection type: " + $this$getValueParameterTypesFromCallableReflectionType;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FunctionTypesKt$getValueParameterTypesFromCallableReflectionType$32));
        }
        List<TypeProjection> arguments2 = $this$getValueParameterTypesFromCallableReflectionType.getArguments();
        int first = isCallableTypeWithExtension ? 1 : 0;
        int last = arguments2.size() - 1;
        boolean bl3 = first <= last;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl3) {
            boolean bl5 = false;
            String string2 = "Not an exact function type: " + $this$getValueParameterTypesFromCallableReflectionType;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return arguments2.subList(first, last);
    }

    @NotNull
    public static final KotlinType extractFunctionalTypeFromSupertypes(@NotNull KotlinType $this$extractFunctionalTypeFromSupertypes) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter($this$extractFunctionalTypeFromSupertypes, "$this$extractFunctionalTypeFromSupertypes");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype($this$extractFunctionalTypeFromSupertypes);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Not a function type or subtype: " + $this$extractFunctionalTypeFromSupertypes;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (FunctionTypesKt.isBuiltinFunctionalType($this$extractFunctionalTypeFromSupertypes)) {
            kotlinType = $this$extractFunctionalTypeFromSupertypes;
        } else {
            Object element$iv2;
            block4: {
                Iterable $this$first$iv = TypeUtilsKt.supertypes($this$extractFunctionalTypeFromSupertypes);
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    KotlinType it = (KotlinType)element$iv2;
                    boolean bl4 = false;
                    if (!FunctionTypesKt.isBuiltinFunctionalType(it)) continue;
                    break block4;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            kotlinType = (KotlinType)element$iv2;
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinType> getPureArgumentsForFunctionalTypeOrSubtype(@NotNull KotlinType $this$getPureArgumentsForFunctionalTypeOrSubtype) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getPureArgumentsForFunctionalTypeOrSubtype, "$this$getPureArgumentsForFunctionalTypeOrSubtype");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype($this$getPureArgumentsForFunctionalTypeOrSubtype);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FunctionTypesKt$getPureArgumentsForFunctionalTypeOrSubtype$22 = false;
            String $i$a$-assert-FunctionTypesKt$getPureArgumentsForFunctionalTypeOrSubtype$22 = "Not a function type or subtype: " + $this$getPureArgumentsForFunctionalTypeOrSubtype;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FunctionTypesKt$getPureArgumentsForFunctionalTypeOrSubtype$22));
        }
        Iterable $this$map$iv = kotlin.collections.CollectionsKt.dropLast(FunctionTypesKt.extractFunctionalTypeFromSupertypes($this$getPureArgumentsForFunctionalTypeOrSubtype).getArguments(), 1);
        boolean $i$f$map = false;
        Iterable $i$a$-assert-FunctionTypesKt$getPureArgumentsForFunctionalTypeOrSubtype$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            KotlinType kotlinType = it.getType();
            collection.add(kotlinType);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final Name extractParameterNameFromFunctionTypeArgument(@NotNull KotlinType $this$extractParameterNameFromFunctionTypeArgument) {
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter($this$extractParameterNameFromFunctionTypeArgument, "$this$extractParameterNameFromFunctionTypeArgument");
                Annotations annotations2 = $this$extractParameterNameFromFunctionTypeArgument.getAnnotations();
                FqName fqName2 = KotlinBuiltIns.FQ_NAMES.parameterName;
                Intrinsics.checkNotNullExpressionValue(fqName2, "KotlinBuiltIns.FQ_NAMES.parameterName");
                AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
                if (annotationDescriptor == null) {
                    return null;
                }
                AnnotationDescriptor annotation2 = annotationDescriptor;
                Object t = kotlin.collections.CollectionsKt.singleOrNull((Iterable)annotation2.getAllValueArguments().values());
                if (!(t instanceof StringValue)) {
                    t = null;
                }
                if ((object = (StringValue)t) == null || (object = (String)((ConstantValue)object).getValue()) == null) break block5;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                object = Name.isValidIdentifier((String)it) ? object2 : null;
                if (object != null) break block6;
            }
            return null;
        }
        Object name = object;
        return Name.identifier((String)name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType2, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter(parameterTypes, "parameterTypes");
        Intrinsics.checkNotNullParameter(returnType2, "returnType");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>(parameterTypes.size() + (receiverType != null ? 1 : 0) + 1);
        KotlinType kotlinType = receiverType;
        CollectionsKt.addIfNotNull((Collection)arguments2, kotlinType != null ? TypeUtilsKt.asTypeProjection(kotlinType) : null);
        Iterable $this$mapIndexedTo$iv = parameterTypes;
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : $this$mapIndexedTo$iv) {
            KotlinType kotlinType2;
            void type2;
            List<Name> name;
            List<Name> list2;
            void index2;
            Collection collection = arguments2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                kotlin.collections.CollectionsKt.throwIndexOverflow();
            }
            KotlinType kotlinType3 = (KotlinType)item$iv;
            int n2 = n;
            Collection collection2 = collection;
            boolean bl2 = false;
            List<Name> list3 = parameterNames;
            if (list3 != null && (list3 = list3.get((int)index2)) != null) {
                List<Name> list4 = list3;
                boolean bl3 = false;
                boolean bl4 = false;
                List<Name> it = list4;
                boolean bl5 = false;
                list2 = !((Name)((Object)it)).isSpecial() ? list4 : null;
            } else {
                list2 = name = null;
            }
            if (name != null) {
                FqName fqName2 = KotlinBuiltIns.FQ_NAMES.parameterName;
                Intrinsics.checkNotNullExpressionValue(fqName2, "KotlinBuiltIns.FQ_NAMES.parameterName");
                Name name2 = Name.identifier("name");
                String string2 = ((Name)((Object)name)).asString();
                Intrinsics.checkNotNullExpressionValue(string2, "name.asString()");
                BuiltInAnnotationDescriptor parameterNameAnnotation = new BuiltInAnnotationDescriptor(builtIns, fqName2, MapsKt.mapOf(TuplesKt.to(name2, new StringValue(string2))));
                kotlinType2 = TypeUtilsKt.replaceAnnotations((KotlinType)type2, Annotations.Companion.create(kotlin.collections.CollectionsKt.plus((Iterable)type2.getAnnotations(), parameterNameAnnotation)));
            } else {
                kotlinType2 = type2;
            }
            void typeToUse = kotlinType2;
            TypeProjection typeProjection = TypeUtilsKt.asTypeProjection((KotlinType)typeToUse);
            collection2.add(typeProjection);
        }
        arguments2.add(TypeUtilsKt.asTypeProjection(returnType2));
        return arguments2;
    }

    @JvmOverloads
    @NotNull
    public static final SimpleType createFunctionType(@NotNull KotlinBuiltIns builtIns, @NotNull Annotations annotations2, @Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType2, boolean suspendFunction) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        Intrinsics.checkNotNullParameter(parameterTypes, "parameterTypes");
        Intrinsics.checkNotNullParameter(returnType2, "returnType");
        List<TypeProjection> arguments2 = FunctionTypesKt.getFunctionTypeArgumentProjections(receiverType, parameterTypes, parameterNames, returnType2, builtIns);
        int parameterCount = receiverType == null ? parameterTypes.size() : parameterTypes.size() + 1;
        ClassDescriptor classDescriptor2 = FunctionTypesKt.getFunctionDescriptor(builtIns, parameterCount, suspendFunction);
        Annotations typeAnnotations = receiverType != null ? FunctionTypesKt.withExtensionFunctionAnnotation(annotations2, builtIns) : annotations2;
        return KotlinTypeFactory.simpleNotNullType(typeAnnotations, classDescriptor2, arguments2);
    }

    public static /* synthetic */ SimpleType createFunctionType$default(KotlinBuiltIns kotlinBuiltIns, Annotations annotations2, KotlinType kotlinType, List list2, List list3, KotlinType kotlinType2, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list2, list3, kotlinType2, bl);
    }

    @JvmOverloads
    @NotNull
    public static final SimpleType createFunctionType(@NotNull KotlinBuiltIns builtIns, @NotNull Annotations annotations2, @Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType2) {
        return FunctionTypesKt.createFunctionType$default(builtIns, annotations2, receiverType, parameterTypes, parameterNames, returnType2, false, 64, null);
    }

    public static final boolean hasExtensionFunctionAnnotation(@NotNull Annotations $this$hasExtensionFunctionAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasExtensionFunctionAnnotation, "$this$hasExtensionFunctionAnnotation");
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkNotNullExpressionValue(fqName2, "KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        return $this$hasExtensionFunctionAnnotation.hasAnnotation(fqName2);
    }

    @NotNull
    public static final FilteredAnnotations withoutExtensionFunctionAnnotation(@NotNull Annotations $this$withoutExtensionFunctionAnnotation) {
        Intrinsics.checkNotNullParameter($this$withoutExtensionFunctionAnnotation, "$this$withoutExtensionFunctionAnnotation");
        return new FilteredAnnotations($this$withoutExtensionFunctionAnnotation, true, withoutExtensionFunctionAnnotation.1.INSTANCE);
    }

    @NotNull
    public static final Annotations withExtensionFunctionAnnotation(@NotNull Annotations $this$withExtensionFunctionAnnotation, @NotNull KotlinBuiltIns builtIns) {
        Annotations annotations2;
        Intrinsics.checkNotNullParameter($this$withExtensionFunctionAnnotation, "$this$withExtensionFunctionAnnotation");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkNotNullExpressionValue(fqName2, "KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        if ($this$withExtensionFunctionAnnotation.hasAnnotation(fqName2)) {
            annotations2 = $this$withExtensionFunctionAnnotation;
        } else {
            Iterable iterable = $this$withExtensionFunctionAnnotation;
            FqName fqName3 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
            Intrinsics.checkNotNullExpressionValue(fqName3, "KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
            annotations2 = Annotations.Companion.create(kotlin.collections.CollectionsKt.plus(iterable, new BuiltInAnnotationDescriptor(builtIns, fqName3, MapsKt.emptyMap())));
        }
        return annotations2;
    }

    @NotNull
    public static final ClassDescriptor getFunctionDescriptor(@NotNull KotlinBuiltIns builtIns, int parameterCount, boolean isSuspendFunction) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        ClassDescriptor classDescriptor2 = isSuspendFunction ? builtIns.getSuspendFunction(parameterCount) : builtIns.getFunction(parameterCount);
        Intrinsics.checkNotNullExpressionValue(classDescriptor2, "if (isSuspendFunction) b\u2026tFunction(parameterCount)");
        return classDescriptor2;
    }

    @NotNull
    public static final ClassDescriptor getKFunctionDescriptor(@NotNull KotlinBuiltIns builtIns, int parameterCount, boolean isSuspendFunction) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        ClassDescriptor classDescriptor2 = isSuspendFunction ? builtIns.getKSuspendFunction(parameterCount) : builtIns.getKFunction(parameterCount);
        Intrinsics.checkNotNullExpressionValue(classDescriptor2, "if (isSuspendFunction) b\u2026KFunction(parameterCount)");
        return classDescriptor2;
    }
}

