/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000e\u001a\u0002H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u0002H\u000f\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u0017\u001a\u00020\rJ\b\u0010\u0018\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u000bJ\u0006\u0010\u001c\u001a\u00020\tJ\u000e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fJ'\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020$0#\u00a2\u0006\u0002\b%J6\u0010&\u001a\u0002H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00072\u0006\u0010'\u001a\u0002H\u000f2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020$0#\u00a2\u0006\u0002\b%\u00a2\u0006\u0002\u0010(J8\u0010)\u001a\u0002H\u000f\"\n\b\u0000\u0010\u000f*\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u0002H\u000f2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020$0#\u00a2\u0006\u0002\b%\u00a2\u0006\u0002\u0010*J'\u0010+\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020$0#\u00a2\u0006\u0002\b%J)\u0010,\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\b\u0010-\u001a\u0004\u0018\u00010\r2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u000f0.\u00a2\u0006\u0002\u0010/R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "", "()V", "classStack", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "functionStack", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "parentStack", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "propertyStack", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "subjectVariableStack", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "applyParentFromStackTo", "T", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "dispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "irClass", "lastClass", "lastSubject", "parent", "parentAccessorOfPropertyFromStack", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "property", "parentFromStack", "returnTarget", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "withClass", "klass", "f", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "withFunction", "function", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "withParent", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "withProperty", "withSubject", "subject", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "fir2ir"})
public final class Fir2IrConversionScope {
    private final List<IrDeclarationParent> parentStack;
    private final List<IrFunction> functionStack;
    private final List<IrProperty> propertyStack;
    private final List<IrClass> classStack;
    private final List<IrVariable> subjectVariableStack;

    public final <T extends IrDeclarationParent> T withParent(T parent2, @NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        if (parent2 == null) {
            return parent2;
        }
        Collection collection = this.parentStack;
        boolean bl = false;
        collection.add(parent2);
        f.invoke(parent2);
        this.parentStack.remove(this.parentStack.size() - 1);
        return parent2;
    }

    @NotNull
    public final IrDeclarationParent parentFromStack() {
        return CollectionsKt.last(this.parentStack);
    }

    @Nullable
    public final IrSimpleFunction parentAccessorOfPropertyFromStack(@NotNull IrProperty property2) {
        Intrinsics.checkNotNullParameter(property2, "property");
        for (IrDeclarationParent parent2 : CollectionsKt.asReversedMutable(this.parentStack)) {
            IrDeclarationParent irDeclarationParent = parent2;
            if (Intrinsics.areEqual(irDeclarationParent, property2.getGetter())) {
                return property2.getGetter();
            }
            if (!Intrinsics.areEqual(irDeclarationParent, property2.getSetter())) continue;
            return property2.getSetter();
        }
        return null;
    }

    @NotNull
    public final <T extends IrDeclaration> T applyParentFromStackTo(@NotNull T declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        declaration2.setParent(CollectionsKt.last(this.parentStack));
        return declaration2;
    }

    @NotNull
    public final <T extends IrFunction> T withFunction(@NotNull T function2, @NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(f, "f");
        Collection collection = this.functionStack;
        boolean bl = false;
        collection.add(function2);
        f.invoke(function2);
        this.functionStack.remove(this.functionStack.size() - 1);
        return function2;
    }

    @NotNull
    public final IrProperty withProperty(@NotNull IrProperty property2, @NotNull Function1<? super IrProperty, Unit> f) {
        Intrinsics.checkNotNullParameter(property2, "property");
        Intrinsics.checkNotNullParameter(f, "f");
        Collection collection = this.propertyStack;
        boolean bl = false;
        collection.add(property2);
        f.invoke(property2);
        this.propertyStack.remove(this.propertyStack.size() - 1);
        return property2;
    }

    @NotNull
    public final IrClass withClass(@NotNull IrClass klass, @NotNull Function1<? super IrClass, Unit> f) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(f, "f");
        Collection collection = this.classStack;
        boolean bl = false;
        collection.add(klass);
        f.invoke(klass);
        this.classStack.remove(this.classStack.size() - 1);
        return klass;
    }

    public final <T> T withSubject(@Nullable IrVariable subject, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        if (subject != null) {
            Collection collection = this.subjectVariableStack;
            boolean bl = false;
            collection.add(subject);
        }
        T result2 = f.invoke();
        if (subject != null) {
            this.subjectVariableStack.remove(this.subjectVariableStack.size() - 1);
        }
        return result2;
    }

    @NotNull
    public final IrFunction returnTarget(@NotNull FirReturnExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        FirFunction<?> firTarget = expression2.getTarget().getLabeledElement();
        for (IrFunction potentialTarget : CollectionsKt.asReversedMutable(this.functionStack)) {
            Name name = potentialTarget.getName();
            FirFunction<?> firFunction = firTarget;
            if (!(firFunction instanceof FirSimpleFunction)) {
                firFunction = null;
            }
            FirSimpleFunction firSimpleFunction = (FirSimpleFunction)firFunction;
            if (!Intrinsics.areEqual(name, firSimpleFunction != null ? firSimpleFunction.getName() : null)) continue;
            return potentialTarget;
        }
        return CollectionsKt.last(this.functionStack);
    }

    @Nullable
    public final IrDeclarationParent parent() {
        return CollectionsKt.lastOrNull(this.parentStack);
    }

    @Nullable
    public final IrValueParameter dispatchReceiverParameter(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        for (IrFunction function2 : CollectionsKt.asReversedMutable(this.functionStack)) {
            if (!Intrinsics.areEqual(IrUtilsKt.getParentClassOrNull(function2), irClass2)) continue;
            IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
            if (irValueParameter == null) continue;
            IrValueParameter irValueParameter2 = irValueParameter;
            boolean bl = false;
            boolean bl2 = false;
            IrValueParameter it = irValueParameter2;
            boolean bl3 = false;
            return it;
        }
        return irClass2.getThisReceiver();
    }

    @Nullable
    public final IrClass lastClass() {
        return CollectionsKt.lastOrNull(this.classStack);
    }

    @NotNull
    public final IrVariable lastSubject() {
        return CollectionsKt.last(this.subjectVariableStack);
    }

    public Fir2IrConversionScope() {
        boolean bl = false;
        this.parentStack = new ArrayList();
        bl = false;
        this.functionStack = new ArrayList();
        bl = false;
        this.propertyStack = new ArrayList();
        bl = false;
        this.classStack = new ArrayList();
        bl = false;
        this.subjectVariableStack = new ArrayList();
    }
}

