/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkReifieidTypeParameters", "call", "extractModuleCallee", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "js.frontend"})
public final class JsModuleCallChecker
implements CallChecker {
    public static final JsModuleCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        this.checkReifieidTypeParameters(resolvedCall2, reportOn, context2);
        DeclarationDescriptor declarationDescriptor = this.extractModuleCallee(resolvedCall2);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor callee = declarationDescriptor;
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        DeclarationDescriptor containingDescriptor = context2.getScope().getOwnerDescriptor();
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext2, context2.getTrace(), containingDescriptor, callee, reportOn);
    }

    private final DeclarationDescriptor extractModuleCallee(ResolvedCall<?> call2) {
        Object callee = call2.getResultingDescriptor();
        if (DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)callee)) {
            return (DeclarationDescriptor)callee;
        }
        ReceiverValue receiverValue = call2.getDispatchReceiver();
        if (receiverValue == null) {
            return (DeclarationDescriptor)callee;
        }
        Intrinsics.checkNotNullExpressionValue(receiverValue, "call.dispatchReceiver ?: return callee");
        ReceiverValue receiver = receiverValue;
        if (receiver instanceof ClassValueReceiver) {
            return ((ClassValueReceiver)receiver).getClassQualifier().getDescriptor();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReifieidTypeParameters(ResolvedCall<?> call2, PsiElement reportOn, CallCheckerContext context2) {
        void $this$mapTo$iv$iv;
        Map map2;
        Object destination$iv$iv;
        KtTypeArgumentList $i$f$filter22;
        Object param;
        void $this$filterTo$iv$iv;
        TypeParameterDescriptor typeParameterDescriptor;
        boolean bl;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        DeclarationDescriptor containingDescriptor = context2.getScope().getOwnerDescriptor();
        Object obj = call2.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "call.candidateDescriptor");
        List<TypeParameterDescriptor> list2 = obj.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "call.candidateDescriptor.typeParameters");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv2) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)t;
            collection = destination$iv$iv2;
            bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue(v2, "it");
            typeParameterDescriptor = v2.getOriginal();
            collection.add(typeParameterDescriptor);
        }
        Iterable $this$filter$iv = CollectionsKt.withIndex((List)destination$iv$iv2);
        boolean $i$f$filter22 = false;
        $this$mapTo$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv32 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            IndexedValue $dstr$_u24__u24$param = (IndexedValue)t;
            bl = false;
            param = (TypeParameterDescriptor)$dstr$_u24__u24$param.component2();
            TypeParameterDescriptor typeParameterDescriptor3 = param;
            Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor3, "param");
            if (!typeParameterDescriptor3.isReified()) continue;
            destination$iv$iv32.add(t);
        }
        List typeParams = (List)destination$iv$iv32;
        Call call3 = call2.getCall();
        Intrinsics.checkNotNullExpressionValue(call3, "call.call");
        KtTypeArgumentList ktTypeArgumentList = call3.getTypeArgumentList();
        if (ktTypeArgumentList != null) {
            void $this$associateTo$iv$iv;
            $i$f$filter22 = ktTypeArgumentList;
            boolean bl2 = false;
            boolean destination$iv$iv32 = false;
            KtTypeArgumentList args = $i$f$filter22;
            boolean bl22 = false;
            Iterable iterable2 = typeParams;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault(iterable2, 10)), 16);
            param = iterable2;
            destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                void index2;
                TypeParameterDescriptor param2;
                Object object = destination$iv$iv;
                IndexedValue $dstr$index$param = (IndexedValue)element$iv$iv;
                boolean bl3 = false;
                int n = $dstr$index$param.component1();
                TypeParameterDescriptor typeParameterDescriptor4 = param2 = (TypeParameterDescriptor)$dstr$index$param.component2();
                Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor4, "param");
                TypeParameterDescriptor typeParameterDescriptor5 = typeParameterDescriptor4.getOriginal();
                KtTypeArgumentList ktTypeArgumentList2 = args;
                Intrinsics.checkNotNullExpressionValue(ktTypeArgumentList2, "args");
                List<KtTypeProjection> list3 = ktTypeArgumentList2.getArguments();
                Intrinsics.checkNotNullExpressionValue(list3, "args.arguments");
                KtTypeProjection ktTypeProjection = CollectionsKt.getOrNull(list3, (int)index2);
                Pair<TypeParameterDescriptor, KtTypeReference> pair = TuplesKt.to(typeParameterDescriptor5, ktTypeProjection != null ? ktTypeProjection.getTypeReference() : null);
                boolean bl4 = false;
                object.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv;
        } else {
            map2 = null;
        }
        $i$f$filter22 = map2;
        boolean bl5 = false;
        Object object = $i$f$filter22;
        if (object == null) {
            object = MapsKt.emptyMap();
        }
        KtTypeArgumentList typeArguments2 = object;
        Iterable $this$map$iv2 = typeParams;
        boolean $i$f$map2 = false;
        Iterable bl22 = $this$map$iv2;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$_u24__u24$param;
            TypeParameterDescriptor param3;
            destination$iv$iv = (IndexedValue)item$iv$iv;
            collection = collection2;
            boolean bl52 = false;
            TypeParameterDescriptor typeParameterDescriptor6 = param3 = (TypeParameterDescriptor)$dstr$_u24__u24$param.component2();
            Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor6, "param");
            typeParameterDescriptor = typeParameterDescriptor6.getOriginal();
            collection.add(typeParameterDescriptor);
        }
        for (TypeParameterDescriptor typeParam : (List)collection2) {
            ClassDescriptor typeArgumentClass;
            KotlinType typeArgument;
            PsiElement argPsi;
            KtTypeReference ktTypeReference = (KtTypeReference)typeArguments2.get(typeParam);
            PsiElement psiElement = argPsi = ktTypeReference != null ? (PsiElement)ktTypeReference : reportOn;
            if (call2.getTypeArguments().get(typeParam) == null) {
                continue;
            }
            ClassifierDescriptor classifierDescriptor = typeArgument.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((ClassDescriptor)classifierDescriptor == null) {
                continue;
            }
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
            JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, context2.getTrace(), containingDescriptor, typeArgumentClass, argPsi);
        }
    }

    private JsModuleCallChecker() {
    }

    static {
        JsModuleCallChecker jsModuleCallChecker;
        INSTANCE = jsModuleCallChecker = new JsModuleCallChecker();
    }
}

