/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.AstLoadingFilter;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolveUtilKt;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionElement;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 M2\u00020\u0001:\u0001MBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dJ4\u0010!\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ@\u0010*\u001a\u0016\u0012\u0004\u0012\u00020,\u0012\f\u0012\n\u0012\u0004\u0012\u00020.\u0018\u00010-0+2\u0006\u0010/\u001a\u0002002\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u0003012\u0006\u00102\u001a\u0002032\u0006\u0010&\u001a\u00020'H\u0002J \u00104\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u00105\u001a\u0002062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J*\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u0002092\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001dJ4\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u0002092\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J4\u0010:\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J:\u0010=\u001a\u0010\u0012\u0004\u0012\u00020,\u0012\u0006\u0012\u0004\u0018\u00010>0+2\u0006\u00108\u001a\u0002092\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010?\u001a\u00020@2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010B\u001a\u00020@2\u0006\u0010C\u001a\u00020D2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u0002092\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010J\u001a\u00020@2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u001a\u0010K\u001a\b\u0012\u0004\u0012\u0002060L*\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver;", "", "callResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "(Lorg/jetbrains/kotlin/resolve/calls/CallResolver;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;)V", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "checkSelectorTypeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "qualified", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "selectorTypeInfo", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getCallExpressionTypeInfo", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getCallExpressionTypeInfoWithoutFinalTypeCheck", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "callOperationNode", "Lcom/intellij/lang/ASTNode;", "initialDataFlowInfoForArguments", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getQualifiedExpressionTypeInfo", "expression", "getResolvedCallForFunction", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CheckArgumentTypesMode;", "getSafeOrUnsafeSelectorTypeInfo", "element", "Lorg/jetbrains/kotlin/resolve/calls/CallExpressionElement;", "getSimpleNameExpressionTypeInfo", "nameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getUnsafeSelectorTypeInfo", "selectorExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getVariableType", "Lorg/jetbrains/kotlin/types/KotlinType;", "recordResultTypeInfo", "", "resultTypeInfo", "resolveDeferredReceiverInQualifiedExpression", "qualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "resolveSimpleName", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "traceAndCache", "Lorg/jetbrains/kotlin/resolve/calls/context/TemporaryTraceAndCache;", "setExpressionTypingServices", "elementChain", "", "Companion", "frontend"})
public final class CallExpressionResolver {
    private ExpressionTypingServices expressionTypingServices;
    private final CallResolver callResolver;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final ArgumentTypeResolver argumentTypeResolver;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final KotlinBuiltIns builtIns;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final LanguageVersionSettings languageVersionSettings;
    private final DataFlowValueFactory dataFlowValueFactory;
    private final KotlinTypeRefiner kotlinTypeRefiner;
    public static final Companion Companion = new Companion(null);

    @Inject
    public final void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkNotNullParameter(expressionTypingServices, "expressionTypingServices");
        this.expressionTypingServices = expressionTypingServices;
    }

    private final Pair<Boolean, ResolvedCall<FunctionDescriptor>> getResolvedCallForFunction(Call call2, ResolutionContext<?> context2, CheckArgumentTypesMode checkArguments, DataFlowInfo initialDataFlowInfoForArguments) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context2, call2, checkArguments, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call2)));
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, "callResolver.resolveFunc\u2026)\n            )\n        )");
        OverloadResolutionResults<FunctionDescriptor> results = overloadResolutionResults;
        return !results.isNothing() ? new Pair<Boolean, ResolvedCall<FunctionDescriptor>>(true, OverloadResolutionResultsUtil.getResultingCall(results, context2)) : new Pair<Boolean, Object>(false, null);
    }

    private final Pair<Boolean, KotlinType> getVariableType(KtSimpleNameExpression nameExpression, Receiver receiver, ASTNode callOperationNode2, ExpressionTypingContext context2) {
        KotlinType kotlinType;
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context2, "trace to resolve as local variable or property", nameExpression);
        Call call2 = CallMaker.makePropertyCall(receiver, callOperationNode2, nameExpression);
        Intrinsics.checkNotNullExpressionValue(call2, "CallMaker.makePropertyCa\u2026tionNode, nameExpression)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context2.replaceTraceAndCache(temporaryForVariable), call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkNotNullExpressionValue(basicCallResolutionContext, "BasicCallResolutionConte\u2026VALUE_ARGUMENTS\n        )");
        BasicCallResolutionContext contextForVariable = basicCallResolutionContext;
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, "callResolver.resolveSimp\u2026perty(contextForVariable)");
        OverloadResolutionResults<VariableDescriptor> resolutionResult = overloadResolutionResults;
        boolean isLHSOfDot = KtPsiUtil.isLHSOfDot(nameExpression);
        if (!resolutionResult.isNothing() && resolutionResult.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER) {
            boolean isQualifier;
            boolean bl = isQualifier = isLHSOfDot && resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject;
            if (!isQualifier) {
                KotlinType kotlinType2;
                temporaryForVariable.commit();
                Boolean bl2 = true;
                if (resolutionResult.isSingleResult()) {
                    VariableDescriptor variableDescriptor = resolutionResult.getResultingDescriptor();
                    Intrinsics.checkNotNullExpressionValue(variableDescriptor, "resolutionResult.resultingDescriptor");
                    kotlinType2 = variableDescriptor.getReturnType();
                } else {
                    kotlinType2 = null;
                }
                return new Pair<Boolean, Object>(bl2, kotlinType2);
            }
        }
        temporaryForVariable.commit();
        Boolean bl = !resolutionResult.isNothing();
        if (resolutionResult.isSingleResult()) {
            VariableDescriptor variableDescriptor = resolutionResult.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(variableDescriptor, "resolutionResult.resultingDescriptor");
            kotlinType = variableDescriptor.getReturnType();
        } else {
            kotlinType = null;
        }
        return new Pair<Boolean, Object>(bl, kotlinType);
    }

    @NotNull
    public final KotlinTypeInfo getSimpleNameExpressionTypeInfo(@NotNull KtSimpleNameExpression nameExpression, @Nullable Receiver receiver, @Nullable ASTNode callOperationNode2, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter(nameExpression, "nameExpression");
        Intrinsics.checkNotNullParameter(context2, "context");
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "context.dataFlowInfo");
        return this.getSimpleNameExpressionTypeInfo(nameExpression, receiver, callOperationNode2, context2, dataFlowInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeInfo getSimpleNameExpressionTypeInfo(KtSimpleNameExpression nameExpression, Receiver receiver, ASTNode callOperationNode2, ExpressionTypingContext context2, DataFlowInfo initialDataFlowInfoForArguments) {
        void resolveResult;
        void notNothing;
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context2, "trace to resolve as variable", nameExpression);
        Object Context2 = context2.replaceTraceAndCache(temporaryForVariable);
        Intrinsics.checkNotNullExpressionValue(Context2, "context.replaceTraceAndCache(temporaryForVariable)");
        Pair<Boolean, KotlinType> pair = this.getVariableType(nameExpression, receiver, callOperationNode2, (ExpressionTypingContext)Context2);
        boolean bl = pair.component1();
        KotlinType type2 = pair.component2();
        if (notNothing != false) {
            temporaryForVariable.commit();
            return TypeInfoFactoryKt.createTypeInfo(type2, initialDataFlowInfoForArguments);
        }
        Call call2 = CallMaker.makeCall(nameExpression, receiver, callOperationNode2, nameExpression, CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(call2, "CallMaker.makeCall(nameE\u2026eExpression, emptyList())");
        Call call3 = call2;
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context2, "trace to resolve as function", nameExpression);
        Object Context3 = context2.replaceTraceAndCache(temporaryForFunction);
        Intrinsics.checkNotNullExpressionValue(Context3, "context.replaceTraceAndCache(temporaryForFunction)");
        ExpressionTypingContext newContext = (ExpressionTypingContext)Context3;
        Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair2 = this.getResolvedCallForFunction(call3, newContext, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
        boolean bl2 = pair2.component1();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = pair2.component2();
        if (resolveResult != false) {
            FunctionDescriptor functionDescriptor;
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
            FunctionDescriptor functionDescriptor2 = functionDescriptor = resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null;
            if (!(functionDescriptor instanceof ConstructorDescriptor)) {
                temporaryForFunction.commit();
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context2.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)nameExpression), nameExpression, hasValueParameters));
                FunctionDescriptor functionDescriptor3 = functionDescriptor;
                return TypeInfoFactoryKt.createTypeInfo(functionDescriptor3 != null ? functionDescriptor3.getReturnType() : null, context2);
            }
        }
        TemporaryTraceAndCache temporaryForQualifier = TemporaryTraceAndCache.create(context2, "trace to resolve as qualifier", nameExpression);
        Object Context4 = context2.replaceTraceAndCache(temporaryForQualifier);
        Intrinsics.checkNotNullExpressionValue(Context4, "context.replaceTraceAndC\u2026he(temporaryForQualifier)");
        ExpressionTypingContext contextForQualifier = (ExpressionTypingContext)Context4;
        Qualifier qualifier = this.qualifiedExpressionResolver.resolveNameExpressionAsQualifierForDiagnostics(nameExpression, receiver, contextForQualifier);
        if (qualifier != null) {
            Qualifier qualifier2 = qualifier;
            boolean bl3 = false;
            boolean bl4 = false;
            Qualifier it = qualifier2;
            boolean bl5 = false;
            QualifiedExpressionResolveUtilKt.resolveQualifierAsStandaloneExpression(it, contextForQualifier);
            temporaryForQualifier.commit();
        } else {
            temporaryForVariable.commit();
        }
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    @NotNull
    public final KotlinTypeInfo getCallExpressionTypeInfo(@NotNull KtCallExpression callExpression, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(context2, "context");
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "context.dataFlowInfo");
        KotlinTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, null, null, context2, dataFlowInfo);
        if (context2.contextDependency == ContextDependency.INDEPENDENT) {
            this.dataFlowAnalyzer.checkType(typeInfo.getType(), (KtExpression)callExpression, (ResolutionContext)context2);
        }
        return typeInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(KtCallExpression callExpression, Receiver receiver, ASTNode callOperationNode2, ExpressionTypingContext context2, DataFlowInfo initialDataFlowInfoForArguments) {
        void resolveResult;
        Call call2 = CallMaker.makeCall(receiver, callOperationNode2, callExpression);
        Intrinsics.checkNotNullExpressionValue(call2, "CallMaker.makeCall(recei\u2026tionNode, callExpression)");
        Call call3 = call2;
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context2, "trace to resolve as function call", callExpression);
        Object Context2 = context2.replaceTraceAndCache(temporaryForFunction);
        Intrinsics.checkNotNullExpressionValue(Context2, "context.replaceTraceAndCache(temporaryForFunction)");
        Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair = this.getResolvedCallForFunction(call3, (ResolutionContext<?>)Context2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
        boolean bl = pair.component1();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = pair.component2();
        if (resolveResult != false) {
            DataFlowInfo resultFlowInfo;
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
            FunctionDescriptor functionDescriptor = resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getLambdaArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context2.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)callExpression), callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                return TypeInfoFactoryKt.noTypeInfo(context2);
            }
            if (functionDescriptor instanceof ConstructorDescriptor) {
                ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
                Intrinsics.checkNotNullExpressionValue(classDescriptor2, "functionDescriptor.constructedClass");
                ClassDescriptor constructedClass = classDescriptor2;
                if (DescriptorUtils.isAnnotationClass(constructedClass)) {
                    BindingTrace bindingTrace = context2.trace;
                    Intrinsics.checkNotNullExpressionValue(bindingTrace, "context.trace");
                    if (!CallExpressionResolver.Companion.canInstantiateAnnotationClass(callExpression, bindingTrace)) {
                        context2.trace.report(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                    }
                }
                if (DescriptorUtils.isEnumClass(constructedClass)) {
                    context2.trace.report(Errors.ENUM_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
                if (DescriptorUtils.isSealedClass(constructedClass)) {
                    context2.trace.report(Errors.SEALED_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
            }
            KotlinType type2 = functionDescriptor.getReturnType();
            List<KtValueArgument> list2 = callExpression.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "callExpression.valueArguments");
            List<KtValueArgument> arguments2 = list2;
            DataFlowInfoForArguments dataFlowInfoForArguments = resolvedCall2.getDataFlowInfoForArguments();
            Intrinsics.checkNotNullExpressionValue(dataFlowInfoForArguments, "resolvedCall.dataFlowInfoForArguments");
            DataFlowInfo dataFlowInfo = dataFlowInfoForArguments.getResultInfo();
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "resolvedCall.dataFlowInfoForArguments.resultInfo");
            DataFlowInfo jumpFlowInfo = resultFlowInfo = dataFlowInfo;
            boolean jumpOutPossible = false;
            for (KtValueArgument argument : arguments2) {
                KotlinTypeInfo argTypeInfo = (KotlinTypeInfo)context2.trace.get(BindingContext.EXPRESSION_TYPE_INFO, argument.getArgumentExpression());
                if (argTypeInfo == null || !argTypeInfo.getJumpOutPossible()) continue;
                jumpOutPossible = true;
                jumpFlowInfo = argTypeInfo.getJumpFlowInfo();
                break;
            }
            return TypeInfoFactoryKt.createTypeInfo(type2, resultFlowInfo, jumpOutPossible, jumpFlowInfo);
        }
        KtExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            void notNothing;
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context2, "trace to resolve as variable with 'invoke' call", callExpression);
            KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)calleeExpression;
            Object Context3 = context2.replaceTraceAndCache(temporaryForVariable);
            Intrinsics.checkNotNullExpressionValue(Context3, "context.replaceTraceAndCache(temporaryForVariable)");
            Pair<Boolean, KotlinType> jumpFlowInfo = this.getVariableType(ktSimpleNameExpression, receiver, callOperationNode2, (ExpressionTypingContext)Context3);
            boolean arguments2 = jumpFlowInfo.component1();
            KotlinType type3 = jumpFlowInfo.component2();
            TemporaryBindingTrace temporaryBindingTrace = temporaryForVariable.trace;
            WritableSlice<KtExpression, Qualifier> writableSlice = BindingContext.QUALIFIER;
            Intrinsics.checkNotNullExpressionValue(writableSlice, "BindingContext.QUALIFIER");
            Qualifier qualifier = (Qualifier)temporaryBindingTrace.get(writableSlice, calleeExpression);
            if (!(notNothing == false || qualifier != null && qualifier instanceof PackageQualifier)) {
                KtElement ktElement = callExpression;
                TemporaryBindingTrace temporaryBindingTrace2 = temporaryForVariable.trace;
                Intrinsics.checkNotNullExpressionValue(temporaryBindingTrace2, "temporaryForVariable.trace");
                ResolvedCall<? extends CallableDescriptor> resolvedCall4 = CallUtilKt.getResolvedCall(ktElement, temporaryBindingTrace2.getBindingContext());
                boolean bl2 = false;
                boolean bl3 = false;
                ResolvedCall<? extends CallableDescriptor> it = resolvedCall4;
                boolean bl4 = false;
                ResolvedCall<? extends CallableDescriptor> resolvedCall5 = it;
                if (!(resolvedCall5 instanceof ResolvedCallImpl)) {
                    resolvedCall5 = null;
                }
                ResolvedCallImpl resolvedCallImpl = (ResolvedCallImpl)resolvedCall5;
                if (resolvedCallImpl != null) {
                    resolvedCallImpl.addStatus(ResolutionStatus.OTHER_ERROR);
                }
                temporaryForVariable.commit();
                BindingTrace bindingTrace = context2.trace;
                PsiElement psiElement = calleeExpression;
                KotlinType kotlinType = type3;
                if (kotlinType == null) {
                    SimpleType simpleType2 = ErrorUtils.createErrorType("");
                    Intrinsics.checkNotNullExpressionValue(simpleType2, "ErrorUtils.createErrorType(\"\")");
                    kotlinType = simpleType2;
                }
                bindingTrace.report(Errors.FUNCTION_EXPECTED.on((KtExpression)psiElement, calleeExpression, kotlinType));
                this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(BasicCallResolutionContext.create(context2, call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call3)), ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
                return TypeInfoFactoryKt.noTypeInfo(context2);
            }
        }
        temporaryForFunction.commit();
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    private final List<CallExpressionElement> elementChain(KtQualifiedExpression $this$elementChain, ExpressionTypingContext context2) {
        return this.qualifiedExpressionResolver.resolveQualifierInExpressionAndUnroll($this$elementChain, context2, (Function1<? super KtSimpleNameExpression, Boolean>)new Function1<KtSimpleNameExpression, Boolean>(this, context2){
            final /* synthetic */ CallExpressionResolver this$0;
            final /* synthetic */ ExpressionTypingContext $context;

            public final boolean invoke(@NotNull KtSimpleNameExpression nameExpression) {
                boolean bl;
                TemporaryTraceAndCache temporaryTraceAndCache;
                Intrinsics.checkNotNullParameter(nameExpression, "nameExpression");
                TemporaryTraceAndCache temporaryTraceAndCache2 = temporaryTraceAndCache = TemporaryTraceAndCache.create(this.$context, "trace to resolve as local variable or property", nameExpression);
                Intrinsics.checkNotNullExpressionValue(temporaryTraceAndCache2, "temporaryTraceAndCache");
                OverloadResolutionResults resolutionResult = CallExpressionResolver.access$resolveSimpleName(this.this$0, this.$context, nameExpression, temporaryTraceAndCache2);
                if (resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject) {
                    bl = false;
                } else {
                    switch (CallExpressionResolver$WhenMappings.$EnumSwitchMapping$0[resolutionResult.getResultCode().ordinal()]) {
                        case 1: 
                        case 2: {
                            bl = false;
                            break;
                        }
                        default: {
                            boolean success;
                            boolean newInferenceEnabled = this.$context.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
                            boolean bl2 = success = !newInferenceEnabled || resolutionResult.isSuccess();
                            if (newInferenceEnabled && success) {
                                temporaryTraceAndCache.commit();
                            }
                            bl = success;
                        }
                    }
                }
                return bl;
            }
            {
                this.this$0 = callExpressionResolver;
                this.$context = expressionTypingContext;
                super(1);
            }
        });
    }

    private final OverloadResolutionResults<VariableDescriptor> resolveSimpleName(ExpressionTypingContext context2, KtSimpleNameExpression expression2, TemporaryTraceAndCache traceAndCache) {
        Call call2 = CallMaker.makePropertyCall(null, null, expression2);
        Intrinsics.checkNotNullExpressionValue(call2, "CallMaker.makePropertyCall(null, null, expression)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context2.replaceTraceAndCache(traceAndCache), call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkNotNullExpressionValue(basicCallResolutionContext, "BasicCallResolutionConte\u2026VALUE_ARGUMENTS\n        )");
        BasicCallResolutionContext contextForVariable = basicCallResolutionContext;
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, "callResolver.resolveSimp\u2026perty(contextForVariable)");
        return overloadResolutionResults;
    }

    private final KotlinTypeInfo getUnsafeSelectorTypeInfo(Receiver receiver, ASTNode callOperationNode2, KtExpression selectorExpression, ExpressionTypingContext context2, DataFlowInfo initialDataFlowInfoForArguments) {
        KotlinTypeInfo kotlinTypeInfo;
        KtExpression ktExpression = selectorExpression;
        if (ktExpression instanceof KtCallExpression) {
            kotlinTypeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck((KtCallExpression)selectorExpression, receiver, callOperationNode2, context2, initialDataFlowInfoForArguments);
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            kotlinTypeInfo = this.getSimpleNameExpressionTypeInfo((KtSimpleNameExpression)selectorExpression, receiver, callOperationNode2, context2, initialDataFlowInfoForArguments);
        } else if (ktExpression instanceof KtExpression) {
            ExpressionTypingServices expressionTypingServices = this.expressionTypingServices;
            if (expressionTypingServices == null) {
                Intrinsics.throwUninitializedPropertyAccessException("expressionTypingServices");
            }
            expressionTypingServices.getTypeInfo(selectorExpression, context2);
            context2.trace.report(Errors.ILLEGAL_SELECTOR.on((KtExpression)((PsiElement)selectorExpression)));
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
        } else {
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
        }
        return kotlinTypeInfo;
    }

    private final KotlinTypeInfo getSafeOrUnsafeSelectorTypeInfo(Receiver receiver, CallExpressionElement element, ExpressionTypingContext context2) {
        KotlinType selectorType;
        KotlinTypeInfo kotlinTypeInfo;
        DataFlowValue dataFlowValue2;
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "context.dataFlowInfo");
        DataFlowInfo initialDataFlowInfoForArguments = dataFlowInfo;
        Receiver receiver2 = receiver;
        if (!(receiver2 instanceof ReceiverValue)) {
            receiver2 = null;
        }
        ReceiverValue receiverValue = (ReceiverValue)receiver2;
        if (receiverValue != null) {
            ReceiverValue receiverValue2 = receiverValue;
            boolean bl = false;
            boolean bl2 = false;
            ReceiverValue it = receiverValue2;
            boolean bl3 = false;
            dataFlowValue2 = this.dataFlowValueFactory.createDataFlowValue(it, context2);
        } else {
            dataFlowValue2 = null;
        }
        DataFlowValue receiverDataFlowValue = dataFlowValue2;
        boolean receiverCanBeNull = receiverDataFlowValue != null && initialDataFlowInfoForArguments.getStableNullability(receiverDataFlowValue).canBeNull();
        ASTNode callOperationNode2 = (ASTNode)AstLoadingFilter.forceAllowTreeLoading(element.getQualified().getContainingFile(), (ThrowableComputable)new ThrowableComputable<ASTNode, Throwable>(element){
            final /* synthetic */ CallExpressionElement $element;

            public final ASTNode compute() {
                return this.$element.getNode();
            }
            {
                this.$element = callExpressionElement;
            }
        });
        if (receiverDataFlowValue != null && element.getSafe()) {
            if (receiverCanBeNull) {
                initialDataFlowInfoForArguments = initialDataFlowInfoForArguments.disequate(receiverDataFlowValue, DataFlowValue.Companion.nullValue(this.builtIns), this.languageVersionSettings);
            } else {
                BindingTrace bindingTrace = context2.trace;
                Intrinsics.checkNotNullExpressionValue(bindingTrace, "context.trace");
                KotlinType kotlinType = ((ReceiverValue)receiver).getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "receiver.type");
                ASTNode aSTNode = callOperationNode2;
                Intrinsics.checkNotNullExpressionValue(aSTNode, "callOperationNode");
                Companion.reportUnnecessarySafeCall(bindingTrace, kotlinType, aSTNode, receiver);
            }
        }
        KtExpression selector = element.getSelector();
        KotlinTypeInfo bl3 = this.getUnsafeSelectorTypeInfo(receiver, callOperationNode2, selector, context2, initialDataFlowInfoForArguments);
        boolean bl = false;
        boolean bl4 = false;
        KotlinTypeInfo $this$run = bl3;
        boolean bl5 = false;
        KotlinType kotlinType = $this$run.getType();
        if (kotlinType == null) {
            kotlinTypeInfo = $this$run;
        } else {
            KotlinType type2 = kotlinType;
            kotlinTypeInfo = $this$run.replaceType(this.kotlinTypeRefiner.refineType(type2));
        }
        KotlinTypeInfo selectorTypeInfo = kotlinTypeInfo;
        if (receiver instanceof Qualifier) {
            this.resolveDeferredReceiverInQualifiedExpression((Qualifier)receiver, selector, context2);
        }
        if ((selectorType = selectorTypeInfo.getType()) != null) {
            if (element.getSafe() && receiverCanBeNull) {
                selectorTypeInfo = selectorTypeInfo.replaceType(TypeUtils.makeNullable(selectorType));
            }
            if (selector != null) {
                context2.trace.recordType(selector, selectorTypeInfo.getType());
            }
        }
        return selectorTypeInfo;
    }

    private final KotlinTypeInfo checkSelectorTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo selectorTypeInfo, ExpressionTypingContext context2) {
        KotlinTypeInfo kotlinTypeInfo;
        CallExpressionResolver.Companion.checkNestedClassAccess(qualified, context2);
        KtExpression ktExpression = qualified;
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "context.trace");
        CompileTimeConstant<?> value2 = this.constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, context2.expectedType);
        if (value2 != null && value2.isPure()) {
            KotlinTypeInfo kotlinTypeInfo2 = this.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, qualified, context2);
            kotlinTypeInfo = kotlinTypeInfo2;
            Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo2, "dataFlowAnalyzer.createC\u2026alue, qualified, context)");
        } else {
            if (context2.contextDependency == ContextDependency.INDEPENDENT) {
                this.dataFlowAnalyzer.checkType(selectorTypeInfo.getType(), (KtExpression)qualified, (ResolutionContext)context2);
            }
            kotlinTypeInfo = selectorTypeInfo;
        }
        return kotlinTypeInfo;
    }

    private final void recordResultTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo resultTypeInfo, ExpressionTypingContext context2) {
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "context.trace");
        BindingTrace trace = bindingTrace;
        if (Intrinsics.areEqual((Boolean)trace.get(BindingContext.PROCESSED, qualified), true) ^ true) {
            trace.record(BindingContext.PROCESSED, qualified);
            trace.record(BindingContext.EXPRESSION_TYPE_INFO, qualified, resultTypeInfo);
            LexicalScope lexicalScope = context2.scope;
            Intrinsics.checkNotNullExpressionValue(lexicalScope, "context.scope");
            BindingContextUtilsKt.recordScope(trace, lexicalScope, qualified);
            Object Context2 = context2.replaceDataFlowInfo(resultTypeInfo.getDataFlowInfo());
            Intrinsics.checkNotNullExpressionValue(Context2, "context.replaceDataFlowI\u2026ultTypeInfo.dataFlowInfo)");
            BindingContextUtilsKt.recordDataFlowInfo(Context2, qualified);
        }
    }

    @NotNull
    public final KotlinTypeInfo getQualifiedExpressionTypeInfo(@NotNull KtQualifiedExpression expression2, @NotNull ExpressionTypingContext context2) {
        KotlinTypeInfo receiverTypeInfo;
        KotlinTypeInfo kotlinTypeInfo;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object Context2 = ((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, "context.replaceExpectedT\u2026xtDependency(INDEPENDENT)");
        ExpressionTypingContext currentContext = (ExpressionTypingContext)Context2;
        BindingTrace bindingTrace = currentContext.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "currentContext.trace");
        BindingTrace trace = bindingTrace;
        List<CallExpressionElement> elementChain2 = this.elementChain(expression2, currentContext);
        KtExpression firstReceiver = CollectionsKt.first(elementChain2).getReceiver();
        Qualifier qualifier = (Qualifier)trace.get(BindingContext.QUALIFIER, firstReceiver);
        if (qualifier == null) {
            ExpressionTypingServices expressionTypingServices = this.expressionTypingServices;
            if (expressionTypingServices == null) {
                Intrinsics.throwUninitializedPropertyAccessException("expressionTypingServices");
            }
            kotlinTypeInfo = expressionTypingServices.getTypeInfo(firstReceiver, currentContext);
        } else {
            DataFlowInfo dataFlowInfo = currentContext.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "currentContext.dataFlowInfo");
            kotlinTypeInfo = new KotlinTypeInfo(null, dataFlowInfo, false, null, 12, null);
        }
        Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo, "when (trace.get(BindingC\u2026t.dataFlowInfo)\n        }");
        KotlinTypeInfo resultTypeInfo = receiverTypeInfo = kotlinTypeInfo;
        boolean allUnsafe = true;
        DataFlowInfo branchPointDataFlowInfo = receiverTypeInfo.getDataFlowInfo();
        for (CallExpressionElement element : elementChain2) {
            Receiver receiver;
            Object receiver2;
            KotlinType kotlinType = receiverTypeInfo.getType();
            if (kotlinType == null) {
                SimpleType simpleType2 = ErrorUtils.createErrorType("Type for " + ((receiver2 = element.getReceiver()) instanceof KtNameReferenceExpression ? ((KtNameReferenceExpression)receiver2).getReferencedName() : receiver2.getText()));
                Intrinsics.checkNotNullExpressionValue(simpleType2, "ErrorUtils.createErrorTy\u2026      }\n                )");
                kotlinType = simpleType2;
            }
            KotlinType receiverType = kotlinType;
            Qualifier qualifier2 = (Qualifier)trace.get(BindingContext.QUALIFIER, element.getReceiver());
            if (qualifier2 != null) {
                receiver = qualifier2;
            } else {
                KtExpression ktExpression = element.getReceiver();
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
                receiver = ExpressionReceiver.Companion.create(ktExpression, receiverType, bindingContext);
            }
            receiver2 = receiver;
            KtQualifiedExpression qualifiedExpression = element.getQualified();
            boolean lastStage = qualifiedExpression == expression2;
            Object Context3 = (lastStage ? context2 : currentContext).replaceDataFlowInfo(receiver2 instanceof ReceiverValue && TypeUtils.isNullableType(((ReceiverValue)receiver2).getType()) && !element.getSafe() ? branchPointDataFlowInfo : receiverTypeInfo.getDataFlowInfo());
            Intrinsics.checkNotNullExpressionValue(Context3, "(if (lastStage) context \u2026          }\n            )");
            ExpressionTypingContext contextForSelector = (ExpressionTypingContext)Context3;
            KotlinTypeInfo selectorTypeInfo = this.getSafeOrUnsafeSelectorTypeInfo((Receiver)receiver2, element, contextForSelector);
            boolean bl = allUnsafe = allUnsafe && !element.getSafe();
            if (allUnsafe) {
                branchPointDataFlowInfo = selectorTypeInfo.getDataFlowInfo();
            }
            resultTypeInfo = this.checkSelectorTypeInfo(qualifiedExpression, selectorTypeInfo, contextForSelector).replaceDataFlowInfo(branchPointDataFlowInfo);
            if (!lastStage) {
                this.recordResultTypeInfo(qualifiedExpression, resultTypeInfo, contextForSelector);
            }
            receiverTypeInfo = selectorTypeInfo;
        }
        return resultTypeInfo;
    }

    private final void resolveDeferredReceiverInQualifiedExpression(Qualifier qualifier, KtExpression selectorExpression, ExpressionTypingContext context2) {
        DeclarationDescriptor declarationDescriptor;
        KtExpression calleeExpression = KtPsiUtil.deparenthesize(CallUtilKt.getCalleeExpressionIfAny(selectorExpression));
        KtExpression ktExpression = calleeExpression;
        if (!(ktExpression instanceof KtReferenceExpression)) {
            ktExpression = null;
        }
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)ktExpression;
        if (ktReferenceExpression != null) {
            KtReferenceExpression ktReferenceExpression2 = ktReferenceExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtReferenceExpression it = ktReferenceExpression2;
            boolean bl3 = false;
            declarationDescriptor = (DeclarationDescriptor)context2.trace.get(BindingContext.REFERENCE_TARGET, it);
        } else {
            declarationDescriptor = null;
        }
        DeclarationDescriptor selectorDescriptor = declarationDescriptor;
        QualifiedExpressionResolveUtilKt.resolveQualifierAsReceiverInExpression(qualifier, selectorDescriptor, context2);
    }

    public CallExpressionResolver(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull KotlinBuiltIns builtIns, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(callResolver, "callResolver");
        Intrinsics.checkNotNullParameter(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkNotNullParameter(dataFlowAnalyzer, "dataFlowAnalyzer");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(dataFlowValueFactory, "dataFlowValueFactory");
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.argumentTypeResolver = argumentTypeResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.builtIns = builtIns;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
    }

    public static final /* synthetic */ OverloadResolutionResults access$resolveSimpleName(CallExpressionResolver $this, ExpressionTypingContext context2, KtSimpleNameExpression expression2, TemporaryTraceAndCache traceAndCache) {
        return $this.resolveSimpleName(context2, expression2, traceAndCache);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver$Companion;", "", "()V", "canInstantiateAnnotationClass", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkNestedClassAccess", "", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "isUnderAnnotationClassDeclaration", "parent", "Lcom/intellij/psi/PsiElement;", "reportUnnecessarySafeCall", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "callOperationNode", "Lcom/intellij/lang/ASTNode;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "frontend"})
    public static final class Companion {
        private final boolean canInstantiateAnnotationClass(KtCallExpression expression2, BindingTrace trace) {
            Object parent2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, KtValueArgument.class, KtParameter.class);
            if (parent2 instanceof KtValueArgument) {
                Object $this$getParentOfType$iv;
                Object t = parent2;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtAnnotationEntry.class, strict$iv) != null) {
                    return true;
                }
                $this$getParentOfType$iv = parent2;
                strict$iv = true;
                $i$f$getParentOfType = false;
                parent2 = PsiTreeUtil.getParentOfType($this$getParentOfType$iv, KtParameter.class, strict$iv);
                if (parent2 != null) {
                    return this.isUnderAnnotationClassDeclaration(trace, (PsiElement)parent2);
                }
            } else if (parent2 instanceof KtParameter) {
                return this.isUnderAnnotationClassDeclaration(trace, (PsiElement)parent2);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isUnderAnnotationClassDeclaration(BindingTrace trace, PsiElement parent2) {
            boolean bl;
            void $this$getParentOfType$iv;
            PsiElement psiElement = parent2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtClass ktClass = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, strict$iv);
            if (ktClass != null) {
                psiElement = ktClass;
                boolean bl2 = false;
                boolean bl3 = false;
                PsiElement it = psiElement;
                boolean bl4 = false;
                bl = DescriptorUtils.isAnnotationClass(trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it));
            } else {
                bl = false;
            }
            return bl;
        }

        public final void reportUnnecessarySafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, @NotNull ASTNode callOperationNode2, @Nullable Receiver explicitReceiver) {
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(callOperationNode2, "callOperationNode");
            trace.report(explicitReceiver instanceof ExpressionReceiver && ((ExpressionReceiver)explicitReceiver).getExpression() instanceof KtSuperExpression ? (ParametrizedDiagnostic)Errors.UNEXPECTED_SAFE_CALL.on(callOperationNode2.getPsi()) : Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode2.getPsi(), type2));
        }

        private final void checkNestedClassAccess(KtQualifiedExpression expression2, ExpressionTypingContext context2) {
            KtExpression ktExpression = expression2.getSelectorExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression selectorExpression = ktExpression;
            Qualifier expressionQualifier = (Qualifier)context2.trace.get(BindingContext.QUALIFIER, expression2);
            Qualifier receiverQualifier = (Qualifier)context2.trace.get(BindingContext.QUALIFIER, expression2.getReceiverExpression());
            if (receiverQualifier == null && expressionQualifier != null) {
                boolean bl = expressionQualifier instanceof ClassifierQualifier;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Only class can (package cannot) be accessed by instance reference: " + expressionQualifier;
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                ClassifierDescriptorWithTypeParameters descriptor2 = ((ClassifierQualifier)expressionQualifier).getDescriptor();
                context2.trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on((KtExpression)((PsiElement)selectorExpression), descriptor2));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

