/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Value;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplePeekCallTraceInterpreter
implements CallTraceInterpreter {
    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call2, @NotNull Value value) {
        if (call2 == null) {
            SimplePeekCallTraceInterpreter.$$$reportNull$$$0(0);
        }
        if (value == null) {
            SimplePeekCallTraceInterpreter.$$$reportNull$$$0(1);
        }
        if (value instanceof ArrayReference) {
            ArrayReference trace = (ArrayReference)value;
            Value before = trace.getValue(0);
            Value after = trace.getValue(1);
            if (before instanceof ArrayReference && after instanceof ArrayReference) {
                Map<Integer, TraceElement> beforeTrace = SimplePeekCallTraceInterpreter.resolveTrace((ArrayReference)before);
                Map<Integer, TraceElement> afterTrace = SimplePeekCallTraceInterpreter.resolveTrace((ArrayReference)after);
                return new ValuesOrderInfo(call2, beforeTrace, afterTrace);
            }
        }
        throw new UnexpectedValueException("peek operation trace is wrong format");
    }

    @NotNull
    private static Map<Integer, TraceElement> resolveTrace(@NotNull ArrayReference mapArray) {
        if (mapArray == null) {
            SimplePeekCallTraceInterpreter.$$$reportNull$$$0(2);
        }
        Value keys = mapArray.getValue(0);
        Value values = mapArray.getValue(1);
        if (keys instanceof ArrayReference && values instanceof ArrayReference) {
            return SimplePeekCallTraceInterpreter.resolveTrace((ArrayReference)keys, (ArrayReference)values);
        }
        throw new UnexpectedValueException("keys and values must be stored in arrays in peek resolver");
    }

    @NotNull
    private static Map<Integer, TraceElement> resolveTrace(@NotNull ArrayReference keysArray, @NotNull ArrayReference valuesArray) {
        if (keysArray == null) {
            SimplePeekCallTraceInterpreter.$$$reportNull$$$0(3);
        }
        if (valuesArray == null) {
            SimplePeekCallTraceInterpreter.$$$reportNull$$$0(4);
        }
        LinkedHashMap<Integer, TraceElement> result = new LinkedHashMap<Integer, TraceElement>();
        List<Value> keyMirrors = keysArray.getValues();
        List<Value> valueMirrors = valuesArray.getValues();
        if (keyMirrors.size() == valueMirrors.size()) {
            int size = keyMirrors.size();
            for (int i = 0; i < size; ++i) {
                TraceElement element = SimplePeekCallTraceInterpreter.resolveTraceElement(keyMirrors.get(i), valueMirrors.get(i));
                result.put(element.getTime(), element);
            }
            LinkedHashMap<Integer, TraceElement> linkedHashMap = result;
            if (linkedHashMap == null) {
                SimplePeekCallTraceInterpreter.$$$reportNull$$$0(5);
            }
            return linkedHashMap;
        }
        throw new UnexpectedValueException("keys and values arrays should be with the same sizes");
    }

    @NotNull
    private static TraceElement resolveTraceElement(@NotNull Value key, @Nullable Value value) {
        if (key == null) {
            SimplePeekCallTraceInterpreter.$$$reportNull$$$0(6);
        }
        if (key instanceof IntegerValue) {
            return new TraceElementImpl(((IntegerValue)key).value(), value);
        }
        throw new UnexpectedValueException("key must be an integer value");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapArray";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keysArray";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesArray";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/trace/impl/interpret/SimplePeekCallTraceInterpreter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/trace/impl/interpret/SimplePeekCallTraceInterpreter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveTrace";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveTraceElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

