/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSpecializationMapEntry;

public class VkSpecializationInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAPENTRYCOUNT;
    public static final int PMAPENTRIES;
    public static final int DATASIZE;
    public static final int PDATA;

    public VkSpecializationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSpecializationInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int mapEntryCount() {
        return VkSpecializationInfo.nmapEntryCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSpecializationMapEntry const *")
    public VkSpecializationMapEntry.Buffer pMapEntries() {
        return VkSpecializationInfo.npMapEntries(this.address());
    }

    @NativeType(value="size_t")
    public long dataSize() {
        return VkSpecializationInfo.ndataSize(this.address());
    }

    @Nullable
    @NativeType(value="void const *")
    public ByteBuffer pData() {
        return VkSpecializationInfo.npData(this.address());
    }

    public VkSpecializationInfo pMapEntries(@Nullable @NativeType(value="VkSpecializationMapEntry const *") VkSpecializationMapEntry.Buffer value) {
        VkSpecializationInfo.npMapEntries(this.address(), value);
        return this;
    }

    public VkSpecializationInfo pData(@Nullable @NativeType(value="void const *") ByteBuffer value) {
        VkSpecializationInfo.npData(this.address(), value);
        return this;
    }

    public VkSpecializationInfo set(@Nullable VkSpecializationMapEntry.Buffer pMapEntries, @Nullable ByteBuffer pData) {
        this.pMapEntries(pMapEntries);
        this.pData(pData);
        return this;
    }

    public VkSpecializationInfo set(VkSpecializationInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSpecializationInfo malloc() {
        return (VkSpecializationInfo)VkSpecializationInfo.wrap(VkSpecializationInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSpecializationInfo calloc() {
        return (VkSpecializationInfo)VkSpecializationInfo.wrap(VkSpecializationInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSpecializationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSpecializationInfo)VkSpecializationInfo.wrap(VkSpecializationInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSpecializationInfo create(long address) {
        return (VkSpecializationInfo)VkSpecializationInfo.wrap(VkSpecializationInfo.class, (long)address);
    }

    @Nullable
    public static VkSpecializationInfo createSafe(long address) {
        return address == 0L ? null : (VkSpecializationInfo)VkSpecializationInfo.wrap(VkSpecializationInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSpecializationInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSpecializationInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSpecializationInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSpecializationInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSpecializationInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSpecializationInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSpecializationInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSpecializationInfo mallocStack() {
        return VkSpecializationInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSpecializationInfo callocStack() {
        return VkSpecializationInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSpecializationInfo mallocStack(MemoryStack stack) {
        return (VkSpecializationInfo)VkSpecializationInfo.wrap(VkSpecializationInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSpecializationInfo callocStack(MemoryStack stack) {
        return (VkSpecializationInfo)VkSpecializationInfo.wrap(VkSpecializationInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSpecializationInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSpecializationInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSpecializationInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSpecializationInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nmapEntryCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAPENTRYCOUNT);
    }

    @Nullable
    public static VkSpecializationMapEntry.Buffer npMapEntries(long struct) {
        return VkSpecializationMapEntry.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PMAPENTRIES)), VkSpecializationInfo.nmapEntryCount(struct));
    }

    public static long ndataSize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DATASIZE));
    }

    @Nullable
    public static ByteBuffer npData(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PDATA)), (int)((int)VkSpecializationInfo.ndataSize(struct)));
    }

    public static void nmapEntryCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAPENTRYCOUNT, value);
    }

    public static void npMapEntries(long struct, @Nullable VkSpecializationMapEntry.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PMAPENTRIES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkSpecializationInfo.nmapEntryCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ndataSize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATASIZE), (long)value);
    }

    public static void npData(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDATA), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
        VkSpecializationInfo.ndataSize(struct, value == null ? 0L : (long)value.remaining());
    }

    public static void validate(long struct) {
        if (VkSpecializationInfo.nmapEntryCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PMAPENTRIES)));
        }
        if (VkSpecializationInfo.ndataSize(struct) != 0L) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDATA)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSpecializationInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkSpecializationInfo.__struct((Struct.Member[])new Struct.Member[]{VkSpecializationInfo.__member((int)4), VkSpecializationInfo.__member((int)POINTER_SIZE), VkSpecializationInfo.__member((int)POINTER_SIZE), VkSpecializationInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAPENTRYCOUNT = layout.offsetof(0);
        PMAPENTRIES = layout.offsetof(1);
        DATASIZE = layout.offsetof(2);
        PDATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkSpecializationInfo, Buffer>
    implements NativeResource {
        private static final VkSpecializationInfo ELEMENT_FACTORY = VkSpecializationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSpecializationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int mapEntryCount() {
            return VkSpecializationInfo.nmapEntryCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSpecializationMapEntry const *")
        public VkSpecializationMapEntry.Buffer pMapEntries() {
            return VkSpecializationInfo.npMapEntries(this.address());
        }

        @NativeType(value="size_t")
        public long dataSize() {
            return VkSpecializationInfo.ndataSize(this.address());
        }

        @Nullable
        @NativeType(value="void const *")
        public ByteBuffer pData() {
            return VkSpecializationInfo.npData(this.address());
        }

        public Buffer pMapEntries(@Nullable @NativeType(value="VkSpecializationMapEntry const *") VkSpecializationMapEntry.Buffer value) {
            VkSpecializationInfo.npMapEntries(this.address(), value);
            return this;
        }

        public Buffer pData(@Nullable @NativeType(value="void const *") ByteBuffer value) {
            VkSpecializationInfo.npData(this.address(), value);
            return this;
        }
    }
}

