/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CU50;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class CU55
extends CU50 {
    public static final int CU_JIT_INPUT_CUBIN = 0;
    public static final int CU_JIT_INPUT_PTX = 1;
    public static final int CU_JIT_INPUT_FATBINARY = 2;
    public static final int CU_JIT_INPUT_OBJECT = 3;
    public static final int CU_JIT_INPUT_LIBRARY = 4;

    protected CU55() {
        throw new UnsupportedOperationException();
    }

    public static int ncuLinkCreate(int numOptions, long options, long optionValues, long stateOut) {
        long __functionAddress = Functions.LinkCreate;
        return JNI.callPPPI((int)numOptions, (long)options, (long)optionValues, (long)stateOut, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuLinkCreate(@Nullable @NativeType(value="CUjit_option *") IntBuffer options, @Nullable @NativeType(value="void **") PointerBuffer optionValues, @NativeType(value="CUlinkState *") PointerBuffer stateOut) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)optionValues, (int)Checks.remainingSafe((Buffer)options));
            Checks.check((CustomBuffer)stateOut, (int)1);
        }
        return CU55.ncuLinkCreate(Checks.remainingSafe((Buffer)options), MemoryUtil.memAddressSafe((IntBuffer)options), MemoryUtil.memAddressSafe((Pointer)optionValues), MemoryUtil.memAddress((CustomBuffer)stateOut));
    }

    public static int ncuLinkAddData(long state, int type, long data, long size, long name, int numOptions, long options, long optionValues) {
        long __functionAddress = Functions.LinkAddData;
        if (Checks.CHECKS) {
            Checks.check((long)state);
        }
        return JNI.callPPPPPPI((long)state, (int)type, (long)data, (long)size, (long)name, (int)numOptions, (long)options, (long)optionValues, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuLinkAddData(@NativeType(value="CUlinkState") long state, @NativeType(value="CUjitInputType") int type, @NativeType(value="void *") ByteBuffer data, @NativeType(value="char const *") ByteBuffer name, @Nullable @NativeType(value="CUjit_option *") IntBuffer options, @Nullable @NativeType(value="void **") PointerBuffer optionValues) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
            Checks.checkSafe((CustomBuffer)optionValues, (int)Checks.remainingSafe((Buffer)options));
        }
        return CU55.ncuLinkAddData(state, type, MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), MemoryUtil.memAddress((ByteBuffer)name), Checks.remainingSafe((Buffer)options), MemoryUtil.memAddressSafe((IntBuffer)options), MemoryUtil.memAddressSafe((Pointer)optionValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="CUresult")
    public static int cuLinkAddData(@NativeType(value="CUlinkState") long state, @NativeType(value="CUjitInputType") int type, @NativeType(value="void *") ByteBuffer data, @NativeType(value="char const *") CharSequence name, @Nullable @NativeType(value="CUjit_option *") IntBuffer options, @Nullable @NativeType(value="void **") PointerBuffer optionValues) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)optionValues, (int)Checks.remainingSafe((Buffer)options));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = CU55.ncuLinkAddData(state, type, MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), nameEncoded, Checks.remainingSafe((Buffer)options), MemoryUtil.memAddressSafe((IntBuffer)options), MemoryUtil.memAddressSafe((Pointer)optionValues));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int ncuLinkAddFile(long state, int type, long path, int numOptions, long options, long optionValues) {
        long __functionAddress = Functions.LinkAddFile;
        if (Checks.CHECKS) {
            Checks.check((long)state);
        }
        return JNI.callPPPPI((long)state, (int)type, (long)path, (int)numOptions, (long)options, (long)optionValues, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuLinkAddFile(@NativeType(value="CUlinkState") long state, @NativeType(value="CUjitInputType") int type, @NativeType(value="char const *") ByteBuffer path, @Nullable @NativeType(value="CUjit_option *") IntBuffer options, @Nullable @NativeType(value="void **") PointerBuffer optionValues) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)path);
            Checks.checkSafe((CustomBuffer)optionValues, (int)Checks.remainingSafe((Buffer)options));
        }
        return CU55.ncuLinkAddFile(state, type, MemoryUtil.memAddress((ByteBuffer)path), Checks.remainingSafe((Buffer)options), MemoryUtil.memAddressSafe((IntBuffer)options), MemoryUtil.memAddressSafe((Pointer)optionValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="CUresult")
    public static int cuLinkAddFile(@NativeType(value="CUlinkState") long state, @NativeType(value="CUjitInputType") int type, @NativeType(value="char const *") CharSequence path, @Nullable @NativeType(value="CUjit_option *") IntBuffer options, @Nullable @NativeType(value="void **") PointerBuffer optionValues) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)optionValues, (int)Checks.remainingSafe((Buffer)options));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(path, true);
            long pathEncoded = stack.getPointerAddress();
            int n = CU55.ncuLinkAddFile(state, type, pathEncoded, Checks.remainingSafe((Buffer)options), MemoryUtil.memAddressSafe((IntBuffer)options), MemoryUtil.memAddressSafe((Pointer)optionValues));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int ncuLinkComplete(long state, long cubinOut, long sizeOut) {
        long __functionAddress = Functions.LinkComplete;
        if (Checks.CHECKS) {
            Checks.check((long)state);
        }
        return JNI.callPPPI((long)state, (long)cubinOut, (long)sizeOut, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuLinkComplete(@NativeType(value="CUlinkState") long state, @NativeType(value="void **") PointerBuffer cubinOut, @NativeType(value="size_t *") PointerBuffer sizeOut) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)cubinOut, (int)1);
            Checks.check((CustomBuffer)sizeOut, (int)1);
        }
        return CU55.ncuLinkComplete(state, MemoryUtil.memAddress((CustomBuffer)cubinOut), MemoryUtil.memAddress((CustomBuffer)sizeOut));
    }

    @NativeType(value="CUresult")
    public static int cuLinkDestroy(@NativeType(value="CUlinkState") long state) {
        long __functionAddress = Functions.LinkDestroy;
        if (Checks.CHECKS) {
            Checks.check((long)state);
        }
        return JNI.callPI((long)state, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long LinkCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_VERSION("cuLinkCreate", 2));
        public static final long LinkAddData = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_VERSION("cuLinkAddData", 2));
        public static final long LinkAddFile = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_VERSION("cuLinkAddFile", 2));
        public static final long LinkComplete = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuLinkComplete");
        public static final long LinkDestroy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuLinkDestroy");

        private Functions() {
        }
    }
}

