/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * asinh(vec2(0.0, 1e-10)) => vec2(0.0, 1e-10)
 * asinh(vec2(-1e-10, 0.1)) => vec2(-1e-10, 0.09983408)
 * asinh(vec2(-0.1, 1.0)) => vec2(-0.09983408, 0.8813736)
 * asinh(vec2(-1.0, 10.0)) => vec2(-0.8813736, 2.998223)
 * asinh(vec2(-10.0, 10000000000.0)) => vec2(-2.998223, 23.718998)
 * asinh(vec2(-10000000000.0, 0.0)) => vec2(-23.718998, 0.0)
 */
#version 150

void main()
{
  float[distance(asinh(vec2(0.0, 1e-10)), vec2(0.0, 1e-10)) <= 0.00014142135 ? 1 : -1] array0;
  float[distance(asinh(vec2(-1e-10, 0.1)), vec2(-1e-10, 0.09983408)) <= 0.00014142135 ? 1 : -1] array1;
  float[distance(asinh(vec2(-0.1, 1.0)), vec2(-0.09983408, 0.8813736)) <= 0.0008870284 ? 1 : -1] array2;
  float[distance(asinh(vec2(-1.0, 10.0)), vec2(-0.8813736, 2.998223)) <= 0.0031250857 ? 1 : -1] array3;
  float[distance(asinh(vec2(-10.0, 10000000000.0)), vec2(-2.998223, 23.718998)) <= 0.023907743 ? 1 : -1] array4;
  float[distance(asinh(vec2(-10000000000.0, 0.0)), vec2(-23.718998, 0.0)) <= 0.023719208 ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
