/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.util.ArrayList;

class RowHeader {
    private String m_id;
    private int m_sequence;
    private Integer m_type;
    private int m_subtype;

    public RowHeader(String string) {
        this.parse(string);
    }

    private void parse(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        while (n < string.length()) {
            char c;
            if (Character.isDigit(c = string.charAt(n++))) {
                stringBuilder.append(c);
                continue;
            }
            if (stringBuilder.length() == 0) continue;
            arrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        if (stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString());
        }
        this.m_id = (String)arrayList.get(0);
        this.m_sequence = Integer.parseInt((String)arrayList.get(1));
        this.m_type = Integer.valueOf((String)arrayList.get(2));
        if (arrayList.size() > 3) {
            this.m_subtype = Integer.parseInt((String)arrayList.get(3));
        }
    }

    public String getID() {
        return this.m_id;
    }

    public int getSequence() {
        return this.m_sequence;
    }

    public Integer getType() {
        return this.m_type;
    }

    public int getSubtype() {
        return this.m_subtype;
    }

    public String toString() {
        return "[RowHeader id=" + this.m_id + " sequence=" + this.m_sequence + " type=" + this.m_type + " subtype=" + this.m_subtype + "]";
    }
}

