# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2021 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.vmc.orgs.sddcs.clusters.esxs.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class StorageSpec(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.vmc.orgs.sddcs.clusters.esxs.storage_spec'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StorageSpecStub)
        self._VAPI_OPERATION_IDS = {}


    def get_storage_specs(self,
                          org,
                          sddc,
                          cluster,
                          esx,
                          ):
        """
        Get storage specs for a host.

        :type  org: :class:`str`
        :param org: Organization identifier (required)
        :type  sddc: :class:`str`
        :param sddc: Sddc identifier (required)
        :type  cluster: :class:`str`
        :param cluster: cluster identifier (required)
        :type  esx: :class:`str`
        :param esx: esx identifier (required)
        :rtype: :class:`list` of :class:`com.vmware.vmc.model_client.VsanDiskgroupMapping`
        :return: 
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
             Unauthorized
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Invalid or missing parameters
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        """
        return self._invoke('get_storage_specs',
                            {
                            'org': org,
                            'sddc': sddc,
                            'cluster': cluster,
                            'esx': esx,
                            })
class _StorageSpecStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get_storage_specs operation
        get_storage_specs_input_type = type.StructType('operation-input', {
            'org': type.StringType(),
            'sddc': type.StringType(),
            'cluster': type.StringType(),
            'esx': type.StringType(),
        })
        get_storage_specs_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        get_storage_specs_input_value_validator_list = [
        ]
        get_storage_specs_output_validator_list = [
        ]
        get_storage_specs_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vmc/api/orgs/{org}/sddcs/{sddc}/clusters/{cluster}/esxs/{esx}/storage-spec',
            path_variables={
                'org': 'org',
                'sddc': 'sddc',
                'cluster': 'cluster',
                'esx': 'esx',
            },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get_storage_specs': {
                'input_type': get_storage_specs_input_type,
                'output_type': type.ListType(type.ReferenceType('com.vmware.vmc.model_client', 'VsanDiskgroupMapping')),
                'errors': get_storage_specs_error_dict,
                'input_value_validator_list': get_storage_specs_input_value_validator_list,
                'output_validator_list': get_storage_specs_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get_storage_specs': get_storage_specs_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vmc.orgs.sddcs.clusters.esxs.storage_spec',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'StorageSpec': StorageSpec,
    }

