/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.BasicVector_ByteBuffer;
import org.armedbear.lisp.BasicVector_CharBuffer;
import org.armedbear.lisp.BasicVector_IntBuffer;
import org.armedbear.lisp.BasicVector_UnsignedByte16;
import org.armedbear.lisp.BasicVector_UnsignedByte32;
import org.armedbear.lisp.BasicVector_UnsignedByte8;
import org.armedbear.lisp.ComplexArray;
import org.armedbear.lisp.ComplexArray_ByteBuffer;
import org.armedbear.lisp.ComplexArray_IntBuffer;
import org.armedbear.lisp.ComplexArray_UnsignedByte32;
import org.armedbear.lisp.ComplexArray_UnsignedByte8;
import org.armedbear.lisp.ComplexBitVector;
import org.armedbear.lisp.ComplexString;
import org.armedbear.lisp.ComplexVector;
import org.armedbear.lisp.ComplexVector_ByteBuffer;
import org.armedbear.lisp.ComplexVector_IntBuffer;
import org.armedbear.lisp.ComplexVector_UnsignedByte32;
import org.armedbear.lisp.ComplexVector_UnsignedByte8;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Java;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.NilVector;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleArray_ByteBuffer;
import org.armedbear.lisp.SimpleArray_CharBuffer;
import org.armedbear.lisp.SimpleArray_IntBuffer;
import org.armedbear.lisp.SimpleArray_T;
import org.armedbear.lisp.SimpleArray_UnsignedByte16;
import org.armedbear.lisp.SimpleArray_UnsignedByte32;
import org.armedbear.lisp.SimpleArray_UnsignedByte8;
import org.armedbear.lisp.SimpleBitVector;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SimpleVector;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;
import org.armedbear.lisp.ZeroRankArray;

public final class make_array
extends Primitive {
    private static final Primitive _MAKE_ARRAY = new make_array();

    public make_array() {
        super("%make-array", Lisp.PACKAGE_SYS, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public LispObject execute(LispObject[] args) {
        AbstractArray array;
        if (args.length != 13) {
            return Lisp.error(new WrongNumberOfArgumentsException(this, 13));
        }
        LispObject dimensions = args[0];
        LispObject elementType = args[1];
        LispObject initialElement = args[2];
        LispObject initialElementProvided = args[3];
        LispObject initialContents = args[4];
        LispObject adjustable = args[5];
        LispObject fillPointer = args[6];
        LispObject displacedTo = args[7];
        LispObject displacedIndexOffset = args[8];
        LispObject direct = args[9];
        boolean directAllocation = !direct.equals(Lisp.NIL);
        LispObject nioBuffer = args[11];
        LispObject nioBufferProvided = args[12];
        if (initialElementProvided != Lisp.NIL && initialContents != Lisp.NIL) {
            return Lisp.error(new LispError("MAKE-ARRAY: cannot specify both initial element and initial contents."));
        }
        int rank = dimensions.listp() ? dimensions.length() : 1;
        int[] dimv = new int[rank];
        if (dimensions.listp()) {
            for (int i = 0; i < rank; ++i) {
                LispObject dim = dimensions.car();
                dimv[i] = Fixnum.getValue(dim);
                dimensions = dimensions.cdr();
            }
        } else {
            dimv[0] = Fixnum.getValue(dimensions);
        }
        if (displacedTo != Lisp.NIL) {
            void var19_31;
            AbstractArray array2 = Lisp.checkArray(displacedTo);
            if (initialElementProvided != Lisp.NIL) {
                return Lisp.error(new LispError("Initial element must not be specified for a displaced array."));
            }
            if (initialContents != Lisp.NIL) {
                return Lisp.error(new LispError("Initial contents must not be specified for a displaced array."));
            }
            int displacement = displacedIndexOffset != Lisp.NIL ? Fixnum.getValue(displacedIndexOffset) : 0;
            if (rank != 1) return new ComplexArray(dimv, array2, displacement);
            Object var19_23 = null;
            LispObject lispObject = array2.getElementType();
            if (lispObject == Symbol.CHARACTER) {
                ComplexString complexString = new ComplexString(dimv[0], array2, displacement);
            } else if (lispObject == Symbol.BIT) {
                ComplexBitVector complexBitVector = new ComplexBitVector(dimv[0], array2, displacement);
            } else if (lispObject.equal(Lisp.UNSIGNED_BYTE_8)) {
                if (Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) {
                    ComplexVector_ByteBuffer complexVector_ByteBuffer = new ComplexVector_ByteBuffer(dimv[0], array2, displacement, directAllocation);
                } else {
                    ComplexVector_UnsignedByte8 complexVector_UnsignedByte8 = new ComplexVector_UnsignedByte8(dimv[0], array2, displacement);
                }
            } else if (lispObject.equal(Lisp.UNSIGNED_BYTE_32)) {
                if (Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) {
                    ComplexVector_IntBuffer complexVector_IntBuffer = new ComplexVector_IntBuffer(dimv[0], array2, displacement, directAllocation);
                } else {
                    ComplexVector_UnsignedByte32 complexVector_UnsignedByte32 = new ComplexVector_UnsignedByte32(dimv[0], array2, displacement);
                }
            } else {
                ComplexVector complexVector = new ComplexVector(dimv[0], array2, displacement);
            }
            if (fillPointer == Lisp.NIL) return var19_31;
            var19_31.setFillPointer(fillPointer);
            return var19_31;
        }
        LispObject upgradedType = Lisp.getUpgradedArrayElementType(elementType);
        if (rank == 0) {
            LispObject data = initialElementProvided != Lisp.NIL ? initialElement : initialContents;
            return new ZeroRankArray(upgradedType, data, adjustable != Lisp.NIL);
        }
        if (rank == 1) {
            void var19_63;
            Object o;
            int size = dimv[0];
            if (size < 0 || size >= Integer.MAX_VALUE) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("The size specified for this array (");
                stringBuilder.append(size);
                stringBuilder.append(')');
                if (size >= Integer.MAX_VALUE) {
                    stringBuilder.append(" is >= ARRAY-DIMENSION-LIMIT (");
                    stringBuilder.append(Integer.MAX_VALUE);
                    stringBuilder.append(").");
                    return Lisp.error(new LispError(stringBuilder.toString()));
                } else {
                    stringBuilder.append(" is negative.");
                }
                return Lisp.error(new LispError(stringBuilder.toString()));
            }
            if (upgradedType == Symbol.CHARACTER) {
                if (fillPointer != Lisp.NIL || adjustable != Lisp.NIL) {
                    ComplexString complexString = new ComplexString(size);
                } else {
                    SimpleString simpleString = new SimpleString(size);
                }
                LispCharacter lispCharacter = LispCharacter.getInstance('\u0000');
            } else if (upgradedType == Symbol.BIT) {
                if (fillPointer != Lisp.NIL || adjustable != Lisp.NIL) {
                    ComplexBitVector complexBitVector = new ComplexBitVector(size);
                } else {
                    SimpleBitVector simpleBitVector = new SimpleBitVector(size);
                }
                Fixnum fixnum = Fixnum.ZERO;
            } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_8)) {
                if (fillPointer != Lisp.NIL || adjustable != Lisp.NIL) {
                    if (Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) {
                        ComplexVector_ByteBuffer complexVector_ByteBuffer = new ComplexVector_ByteBuffer(size, directAllocation);
                    } else {
                        ComplexVector_UnsignedByte8 complexVector_UnsignedByte8 = new ComplexVector_UnsignedByte8(size);
                    }
                } else if (Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) {
                    if (!nioBuffer.equals(Lisp.NIL)) {
                        BasicVector_ByteBuffer basicVector_ByteBuffer = new BasicVector_ByteBuffer((ByteBuffer)((JavaObject)nioBuffer).getObject(), directAllocation);
                    } else {
                        BasicVector_ByteBuffer basicVector_ByteBuffer = new BasicVector_ByteBuffer(size, directAllocation);
                    }
                } else {
                    BasicVector_UnsignedByte8 basicVector_UnsignedByte8 = new BasicVector_UnsignedByte8(size);
                }
                Fixnum fixnum = Fixnum.ZERO;
            } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_16) && fillPointer == Lisp.NIL && adjustable == Lisp.NIL) {
                if (Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) {
                    if (!nioBuffer.equals(Lisp.NIL)) {
                        o = ((JavaObject)nioBuffer).getObject();
                        if (o instanceof CharBuffer) {
                            BasicVector_CharBuffer basicVector_CharBuffer = new BasicVector_CharBuffer((CharBuffer)o, directAllocation);
                        } else {
                            if (!(o instanceof ByteBuffer)) return Lisp.type_error(nioBuffer, JavaObject.getInstance(CharBuffer.class));
                            BasicVector_CharBuffer basicVector_CharBuffer = new BasicVector_CharBuffer((ByteBuffer)o, directAllocation);
                        }
                    } else {
                        BasicVector_CharBuffer basicVector_CharBuffer = new BasicVector_CharBuffer(size, directAllocation);
                    }
                } else {
                    BasicVector_UnsignedByte16 basicVector_UnsignedByte16 = new BasicVector_UnsignedByte16(size);
                }
                Fixnum fixnum = Fixnum.ZERO;
            } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_32)) {
                if (fillPointer != Lisp.NIL || adjustable != Lisp.NIL) {
                    if (Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) {
                        ComplexVector_IntBuffer complexVector_IntBuffer = new ComplexVector_IntBuffer(size);
                    } else {
                        ComplexVector_UnsignedByte32 complexVector_UnsignedByte32 = new ComplexVector_UnsignedByte32(size);
                    }
                } else if (Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) {
                    if (!nioBuffer.equals(Lisp.NIL)) {
                        o = ((JavaObject)nioBuffer).getObject();
                        if (o instanceof IntBuffer) {
                            BasicVector_IntBuffer basicVector_IntBuffer = new BasicVector_IntBuffer((IntBuffer)o, directAllocation);
                        } else {
                            if (!(o instanceof ByteBuffer)) return Lisp.type_error(nioBuffer, JavaObject.getInstance(IntBuffer.class));
                            BasicVector_IntBuffer basicVector_IntBuffer = new BasicVector_IntBuffer((ByteBuffer)o, directAllocation);
                        }
                    } else {
                        BasicVector_IntBuffer basicVector_IntBuffer = new BasicVector_IntBuffer(size, directAllocation);
                    }
                } else {
                    BasicVector_UnsignedByte32 basicVector_UnsignedByte32 = new BasicVector_UnsignedByte32(size);
                }
                Fixnum fixnum = Fixnum.ZERO;
            } else if (upgradedType == Lisp.NIL) {
                NilVector nilVector = new NilVector(size);
                Object var20_70 = null;
            } else {
                if (fillPointer != Lisp.NIL || adjustable != Lisp.NIL) {
                    ComplexVector complexVector = new ComplexVector(size);
                } else {
                    SimpleVector simpleVector = new SimpleVector(size);
                }
                Symbol symbol = Lisp.NIL;
            }
            if (nioBuffer == Lisp.NIL) {
                void var20_72;
                if (initialElementProvided != Lisp.NIL) {
                    var19_63.fill(initialElement);
                } else if (initialContents != Lisp.NIL) {
                    if (initialContents.listp()) {
                        LispObject list = initialContents;
                        for (int i = 0; i < size; ++i) {
                            var19_63.aset(i, list.car());
                            list = list.cdr();
                        }
                    } else {
                        if (!initialContents.vectorp()) return Lisp.type_error(initialContents, Symbol.SEQUENCE);
                        for (int i = 0; i < size; ++i) {
                            var19_63.aset(i, initialContents.elt(i));
                        }
                    }
                } else if (var20_72 != null) {
                    var19_63.fill((LispObject)var20_72);
                }
            }
            if (fillPointer == Lisp.NIL) return var19_63;
            var19_63.setFillPointer(fillPointer);
            return var19_63;
        }
        if (adjustable == Lisp.NIL) {
            if (upgradedType.equal(Lisp.UNSIGNED_BYTE_8)) {
                if (initialContents != Lisp.NIL) {
                    if (!Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) return new SimpleArray_UnsignedByte8(dimv, initialContents);
                    return new SimpleArray_ByteBuffer(dimv, initialContents, directAllocation);
                }
                array = Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO) ? new SimpleArray_ByteBuffer(dimv, directAllocation) : new SimpleArray_UnsignedByte8(dimv);
                if (initialElementProvided != Lisp.NIL) {
                    array.fill(initialElement);
                    return array;
                } else {
                    array.fill(Fixnum.ZERO);
                }
                return array;
            } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_16)) {
                if (initialContents != Lisp.NIL) {
                    if (!Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) return new SimpleArray_UnsignedByte16(dimv, initialContents);
                    return new SimpleArray_CharBuffer(dimv, initialContents, directAllocation);
                }
                array = Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO) ? new SimpleArray_CharBuffer(dimv, directAllocation) : new SimpleArray_UnsignedByte16(dimv);
                if (initialElementProvided != Lisp.NIL) {
                    array.fill(initialElement);
                    return array;
                } else {
                    array.fill(Fixnum.ZERO);
                }
                return array;
            } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_32)) {
                if (initialContents != Lisp.NIL) {
                    if (!Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) return new SimpleArray_UnsignedByte32(dimv, initialContents);
                    return new SimpleArray_IntBuffer(dimv, initialContents, directAllocation);
                }
                array = Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO) ? new SimpleArray_IntBuffer(dimv, directAllocation) : new SimpleArray_UnsignedByte32(dimv);
                if (initialElementProvided != Lisp.NIL) {
                    array.fill(initialElement);
                    return array;
                } else {
                    array.fill(Fixnum.ZERO);
                }
                return array;
            } else {
                if (initialContents != Lisp.NIL) {
                    return new SimpleArray_T(dimv, upgradedType, initialContents);
                }
                array = new SimpleArray_T(dimv, upgradedType);
                if (initialElementProvided != Lisp.NIL) {
                    array.fill(initialElement);
                    return array;
                } else {
                    array.fill(Lisp.NIL);
                }
            }
            return array;
        } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_8)) {
            if (initialContents != Lisp.NIL) {
                if (!Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) return new ComplexArray_UnsignedByte8(dimv, initialContents);
                return new ComplexArray_ByteBuffer(dimv, initialContents);
            }
            array = Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO) ? new ComplexArray_ByteBuffer(dimv) : new ComplexArray_UnsignedByte8(dimv);
            if (initialElementProvided != Lisp.NIL) {
                array.fill(initialElement);
                return array;
            } else {
                array.fill(Fixnum.ZERO);
            }
            return array;
        } else if (upgradedType.equal(Lisp.UNSIGNED_BYTE_32)) {
            if (initialContents != Lisp.NIL) {
                if (!Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO)) return new ComplexArray_UnsignedByte32(dimv, initialContents);
                return new ComplexArray_IntBuffer(dimv, initialContents, directAllocation);
            }
            array = Java.Buffers.active.equals((Object)Java.Buffers.AllocationPolicy.NIO) ? new ComplexArray_IntBuffer(dimv, directAllocation) : new ComplexArray_UnsignedByte32(dimv);
            if (initialElementProvided != Lisp.NIL) {
                array.fill(initialElement);
                return array;
            } else {
                array.fill(Fixnum.ZERO);
            }
            return array;
        } else {
            if (initialContents != Lisp.NIL) {
                return new ComplexArray(dimv, upgradedType, initialContents);
            }
            array = new ComplexArray(dimv, upgradedType);
            if (initialElementProvided != Lisp.NIL) {
                array.fill(initialElement);
                return array;
            } else {
                array.fill(Lisp.NIL);
            }
        }
        return array;
    }
}

