/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.layout.LayoutEdge;
import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ContainerPane;
import ca.sqlpower.architect.swingui.DraggablePlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.PlayPenCoordinate;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.olap.DimensionPane;
import ca.sqlpower.architect.swingui.olap.DnDOLAPTransferable;
import ca.sqlpower.architect.swingui.olap.OLAPPaneUI;
import ca.sqlpower.architect.swingui.olap.PaneSection;
import ca.sqlpower.architect.swingui.olap.UsageComponent;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class OLAPPane<T extends OLAPObject, C extends OLAPObject>
extends ContainerPane<T, C> {
    private static final Logger logger = Logger.getLogger(OLAPPane.class);
    protected final List<PaneSection<? extends C>> sections = new ArrayList<PaneSection<? extends C>>();
    protected final Set<PaneSection<? extends C>> selectedSections = new HashSet<PaneSection<? extends C>>();
    private PlayPenCoordinate<T, C> insertionPoint;

    protected OLAPPane(OLAPPane<T, C> copyMe, PlayPenContentPane parent) {
        super(copyMe, parent);
        this.sections.addAll(copyMe.sections);
    }

    protected OLAPPane(String name) {
        super(name);
    }

    protected OLAPPane(String name, PlayPenContentPane parent) {
        super(name, parent);
    }

    @Transient
    @Accessor
    public List<PaneSection<? extends C>> getSections() {
        return this.sections;
    }

    @Override
    public String getModelName() {
        return OLAPUtil.nameFor((OLAPObject)((Object)this.model));
    }

    @Override
    @Deprecated
    public int pointToItemIndex(Point p) {
        return ((OLAPPaneUI)this.getUI()).pointToItemIndex(p);
    }

    public PlayPenCoordinate<T, C> pointToPPCoordinate(Point p) {
        return ((OLAPPaneUI)this.getUI()).pointToPPCoordinate(p);
    }

    @Override
    @Transient
    @Accessor
    public OLAPPaneUI<T, C> getUI() {
        return (OLAPPaneUI)super.getUI();
    }

    public abstract DataEntryPanel createEditDialog(PlayPenCoordinate<T, C> var1) throws SQLObjectException;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleMouseEvent(MouseEvent evt) {
        PlayPen pp = this.getPlayPen();
        Point p = evt.getPoint();
        pp.unzoomPoint(p);
        p.translate(-this.getX(), -this.getY());
        PlayPenCoordinate<T, C> clickedCoor = this.pointToPPCoordinate(p);
        int clickedIndex = clickedCoor.getIndex();
        if (evt.getID() == 500) {
            if (evt.getClickCount() != 2 || evt.getButton() != 1) return;
            try {
                void var7_14;
                DataEntryPanel panel = this.createEditDialog(clickedCoor);
                if (panel == null) return;
                if (clickedCoor.getIndex() == -3) {
                    if (!(clickedCoor.getSection() instanceof DimensionPane.HierarchySection)) throw new IllegalStateException("Unhandled section type: " + clickedCoor.getSection());
                    DimensionPane.HierarchySection section = (DimensionPane.HierarchySection)clickedCoor.getSection();
                    MondrianModel.Hierarchy hierarchy = section.getHierarchy();
                } else if (clickedCoor.getIndex() == -1) {
                    OLAPObject oLAPObject = (OLAPObject)((Object)this.model);
                } else {
                    C c = clickedCoor.getItem();
                }
                Window owner = SwingUtilities.getWindowAncestor(this.getPlayPen());
                JDialog dialog = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)panel, (Component)owner, (String)(var7_14.getClass().getSimpleName() + " Properties"), (String)"OK");
                dialog.setLocationRelativeTo(owner);
                dialog.setVisible(true);
                return;
            }
            catch (Exception e) {
                logger.debug((Object)("Error from creating edit dialog at coordinate: " + clickedCoor), (Throwable)e);
                ASUtils.showExceptionDialogNoReport(SwingUtilities.getWindowAncestor(this.getPlayPen()), "Failed to create edit dialog!", e);
            }
            return;
        } else if (evt.getID() == 501) {
            this.componentPreviouslySelected = false;
            if (pp.getMouseMode() != PlayPen.MouseModeType.CREATING_TABLE) {
                if ((evt.getModifiersEx() & 0xC0) == 0) {
                    if (!this.isSelected() || pp.getMouseMode() == PlayPen.MouseModeType.IDLE) {
                        pp.setMouseMode(PlayPen.MouseModeType.SELECT_TABLE);
                        pp.selectNone();
                    }
                } else {
                    pp.setMouseMode(PlayPen.MouseModeType.MULTI_SELECT);
                }
                if ((evt.getModifiersEx() & 0x200) != 0) {
                    clickedIndex = -1;
                }
                if (clickedIndex == -3) {
                    if ((evt.getModifiersEx() & 0xC0) == 0) {
                        if (!this.isSectionSelected(clickedCoor.getSection())) {
                            this.deSelectEverythingElse(evt);
                            this.selectNone();
                        }
                        pp.setMouseMode(PlayPen.MouseModeType.SELECT_ITEM);
                    }
                    if (this.isSectionSelected(clickedCoor.getSection())) {
                        this.componentPreviouslySelected = true;
                    } else {
                        this.selectSection(clickedCoor.getSection());
                    }
                    this.fireSelectionEvent(new SelectionEvent(this, 1, 4));
                    this.repaint();
                } else if (clickedIndex > -1) {
                    if ((evt.getModifiersEx() & 0xC0) == 0) {
                        if (!this.isItemSelected(clickedCoor.getItem())) {
                            this.deSelectEverythingElse(evt);
                            this.selectNone();
                        }
                        pp.setMouseMode(PlayPen.MouseModeType.SELECT_ITEM);
                    }
                    if (this.isItemSelected(clickedCoor.getItem())) {
                        this.componentPreviouslySelected = true;
                    } else {
                        this.selectItem(clickedCoor.getItem());
                    }
                    this.fireSelectionEvent(new SelectionEvent(this, 1, 4));
                    this.repaint();
                }
                if (this.isSelected() && clickedIndex == -1) {
                    this.componentPreviouslySelected = true;
                } else {
                    this.setSelected(true, 4);
                }
            }
            if (clickedIndex != -1 || pp.getSession().getArchitectFrame().createRelationshipIsActive()) return;
            Iterator<ContainerPane<?, ?>> it = pp.getSelectedContainers().iterator();
            logger.debug((Object)("event point: " + p));
            logger.debug((Object)("zoomed event point: " + pp.zoomPoint(new Point(p))));
            pp.setDraggingContainerPanes(true);
            this.startedDragging();
            HashMap<DraggablePlayPenComponent, Point> hashMap = new HashMap<DraggablePlayPenComponent, Point>();
            while (it.hasNext()) {
                ContainerPane<?, ?> cp = it.next();
                logger.debug((Object)("(" + cp.getModel() + ") zoomed selected containerPane's point: " + cp.getLocationOnScreen()));
                logger.debug((Object)("(" + cp.getModel() + ") unzoomed selected containerPane's point: " + pp.unzoomPoint(cp.getLocationOnScreen())));
                Point clickedItem = this.getLocationOnScreen();
                Point otherContainer = cp.getLocationOnScreen();
                logger.debug((Object)("(" + cp.getModel() + ") translation x=" + (otherContainer.getX() - clickedItem.getX()) + ",y=" + (otherContainer.getY() - clickedItem.getY())));
                Point handle = pp.zoomPoint(new Point(p));
                handle.translate((int)(clickedItem.getX() - otherContainer.getX()), (int)(clickedItem.getY() - otherContainer.getY()));
                hashMap.put(cp, handle);
            }
            new PlayPen.FloatingContainerPaneListener(pp, hashMap);
            return;
        } else {
            if (evt.getID() != 503 && evt.getID() != 506) return;
            logger.debug((Object)("Mouse moved/dragged to " + evt.getPoint()));
            this.setSelected(pp.getRubberBand().intersects(this.getBounds(new Rectangle())), 4);
        }
    }

    public void deselectSection(PaneSection<? extends C> sect) {
        this.selectedSections.remove(sect);
        this.fireItemsDeselected(Collections.singleton(null));
        this.repaint();
    }

    public void selectSection(PaneSection<? extends C> sect) {
        this.selectedSections.add(sect);
        this.fireItemsSelected(Collections.singleton(null));
        this.repaint();
    }

    @NonBound
    public boolean isSectionSelected(PaneSection<? extends C> sect) {
        return this.selectedSections.contains(sect);
    }

    @NonBound
    public List<PaneSection<? extends C>> getSelectedSections() {
        ArrayList<PaneSection<C>> selectedSects = new ArrayList<PaneSection<C>>();
        for (PaneSection<C> sect : this.getSections()) {
            if (!this.isSectionSelected(sect)) continue;
            selectedSects.add(sect);
        }
        return selectedSects;
    }

    @NonBound
    public List<PlayPenCoordinate<T, C>> getSelectedCoordinates() {
        ArrayList<PlayPenCoordinate<T, C>> selection = new ArrayList<PlayPenCoordinate<T, C>>();
        for (PaneSection<C> sect : this.getSections()) {
            if (this.isSectionSelected(sect)) {
                selection.add(new PlayPenCoordinate(this, sect, -3, null));
                continue;
            }
            int i = 0;
            for (OLAPObject item : sect.getItems()) {
                if (this.isItemSelected(item)) {
                    selection.add(new PlayPenCoordinate(this, sect, i, item));
                }
                ++i;
            }
        }
        return selection;
    }

    @Override
    public void selectNone() {
        HashSet previouslySelectedItems = new HashSet(this.selectedItems);
        this.selectedItems.clear();
        this.fireItemsDeselected(previouslySelectedItems);
        this.selectedSections.clear();
        this.repaint();
    }

    @Override
    @NonBound
    public JPopupMenu getPopup(Point p) {
        PlayPenCoordinate pointToPPCoordinate = ((OLAPPaneUI)this.getUI()).pointToPPCoordinate(p);
        List<OLAPObject> itemsFromPoint = this.getItemsFromCoordinates(Collections.singletonList(pointToPPCoordinate));
        if (!itemsFromPoint.isEmpty()) {
            return this.getPlayPen().getPopupFactory().createPopupMenu((Object)itemsFromPoint.get(0));
        }
        return this.getPlayPen().getPopupFactory().createPopupMenu(this.getModel());
    }

    @Override
    public Transferable createTransferableForSelection() {
        ArrayList<PlayPenCoordinate<? extends OLAPObject, ? extends OLAPObject>> annoying = new ArrayList<PlayPenCoordinate<? extends OLAPObject, ? extends OLAPObject>>();
        for (PlayPenCoordinate<T, C> ridiculous : this.getSelectedCoordinates()) {
            annoying.add(ridiculous);
        }
        return new DnDOLAPTransferable(this.getPlayPen(), annoying);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DragEnter event on " + this.getName()));
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DragExit event on " + this.getName()));
        }
        this.setInsertionPoint(null);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DragOver event on " + this.getName() + ": " + dtde));
            logger.debug((Object)("Drop Action = " + dtde.getDropAction()));
            logger.debug((Object)("Source Actions = " + dtde.getSourceActions()));
        }
        dtde.acceptDrag(3 & dtde.getDropAction());
        Point loc = this.getPlayPen().unzoomPoint(new Point(dtde.getLocation()));
        loc.x -= this.getX();
        loc.y -= this.getY();
        this.setInsertionPoint(this.pointToPPCoordinate(loc));
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        logger.debug((Object)("Drop target drop event on " + this.getName() + ": " + dtde));
        MondrianModel.Schema schema = OLAPUtil.getSession((OLAPObject)((Object)this.getModel())).getSchema();
        try {
            schema.begin("Drag and Drop");
            Transferable t = dtde.getTransferable();
            DataFlavor importFlavor = this.bestImportFlavor(null, t.getTransferDataFlavors());
            logger.debug((Object)("Import flavor: " + importFlavor));
            if (importFlavor == null) {
                dtde.rejectDrop();
                return;
            }
            List paths = (List)t.getTransferData(importFlavor);
            logger.debug((Object)("Paths = " + paths));
            List<PlayPenCoordinate<? extends OLAPObject, ? extends OLAPObject>> coords = DnDOLAPTransferable.resolve(this.getPlayPen(), paths);
            logger.debug((Object)("Resolved Paths = " + coords));
            List<OLAPObject> items = this.getItemsFromCoordinates(coords);
            List<C> acceptedItems = this.filterDroppableItems(items);
            logger.debug((Object)("Accepted Items = " + acceptedItems));
            PaneSection<Object> insertSection = this.getInsertionPoint().getSection();
            int insertIndex = this.getInsertionPoint().getIndex();
            if (insertSection == null && !this.sections.isEmpty()) {
                insertSection = this.sections.get(0);
                insertIndex = insertSection.getItems().size();
            }
            for (OLAPObject item : acceptedItems) {
                logger.debug((Object)("Trying to add " + (Object)((Object)item)));
                if (item.getParent() != null) {
                    int removedItemIndex = 0;
                    if (insertSection != null) {
                        removedItemIndex = insertSection.getItems().indexOf((Object)item);
                    }
                    logger.debug((Object)("Removed item index in target section: " + removedItemIndex));
                    if (insertSection != null && removedItemIndex >= 0 && insertSection.getItemType().isInstance((Object)item) && insertIndex > removedItemIndex) {
                        --insertIndex;
                    }
                }
                insertIndex = this.dndRemoveAndAdd(insertSection, insertIndex, item);
                logger.debug((Object)("Moved object: " + (Object)((Object)item)));
            }
            if (!acceptedItems.isEmpty()) {
                this.getPlayPen().selectNone();
                this.setSelected(true, 4);
                for (OLAPObject item : acceptedItems) {
                    this.selectItem(item);
                }
            }
            dtde.acceptDrop(2);
            dtde.dropComplete(!acceptedItems.isEmpty());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.setInsertionPoint(null);
            schema.commit();
        }
    }

    protected int dndRemoveAndAdd(PaneSection<OLAPObject> insertSection, int insertIndex, C item) {
        if (insertSection != null && insertIndex >= 0 && insertSection.getItemType().isInstance(item)) {
            try {
                item.getParent().removeChild(item);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            insertSection.addItem(insertIndex++, (OLAPObject)((Object)item));
        } else {
            this.transferInvalidIndexItem((OLAPObject)((Object)item), insertSection);
        }
        return insertIndex;
    }

    @NonBound
    protected List<OLAPObject> getItemsFromCoordinates(List<PlayPenCoordinate<? extends OLAPObject, ? extends OLAPObject>> coords) {
        ArrayList<OLAPObject> items = new ArrayList<OLAPObject>();
        for (PlayPenCoordinate<? extends OLAPObject, ? extends OLAPObject> coord : coords) {
            if (coord.getIndex() == -3) {
                for (OLAPObject oLAPObject : coord.getSection().getItems()) {
                    items.add(oLAPObject);
                }
                continue;
            }
            if (coord.getIndex() < 0) continue;
            if (coord.getItem() == null) {
                throw new NullPointerException("Found a coordinate with nonnegative item index but null item: " + coord);
            }
            items.add(coord.getItem());
        }
        return items;
    }

    protected void transferInvalidIndexItem(OLAPObject item, PaneSection<OLAPObject> insertSection) {
        try {
            item.getParent().removeChild((SPObject)item);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ((OLAPObject)((Object)this.getModel())).addChild((SPObject)item, ((OLAPObject)((Object)this.getModel())).getChildren().size());
    }

    protected abstract List<C> filterDroppableItems(List<OLAPObject> var1);

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public DataFlavor bestImportFlavor(JComponent c, DataFlavor[] flavors) {
        for (DataFlavor f : flavors) {
            if (f != DnDOLAPTransferable.PP_COORDINATE_FLAVOR) continue;
            return f;
        }
        return null;
    }

    @Transient
    @Mutator
    public void setInsertionPoint(PlayPenCoordinate<T, C> newIP) {
        PlayPenCoordinate<T, C> oldIP = this.insertionPoint;
        this.insertionPoint = newIP;
        this.firePropertyChange("insertionPoint", oldIP, newIP);
    }

    @Transient
    @Accessor
    public PlayPenCoordinate<T, C> getInsertionPoint() {
        return this.insertionPoint;
    }

    @Override
    @NonBound
    public final List<LayoutEdge> getInboundEdges() {
        ArrayList<LayoutEdge> edges = new ArrayList<LayoutEdge>();
        for (PlayPenComponent playPenComponent : this.getPlayPen().getContentPane().getChildren()) {
            UsageComponent uc;
            if (!(playPenComponent instanceof UsageComponent) || (uc = (UsageComponent)playPenComponent).getPane2() != this) continue;
            edges.add(uc);
        }
        return edges;
    }

    @Override
    @NonBound
    public final List<LayoutEdge> getOutboundEdges() {
        ArrayList<LayoutEdge> edges = new ArrayList<LayoutEdge>();
        for (PlayPenComponent playPenComponent : this.getPlayPen().getContentPane().getChildren()) {
            UsageComponent uc;
            if (!(playPenComponent instanceof UsageComponent) || (uc = (UsageComponent)playPenComponent).getPane1() != this) continue;
            edges.add(uc);
        }
        return edges;
    }
}

