/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class Hints {
    public static final String PIN_HINT_ASSET_ZIP_ENTRY_NAME = "assets/com.android.hints.pins.txt";
    public static final String PIN_BYTE_RANGE_ZIP_ENTRY_NAME = "pinlist.meta";

    private static int clampToInt(long value) {
        return (int)Math.max(0L, Math.min(value, Integer.MAX_VALUE));
    }

    public static byte[] encodeByteRangeList(List<ByteRange> pinByteRanges) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(pinByteRanges.size() * 8);
        DataOutputStream out = new DataOutputStream(bos);
        try {
            for (ByteRange pinByteRange : pinByteRanges) {
                out.writeInt(Hints.clampToInt(pinByteRange.start));
                out.writeInt(Hints.clampToInt(pinByteRange.end - pinByteRange.start));
            }
        }
        catch (IOException ex) {
            throw new AssertionError("impossible", ex);
        }
        return bos.toByteArray();
    }

    public static ArrayList<Pattern> parsePinPatterns(byte[] patternBlob) {
        ArrayList<Pattern> pinPatterns = new ArrayList<Pattern>();
        try {
            for (String rawLine : new String(patternBlob, "UTF-8").split("\n")) {
                String line = rawLine.replaceFirst("#.*", "");
                if ("".equals(line)) continue;
                pinPatterns.add(Pattern.compile(line));
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 must be supported", ex);
        }
        return pinPatterns;
    }

    public static final class ByteRange {
        final long start;
        final long end;

        public ByteRange(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }
}

