// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFGraph_Articulations_HeaderFile
#define _IFGraph_Articulations_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Interface_Graph.hxx>
#include <Standard_Integer.hxx>
#include <Handle_TColStd_HSequenceOfInteger.hxx>
#include <Interface_GraphContent.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_Standard_Transient.hxx>
class TColStd_HSequenceOfInteger;
class Interface_Graph;
class Standard_Transient;
class Interface_EntityIterator;


//! this class gives entities which are Articulation points
//! in a whole Model or in a sub-part
//! An Articulation Point divides the graph in two (or more)
//! disconnected sub-graphs
//! Identifying Articulation Points allows improving
//! efficiency of spliting a set of Entities into sub-sets
class IFGraph_Articulations  : public Interface_GraphContent
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! creates Articulations to evaluate a Graph
  //! whole True : works on the whole Model
  //! whole False : remains empty, ready to work on a sub-part
  Standard_EXPORT IFGraph_Articulations(const Interface_Graph& agraph, const Standard_Boolean whole);
  
  //! adds an entity and its shared ones to the list
  Standard_EXPORT   void GetFromEntity (const Handle(Standard_Transient)& ent) ;
  
  //! adds a list of entities (as an iterator)
  Standard_EXPORT   void GetFromIter (const Interface_EntityIterator& iter) ;
  
  //! Allows to restart on a new data set
  Standard_EXPORT   void ResetData() ;
  
  //! Evaluates the list of Articulation points
  Standard_EXPORT virtual   void Evaluate() ;




protected:





private:

  
  //! basic routine of computation
  //! (see book Sedgewick "Algorithms", p 392)
  Standard_EXPORT   Standard_Integer Visit (const Standard_Integer num) ;


  Interface_Graph thegraph;
  Standard_Integer thenow;
  Handle(TColStd_HSequenceOfInteger) thelist;


};







#endif // _IFGraph_Articulations_HeaderFile
