/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects;
import com.carrotsearch.ant.tasks.junit4.events.AbstractEvent;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonReader;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonToken;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Locale;
import org.junit.runner.Description;

public final class JsonHelpers {
    public static void writeDescription(JsonWriter jsonWriter, Description description) {
        String string = JsonHelpers.createId(description);
        if (jsonWriter.inContext(string)) {
            jsonWriter.value(string);
        } else {
            jsonWriter.registerInContext(string, description);
            jsonWriter.beginObject();
            jsonWriter.name("id").value(string);
            jsonWriter.name("displayName").value(description.getDisplayName());
            jsonWriter.name("methodName").value(description.getMethodName());
            jsonWriter.name("className").value(description.getClassName());
            jsonWriter.name("children").beginArray();
            for (Description description2 : description.getChildren()) {
                JsonHelpers.writeDescription(jsonWriter, description2);
            }
            jsonWriter.endArray();
            jsonWriter.endObject();
        }
    }

    protected static Description readDescription(JsonReader jsonReader) {
        Description description;
        if (jsonReader.peek() == JsonToken.STRING) {
            String string = jsonReader.nextString();
            description = (Description)jsonReader.lookupInContext(string);
            if (description == null) {
                throw new IOException("Missing reference to: " + string);
            }
        } else {
            jsonReader.beginObject();
            String string = AbstractEvent.readStringOrNullProperty(jsonReader, "id");
            String string2 = AbstractEvent.readStringOrNullProperty(jsonReader, "displayName");
            String string3 = AbstractEvent.readStringOrNullProperty(jsonReader, "methodName");
            String string4 = AbstractEvent.readStringOrNullProperty(jsonReader, "className");
            ArrayList<Description> arrayList = new ArrayList<Description>();
            AbstractEvent.expectProperty(jsonReader, "children").beginArray();
            while (jsonReader.peek() != JsonToken.END_ARRAY) {
                arrayList.add(JsonHelpers.readDescription(jsonReader));
            }
            jsonReader.endArray();
            description = Description.createSuiteDescription((String)string2, (Annotation[])new Annotation[0]);
            for (Description description2 : arrayList) {
                description.addChild(description2);
            }
            if (!Objects.equal(description.getMethodName(), string3)) {
                throw new IOException(String.format(Locale.ROOT, "Insane, methodName does not match: %s, %s", description.getMethodName(), string3));
            }
            if (!Objects.equal(description.getClassName(), string4)) {
                throw new IOException(String.format(Locale.ROOT, "Insane, className does not match: %s, %s", description.getClassName(), string4));
            }
            jsonReader.registerInContext(string, description);
            jsonReader.endObject();
        }
        return description;
    }

    private static String createId(Description description) {
        return "ID#" + description.getDisplayName();
    }
}

