/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;
import org.apache.velocity.util.introspection.ClassFieldMap;
import org.apache.velocity.util.introspection.ClassMap;
import org.apache.velocity.util.introspection.ConversionHandler;
import org.apache.velocity.util.introspection.IntrospectorCache;
import org.apache.velocity.util.introspection.MethodMap;
import org.slf4j.Logger;

public abstract class IntrospectorBase {
    protected final Logger log;
    private final IntrospectorCache introspectorCache;
    private final ConversionHandler conversionHandler;

    protected IntrospectorBase(Logger logger, ConversionHandler conversionHandler) {
        this.log = logger;
        this.introspectorCache = new IntrospectorCache(logger, conversionHandler);
        this.conversionHandler = conversionHandler;
    }

    public Method getMethod(Class clazz, String string, Object[] objectArray) throws MethodMap.AmbiguousException {
        IntrospectorCache introspectorCache = this.getIntrospectorCache();
        ClassMap classMap = introspectorCache.get((Class)Validate.notNull((Object)clazz, (String)"class object is null!", (Object[])new Object[0]));
        if (classMap == null) {
            classMap = introspectorCache.put(clazz);
        }
        return classMap.findMethod(string, (Object[])Validate.notNull((Object)objectArray, (String)"params object is null!", (Object[])new Object[0]));
    }

    public Field getField(Class clazz, String string) throws IllegalArgumentException {
        IntrospectorCache introspectorCache = this.getIntrospectorCache();
        ClassFieldMap classFieldMap = introspectorCache.getFieldMap((Class)Validate.notNull((Object)clazz, (String)"class object is null!", (Object[])new Object[0]));
        if (classFieldMap == null) {
            introspectorCache.put(clazz);
            classFieldMap = introspectorCache.getFieldMap(clazz);
        }
        return classFieldMap.findField(string);
    }

    protected IntrospectorCache getIntrospectorCache() {
        return this.introspectorCache;
    }
}

