/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.langdetect.LanguageDetectorModel;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.OpenNLPLangDetectUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.SolrCoreAware;

public class OpenNLPLangDetectUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware {
    private static final String MODEL_PARAM = "langid.model";
    private String modelFile;
    private LanguageDetectorModel model;
    protected SolrParams defaults;
    protected SolrParams appends;
    protected SolrParams invariants;
    private SolrResourceLoader solrResourceLoader;

    public void init(NamedList args) {
        if (args != null) {
            Object o = args.get("defaults");
            this.defaults = o != null && o instanceof NamedList ? ((NamedList)o).toSolrParams() : args.toSolrParams();
            o = args.get("appends");
            if (o != null && o instanceof NamedList) {
                this.appends = ((NamedList)o).toSolrParams();
            }
            if ((o = args.get("invariants")) != null && o instanceof NamedList) {
                this.invariants = ((NamedList)o).toSolrParams();
            }
            if (this.invariants != null) {
                this.modelFile = this.invariants.get(MODEL_PARAM);
            }
            if (this.modelFile == null) {
                o = args.get(MODEL_PARAM);
                if (o != null && o instanceof String) {
                    this.modelFile = (String)o;
                } else {
                    this.modelFile = this.defaults.get(MODEL_PARAM);
                    if (this.modelFile == null) {
                        throw new RuntimeException("Couldn't load language model, will return empty languages always!");
                    }
                }
            }
        }
    }

    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        if (req != null) {
            SolrPluginUtils.setDefaults((SolrQueryRequest)req, (SolrParams)this.defaults, (SolrParams)this.appends, (SolrParams)this.invariants);
        }
        return new OpenNLPLangDetectUpdateProcessor(req, rsp, next, this.model);
    }

    private void loadModel() throws IOException {
        InputStream is = null;
        try {
            if (this.modelFile != null) {
                is = this.solrResourceLoader.openResource(this.modelFile);
                this.model = new LanguageDetectorModel(is);
            }
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public void inform(SolrCore core) {
        this.solrResourceLoader = core.getResourceLoader();
        try {
            this.loadModel();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

