/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplyBufferedMessagesAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public ApplyBufferedMessagesAction() {
    }

    public ApplyBufferedMessagesAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext ctx = state.getTlsContext(this.connectionAlias);
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        LinkedList<ProtocolMessage> messages = ctx.getMessageBuffer();
        if (messages.isEmpty()) {
            LOGGER.debug("Empty buffer, no messages to apply");
        } else {
            for (ProtocolMessage msg : messages) {
                LOGGER.debug("Applying buffered " + msg.toCompactString() + " to context " + ctx);
                ProtocolMessageHandler h = msg.getHandler(ctx);
                h.adjustTLSContext(msg);
            }
        }
        this.setExecuted(true);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }
}

