/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.ByteArrayAdapter;
import java.util.Arrays;
import java.util.Random;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlType(propOrder={"explicitValue", "modificationFilter", "postModification"})
public class ByteArrayExplicitValueModification
extends VariableModification<byte[]> {
    private static final int MAX_EXPLICIT_VALUE = 256;
    private byte[] explicitValue;

    public ByteArrayExplicitValueModification() {
    }

    public ByteArrayExplicitValueModification(byte[] explicitValue) {
        this.explicitValue = explicitValue;
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        return (byte[])this.explicitValue.clone();
    }

    @XmlJavaTypeAdapter(value=ByteArrayAdapter.class)
    public byte[] getExplicitValue() {
        return this.explicitValue;
    }

    public void setExplicitValue(byte[] explicitValue) {
        this.explicitValue = explicitValue;
    }

    public String toString() {
        return "ByteArrayExplicitValueModification{explicitValue=" + ArrayConverter.bytesToHexString(this.explicitValue) + '}';
    }

    @Override
    public VariableModification<byte[]> getModifiedCopy() {
        Random r = new Random();
        if (this.explicitValue.length == 0) {
            return this;
        }
        int index = r.nextInt(this.explicitValue.length);
        byte[] newValue = Arrays.copyOf(this.explicitValue, this.explicitValue.length);
        newValue[index] = (byte)r.nextInt(256);
        return new ByteArrayExplicitValueModification(newValue);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Arrays.hashCode(this.explicitValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayExplicitValueModification other = (ByteArrayExplicitValueModification)obj;
        return Arrays.equals(this.explicitValue, other.explicitValue);
    }
}

