/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame2.driver.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryImplConfigBase;
import virtuoso.sesame2.driver.config.VirtuosoRepositorySchema;

public class VirtuosoRepositoryConfig
extends RepositoryImplConfigBase {
    private String hostlist;
    private String username;
    private String password;
    private String defGraph;
    private boolean useLazyAdd;
    private int fetchSize = 200;
    private boolean roundRobin;
    private String ruleSet;

    public VirtuosoRepositoryConfig() {
        super("openrdf:VirtuosoRepository");
    }

    public VirtuosoRepositoryConfig(String string) {
        this();
        this.setHostList(string);
    }

    public String getHostList() {
        return this.hostlist;
    }

    public void setHostList(String string) {
        this.hostlist = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getDefGraph() {
        return this.defGraph;
    }

    public void setDefGraph(String string) {
        this.defGraph = string;
    }

    public boolean getUseLazyAdd() {
        return this.useLazyAdd;
    }

    public void setUseLazyAdd(boolean bl) {
        this.useLazyAdd = bl;
    }

    public boolean getRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(boolean bl) {
        this.roundRobin = bl;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public String getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(String string) {
        this.ruleSet = string != null && string.equals("null") ? null : string;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.hostlist == null) {
            throw new RepositoryConfigException("No HostList specified for Virtuoso repository");
        }
    }

    public Resource export(Graph graph) {
        Resource resource = super.export(graph);
        if (this.hostlist != null) {
            graph.add(resource, VirtuosoRepositorySchema.HOSTLIST, (Value)graph.getValueFactory().createLiteral(this.hostlist), new Resource[0]);
        }
        if (this.username != null) {
            graph.add(resource, VirtuosoRepositorySchema.USERNAME, (Value)graph.getValueFactory().createLiteral(this.username), new Resource[0]);
        }
        if (this.password != null) {
            graph.add(resource, VirtuosoRepositorySchema.PASSWORD, (Value)graph.getValueFactory().createLiteral(this.password), new Resource[0]);
        }
        if (this.defGraph != null) {
            graph.add(resource, VirtuosoRepositorySchema.DEFGRAPH, (Value)graph.getValueFactory().createLiteral(this.defGraph), new Resource[0]);
        }
        if (this.ruleSet != null && this.ruleSet.length() > 0 && !this.ruleSet.equals("null")) {
            graph.add(resource, VirtuosoRepositorySchema.RULESET, (Value)graph.getValueFactory().createLiteral(this.ruleSet), new Resource[0]);
        }
        graph.add(resource, VirtuosoRepositorySchema.USELAZYADD, (Value)graph.getValueFactory().createLiteral(new Boolean(this.useLazyAdd).toString()), new Resource[0]);
        graph.add(resource, VirtuosoRepositorySchema.ROUNDROBIN, (Value)graph.getValueFactory().createLiteral(new Boolean(this.roundRobin).toString()), new Resource[0]);
        graph.add(resource, VirtuosoRepositorySchema.FETCHSIZE, (Value)graph.getValueFactory().createLiteral(Integer.toString(this.fetchSize, 10)), new Resource[0]);
        return resource;
    }

    public void parse(Graph graph, Resource resource) throws RepositoryConfigException {
        super.parse(graph, resource);
        try {
            Literal literal;
            Literal literal2;
            Literal literal3;
            Literal literal4;
            Literal literal5;
            Literal literal6;
            Literal literal7;
            Literal literal8 = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)resource, (URI)VirtuosoRepositorySchema.HOSTLIST);
            if (literal8 != null) {
                this.setHostList(literal8.getLabel());
            }
            if ((literal7 = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)resource, (URI)VirtuosoRepositorySchema.USERNAME)) != null) {
                this.setUsername(literal7.getLabel());
            }
            if ((literal6 = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)resource, (URI)VirtuosoRepositorySchema.PASSWORD)) != null) {
                this.setPassword(literal6.getLabel());
            }
            if ((literal5 = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)resource, (URI)VirtuosoRepositorySchema.DEFGRAPH)) != null) {
                this.setDefGraph(literal5.getLabel());
            }
            if ((literal4 = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)resource, (URI)VirtuosoRepositorySchema.USELAZYADD)) != null) {
                this.setUseLazyAdd(Boolean.getBoolean(literal4.getLabel()));
            }
            if ((literal3 = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)resource, (URI)VirtuosoRepositorySchema.ROUNDROBIN)) != null) {
                this.setRoundRobin(Boolean.getBoolean(literal3.getLabel()));
            }
            if ((literal2 = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)resource, (URI)VirtuosoRepositorySchema.FETCHSIZE)) != null) {
                this.setFetchSize(Integer.parseInt(literal2.getLabel()));
            }
            if ((literal = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)resource, (URI)VirtuosoRepositorySchema.RULESET)) != null) {
                this.setRuleSet(literal.getLabel());
            }
        }
        catch (GraphUtilException graphUtilException) {
            throw new RepositoryConfigException(graphUtilException.getMessage(), (Throwable)graphUtilException);
        }
    }
}

