/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zaproxy.zap.utils.XmlUtils;

@Deprecated
public abstract class FileXML {
    private static final Logger logger = Logger.getLogger(FileXML.class);
    protected Document doc = null;
    protected DocumentBuilder docBuilder = null;
    protected DocumentBuilderFactory docBuilderFactory = null;

    public FileXML(String rootElementName) {
        String rootString = "<" + rootElementName + "></" + rootElementName + ">";
        try {
            this.docBuilderFactory = XmlUtils.newXxeDisabledDocumentBuilderFactory();
            this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
            this.doc = this.docBuilder.parse(new InputSource(new StringReader(rootString)));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    protected Element getElement(Element base, String childTag) {
        Element[] elements = this.getElements(base, childTag);
        if (elements == null) {
            return null;
        }
        return elements[0];
    }

    protected Element getElement(String tag) {
        Element parent = this.doc.getDocumentElement();
        return this.getElement(parent, tag);
    }

    protected Element getElement(String[] path) {
        Element[] elements = this.getElements(path);
        if (elements == null) {
            return null;
        }
        return elements[0];
    }

    protected Element[] getElements(Element base, String childTag) {
        NodeList nodeList = base.getElementsByTagName(childTag);
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element[] elements = new Element[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elements[i] = (Element)nodeList.item(i);
        }
        return elements;
    }

    protected Element[] getElements(String tagName) {
        Element parent = this.doc.getDocumentElement();
        return this.getElements(parent, tagName);
    }

    protected Element[] getElements(String[] path) {
        NodeList nodeList = null;
        Element element = this.doc.getDocumentElement();
        for (int i = 0; i < path.length - 1; ++i) {
            nodeList = element.getElementsByTagName(path[i]);
            if (nodeList.getLength() <= 0) {
                return null;
            }
            element = (Element)nodeList.item(i);
        }
        nodeList = element.getElementsByTagName(path[path.length - 1]);
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element[] elements = new Element[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elements[i] = (Element)nodeList.item(0);
        }
        return elements;
    }

    private String getText(Element element) {
        try {
            for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
                Node node = element.getChildNodes().item(i);
                if (node.getNodeType() != 3) continue;
                return node.getNodeValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    protected String getValue(Element base, String tag) {
        Element element = null;
        String result = "";
        try {
            element = this.getElement(base, tag);
            result = this.getText(element);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected String getValue(String tag) {
        Element element = this.doc.getDocumentElement();
        return this.getValue(element, tag);
    }

    protected List<String> getValues(String tag) {
        NodeList nodeList = this.doc.getElementsByTagName(tag);
        int length = nodeList.getLength();
        ArrayList<String> resultList = new ArrayList<String>(length);
        Element element = null;
        for (int i = 0; i < length; ++i) {
            element = (Element)nodeList.item(i);
            resultList.add(this.getText(element));
        }
        return resultList;
    }

    protected abstract void parse() throws Exception;

    public void readAndParseFile(String fileName) throws SAXException, IOException, Exception {
        this.readFile(fileName);
        this.parse();
    }

    protected void readFile(String fileName) throws SAXException, IOException {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        try {
            factory = XmlUtils.newXxeDisabledDocumentBuilderFactory();
            factory.setValidating(false);
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        this.doc = builder.parse(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(String fileName) {
        File file = null;
        FileOutputStream outFile = null;
        try {
            file = new File(fileName);
            outFile = new FileOutputStream(file);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(this.doc);
            StreamResult result = new StreamResult(outFile);
            transformer.transform(source, result);
        }
        catch (IOException | TransformerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void setDocument(Document doc) throws Exception {
        this.doc = doc;
        this.parse();
    }

    protected void setValue(String tagName, String value) {
        Element element = null;
        try {
            element = this.getElement(tagName);
            if (element == null) {
                element = this.doc.createElement(tagName);
                this.doc.getDocumentElement().appendChild(element);
            }
            for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
                Node node = element.getChildNodes().item(i);
                if (node.getNodeType() != 3) continue;
                node.setNodeValue(value);
                return;
            }
            Text newNode = this.doc.createTextNode(value);
            element.appendChild(newNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setValue(String[] path, String value) {
        int i;
        Element element = this.doc.getDocumentElement();
        NodeList nodeList = null;
        Element newElement = null;
        Text newNode = null;
        for (i = 0; i < path.length; ++i) {
            nodeList = this.doc.getElementsByTagName(path[i]);
            if (nodeList.getLength() == 0) {
                newElement = this.doc.createElement(path[i]);
                element.appendChild(newElement);
                element = newElement;
                continue;
            }
            element = (Element)nodeList.item(0);
        }
        try {
            for (i = 0; i < element.getChildNodes().getLength(); ++i) {
                Node node = element.getChildNodes().item(i);
                if (node.getNodeType() != 3) continue;
                node.setNodeValue(value);
                return;
            }
            newNode = this.doc.createTextNode(value);
            element.appendChild(newNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void removeElement(Element base, String tag) {
        Element[] elements = this.getElements(base, tag);
        if (elements == null) {
            return;
        }
        for (int i = 0; i < elements.length; ++i) {
            try {
                base.removeChild(elements[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void removeElement(String tag) {
        Element base = this.doc.getDocumentElement();
        this.removeElement(base, tag);
    }

    protected Element addElement(Element base, String tag, String value) {
        Element element = this.doc.createElement(tag);
        base.appendChild(element);
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Node node = element.getChildNodes().item(i);
            if (node.getNodeType() != 3) continue;
            node.setNodeValue(value);
            return element;
        }
        Text newNode = this.doc.createTextNode(value);
        element.appendChild(newNode);
        return element;
    }

    protected Element addElement(Element base, String tag) {
        Element element = this.doc.createElement(tag);
        base.appendChild(element);
        return element;
    }

    protected Element addElement(String tag) {
        Element element = this.doc.createElement(tag);
        this.doc.getDocumentElement().appendChild(element);
        return element;
    }
}

