/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.utils.Orderable;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTablePanel;
import org.zaproxy.zap.view.AbstractMultipleOrderedOptionsBaseTableModel;

public abstract class AbstractMultipleOrderedOptionsBaseTablePanel<E extends Orderable>
extends AbstractMultipleOptionsBaseTablePanel<E> {
    private static final long serialVersionUID = 8297404899024654579L;
    private JButton moveTopButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton moveBottomButton;

    public AbstractMultipleOrderedOptionsBaseTablePanel(AbstractMultipleOrderedOptionsBaseTableModel<E> model) {
        this(model, true);
    }

    protected AbstractMultipleOrderedOptionsBaseTablePanel(AbstractMultipleOrderedOptionsBaseTableModel<E> model, boolean allowModification) {
        super(model, allowModification);
    }

    protected void addMoveButtons() {
        this.addButtonSpacer();
        this.moveTopButton = new JButton(Constant.messages.getString("multiple.options.panel.ordered.move.top.button.label"));
        this.moveTopButton.setToolTipText(Constant.messages.getString("multiple.options.panel.ordered.move.top.button.tooltip"));
        this.moveTopButton.setEnabled(false);
        this.moveTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AbstractMultipleOrderedOptionsBaseTableModel)AbstractMultipleOrderedOptionsBaseTablePanel.this.getMultipleOptionsModel()).moveTop(AbstractMultipleOrderedOptionsBaseTablePanel.this.getSelectedRow());
                int finalRow = AbstractMultipleOrderedOptionsBaseTablePanel.this.getTable().convertRowIndexToView(0);
                AbstractMultipleOrderedOptionsBaseTablePanel.this.getTable().getSelectionModel().setSelectionInterval(finalRow, finalRow);
            }
        });
        this.addButton(this.moveTopButton);
        this.moveUpButton = new JButton(Constant.messages.getString("multiple.options.panel.ordered.move.up.button.label"));
        this.moveUpButton.setToolTipText(Constant.messages.getString("multiple.options.panel.ordered.move.up.button.tooltip"));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbstractMultipleOrderedOptionsBaseTablePanel.this.getSelectedRow();
                ((AbstractMultipleOrderedOptionsBaseTableModel)AbstractMultipleOrderedOptionsBaseTablePanel.this.getMultipleOptionsModel()).moveUp(row);
                int finalRow = AbstractMultipleOrderedOptionsBaseTablePanel.this.getTable().convertRowIndexToView(row - 1);
                AbstractMultipleOrderedOptionsBaseTablePanel.this.getTable().getSelectionModel().setSelectionInterval(finalRow, finalRow);
            }
        });
        this.addButton(this.moveUpButton);
        this.moveDownButton = new JButton(Constant.messages.getString("multiple.options.panel.ordered.move.down.button.label"));
        this.moveDownButton.setToolTipText(Constant.messages.getString("multiple.options.panel.ordered.move.down.button.tooltip"));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbstractMultipleOrderedOptionsBaseTablePanel.this.getSelectedRow();
                ((AbstractMultipleOrderedOptionsBaseTableModel)AbstractMultipleOrderedOptionsBaseTablePanel.this.getMultipleOptionsModel()).moveDown(row);
                int finalRow = AbstractMultipleOrderedOptionsBaseTablePanel.this.getTable().convertRowIndexToView(row + 1);
                AbstractMultipleOrderedOptionsBaseTablePanel.this.getTable().getSelectionModel().setSelectionInterval(finalRow, finalRow);
            }
        });
        this.addButton(this.moveDownButton);
        this.moveBottomButton = new JButton(Constant.messages.getString("multiple.options.panel.ordered.move.bottom.button.label"));
        this.moveBottomButton.setToolTipText(Constant.messages.getString("multiple.options.panel.ordered.move.bottom.button.tooltip"));
        this.moveBottomButton.setEnabled(false);
        this.moveBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AbstractMultipleOrderedOptionsBaseTableModel)AbstractMultipleOrderedOptionsBaseTablePanel.this.getMultipleOptionsModel()).moveBottom(AbstractMultipleOrderedOptionsBaseTablePanel.this.getSelectedRow());
                int finalRow = AbstractMultipleOrderedOptionsBaseTablePanel.this.getTable().convertRowIndexToView(AbstractMultipleOrderedOptionsBaseTablePanel.this.getModel().getRowCount() - 1);
                AbstractMultipleOrderedOptionsBaseTablePanel.this.getTable().getSelectionModel().setSelectionInterval(finalRow, finalRow);
            }
        });
        this.addButton(this.moveBottomButton);
        this.addButtonSpacer();
    }

    @Override
    protected AbstractMultipleOrderedOptionsBaseTableModel<E> getMultipleOptionsModel() {
        return (AbstractMultipleOrderedOptionsBaseTableModel)super.getMultipleOptionsModel();
    }

    @Override
    public void setComponentEnabled(boolean enabled) {
        boolean enable;
        super.setComponentEnabled(enabled);
        boolean bl = enable = enabled && this.getTable().getSelectionModel().getMinSelectionIndex() >= 0;
        if (enable) {
            this.updateMoveButtons();
        } else {
            this.disableMoveButtons();
        }
    }

    @Override
    protected void selectionChanged(boolean entrySelected) {
        super.selectionChanged(entrySelected);
        if (!entrySelected) {
            this.disableMoveButtons();
        }
        this.updateMoveButtons();
    }

    protected void updateMoveButtons() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1 || this.getModel().getRowCount() == 1) {
            this.disableMoveButtons();
            return;
        }
        int positionSelected = ((Orderable)this.getMultipleOptionsModel().getElement(selectedRow)).getOrder();
        if (positionSelected == 1) {
            this.moveTopButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(true);
            this.moveBottomButton.setEnabled(true);
        } else if (positionSelected == this.getModel().getRowCount()) {
            this.moveTopButton.setEnabled(true);
            this.moveUpButton.setEnabled(true);
            this.moveDownButton.setEnabled(false);
            this.moveBottomButton.setEnabled(false);
        } else {
            this.moveTopButton.setEnabled(true);
            this.moveUpButton.setEnabled(true);
            this.moveDownButton.setEnabled(true);
            this.moveBottomButton.setEnabled(true);
        }
    }

    protected void disableMoveButtons() {
        this.moveTopButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        this.moveBottomButton.setEnabled(false);
    }
}

