function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment, useEffect } from 'react';
import PropTypes from "prop-types";
import classnames from 'classnames';
import { keys, EuiWindowEvent } from '../../services';
import { EuiFocusTrap } from '../focus_trap';
import { EuiOverlayMask } from '../overlay_mask';
import { EuiButtonIcon } from '../button';
import { EuiI18n } from '../i18n';
var sizeToClassNameMap = {
  s: 'euiFlyout--small',
  m: 'euiFlyout--medium',
  l: 'euiFlyout--large'
};
export var EuiFlyout = function EuiFlyout(_ref) {
  var className = _ref.className,
      children = _ref.children,
      _ref$hideCloseButton = _ref.hideCloseButton,
      hideCloseButton = _ref$hideCloseButton === void 0 ? false : _ref$hideCloseButton,
      onClose = _ref.onClose,
      _ref$ownFocus = _ref.ownFocus,
      ownFocus = _ref$ownFocus === void 0 ? false : _ref$ownFocus,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      closeButtonAriaLabel = _ref.closeButtonAriaLabel,
      _ref$maxWidth = _ref.maxWidth,
      maxWidth = _ref$maxWidth === void 0 ? false : _ref$maxWidth,
      style = _ref.style,
      maskProps = _ref.maskProps,
      rest = _objectWithoutProperties(_ref, ["className", "children", "hideCloseButton", "onClose", "ownFocus", "size", "closeButtonAriaLabel", "maxWidth", "style", "maskProps"]);

  var onKeyDown = function onKeyDown(event) {
    if (event.key === keys.ESCAPE) {
      event.preventDefault();
      onClose();
    }
  };

  useEffect(function () {
    document.body.classList.add('euiBody--hasFlyout');
    return function () {
      document.body.classList.remove('euiBody--hasFlyout');
    };
  });
  var newStyle;
  var widthClassName;

  if (maxWidth === true) {
    widthClassName = 'euiFlyout--maxWidth-default';
  } else if (maxWidth !== false) {
    var value = typeof maxWidth === 'number' ? "".concat(maxWidth, "px") : maxWidth;
    newStyle = _objectSpread(_objectSpread({}, style), {}, {
      maxWidth: value
    });
  }

  var classes = classnames('euiFlyout', sizeToClassNameMap[size], widthClassName, className);
  var closeButton;

  if (onClose && !hideCloseButton) {
    closeButton = /*#__PURE__*/React.createElement(EuiI18n, {
      token: "euiFlyout.closeAriaLabel",
      default: "Close this dialog"
    }, function (closeAriaLabel) {
      return /*#__PURE__*/React.createElement(EuiButtonIcon, {
        className: "euiFlyout__closeButton",
        iconType: "cross",
        color: "text",
        "aria-label": closeButtonAriaLabel || closeAriaLabel,
        onClick: onClose,
        "data-test-subj": "euiFlyoutCloseButton"
      });
    });
  }

  var flyoutContent = /*#__PURE__*/React.createElement("div", _extends({
    role: "dialog",
    className: classes,
    tabIndex: 0,
    style: newStyle || style
  }, rest), closeButton, children); // If ownFocus is set, show an overlay behind the flyout and allow the user
  // to click it to close it.

  var optionalOverlay;

  if (ownFocus) {
    optionalOverlay = /*#__PURE__*/React.createElement(EuiOverlayMask, _extends({
      onClick: onClose,
      headerZindexLocation: "below"
    }, maskProps));
  }

  return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }), optionalOverlay, /*#__PURE__*/React.createElement(EuiFocusTrap, {
    clickOutsideDisables: true
  }, flyoutContent));
};
EuiFlyout.propTypes = {
  onClose: PropTypes.func.isRequired,

  /**
     * Defines the width of the panel
     */
  size: PropTypes.oneOf(["s", "m", "l"]),

  /**
     * Hides the default close button. You must provide another close button somewhere within the flyout.
     */
  hideCloseButton: PropTypes.bool,

  /**
     * Locks the mouse / keyboard focus to within the flyout,
     * and shows an EuiOverlayMask
     */
  ownFocus: PropTypes.bool,

  /**
     * Specify an aria-label for the close button of the flyout.
     * Default is `'Close this dialog'`.
     */
  closeButtonAriaLabel: PropTypes.string,

  /**
     * Sets the max-width of the panel,
     * set to `true` to use the default size,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  maxWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),
  style: PropTypes.any,

  /**
     * Adjustments to the EuiOverlayMask that is added when `ownFocus = true`
     */
  maskProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
       * Function that applies to clicking the mask itself and not the children
       */
    onClick: PropTypes.func,

    /**
       * ReactNode to render as this component's content
       */
    children: PropTypes.node,

    /**
       * Should the mask visually sit above or below the EuiHeader (controlled by z-index)
       */
    headerZindexLocation: PropTypes.oneOf(["above", "below"])
  }),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};