/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.DBFieldIterator;
import db.DBHandle;
import db.Field;
import db.IndexField;
import db.Record;
import db.Schema;
import db.Table;
import ghidra.util.LongIterator;
import java.io.IOException;
import java.util.NoSuchElementException;

public class DBFieldMap {
    private static final Class<?>[] fieldClasses = new Class[0];
    private static final String[] fieldNames = new String[0];
    private static final int BUFFER_SIZE = 16384;
    private DBHandle dbh;
    private Schema schema;
    private Table indexTable;
    private Class<? extends Field> fieldClass;

    public DBFieldMap(Class<? extends Field> fieldClass, int cacheSizeMB) {
        int indexFieldType;
        if (!Field.class.isAssignableFrom(fieldClass)) {
            throw new IllegalArgumentException("Field class expected");
        }
        this.fieldClass = fieldClass;
        try {
            indexFieldType = 0xFFFFFF80 | fieldClass.newInstance().getFieldType();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad Field class: " + e.getMessage());
        }
        IndexField indexKeyField = IndexField.getIndexField((byte)indexFieldType);
        this.schema = new Schema(0, indexKeyField.getClass(), "MapKey", fieldClasses, fieldNames);
        boolean success = false;
        try {
            this.dbh = new DBHandle(16384, cacheSizeMB * 1024 * 1024);
            long txId = this.dbh.startTransaction();
            this.indexTable = this.dbh.createTable("DBFieldMap", this.schema);
            this.dbh.endTransaction(txId, true);
            success = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!success && this.dbh != null) {
                this.dbh.close();
                this.dbh = null;
            }
        }
    }

    public void dispose() {
        if (this.dbh != null) {
            this.dbh.close();
            this.dbh = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void addEntry(Field fieldValue, long longValue) {
        if (!this.fieldClass.isInstance(fieldValue)) {
            throw new IllegalArgumentException("Instance of " + this.fieldClass.getName() + " expected");
        }
        IndexField indexField = IndexField.getIndexField(fieldValue, longValue);
        Record rec = this.schema.createRecord(indexField);
        try {
            long txId = this.dbh.startTransaction();
            this.indexTable.putRecord(rec);
            this.dbh.endTransaction(txId, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean deleteEntry(Field fieldValue, long longValue) {
        if (!this.fieldClass.isInstance(fieldValue)) {
            throw new IllegalArgumentException("Instance of " + this.fieldClass.getName() + " expected");
        }
        IndexField indexField = IndexField.getIndexField(fieldValue, longValue);
        try {
            long txId = this.dbh.startTransaction();
            boolean success = this.indexTable.deleteRecord(indexField);
            this.dbh.endTransaction(txId, true);
            return success;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    boolean hasEntry(Field fieldValue, long longValue) {
        if (!this.fieldClass.isInstance(fieldValue)) {
            throw new IllegalArgumentException("Instance of " + this.fieldClass.getName() + " expected");
        }
        IndexField indexField = IndexField.getIndexField(fieldValue, longValue);
        try {
            return this.indexTable.hasRecord(indexField);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LongIterator iterator() {
        return new MapLongIterator();
    }

    private class MapLongIterator
    implements LongIterator {
        DBFieldIterator indexIterator;

        MapLongIterator() {
            try {
                this.indexIterator = DBFieldMap.this.indexTable.fieldKeyIterator();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean hasNext() {
            try {
                return this.indexIterator.hasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public long next() {
            try {
                IndexField indexField = (IndexField)this.indexIterator.next();
                if (indexField == null) {
                    throw new NoSuchElementException();
                }
                return indexField.getPrimaryKey();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean hasPrevious() {
            try {
                return this.indexIterator.hasPrevious();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public long previous() {
            try {
                IndexField indexField = (IndexField)this.indexIterator.previous();
                if (indexField == null) {
                    throw new NoSuchElementException();
                }
                return indexField.getPrimaryKey();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

